/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.AbstractRealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.GeomMaths;
import net.imglib2.roi.geom.real.Polyline;
import net.imglib2.roi.geom.real.Polyshape;
import net.imglib2.roi.geom.real.WritablePolyline;
import net.imglib2.roi.util.AbstractRealMaskPoint;
import net.imglib2.roi.util.RealLocalizableRealPositionable;

public class DefaultWritablePolyline
extends AbstractRealInterval
implements WritablePolyline {
    private final ArrayList<double[]> vertices;

    public DefaultWritablePolyline(List<? extends RealLocalizable> vertices) {
        super(GeomMaths.getBoundsReal(vertices));
        this.vertices = new ArrayList(vertices.size());
        for (int i = 0; i < vertices.size(); ++i) {
            double[] p = new double[this.n];
            for (int d = 0; d < this.n; ++d) {
                p[d] = vertices.get(i).getDoublePosition(d);
            }
            this.vertices.add(p);
        }
    }

    @Override
    public boolean test(RealLocalizable l) {
        for (int i = 1; i < this.vertices.size(); ++i) {
            double[] ptTwo;
            double[] ptOne = this.vertices.get(i - 1);
            boolean testLineContains = GeomMaths.lineContains(ptOne, ptTwo = this.vertices.get(i), l, this.n);
            if (!testLineContains) continue;
            return true;
        }
        return false;
    }

    @Override
    public RealLocalizableRealPositionable vertex(int pos) {
        return new PolylineVertex(this.vertices.get(pos));
    }

    @Override
    public int numVertices() {
        return this.vertices.size();
    }

    @Override
    public void addVertex(int index, RealLocalizable vertex) {
        if (vertex.numDimensions() < this.n) {
            throw new IllegalArgumentException("Vertex must have at least" + this.n + " dimensions");
        }
        double[] p = new double[this.n];
        for (int d = 0; d < this.n; ++d) {
            p[d] = vertex.getDoublePosition(d);
        }
        this.vertices.add(index, p);
        this.expandMinMax(p, p);
    }

    @Override
    public void removeVertex(int index) {
        this.vertices.remove(index);
        this.updateMinMax();
    }

    @Override
    public void addVertices(int index, Collection<RealLocalizable> newVertices) {
        this.vertices.addAll(index, newVertices.stream().map(vertex -> {
            if (vertex.numDimensions() < this.n) {
                throw new IllegalArgumentException("Vertex must have at least" + this.n + " dimensions");
            }
            double[] p = new double[this.n];
            for (int d = 0; d < this.n; ++d) {
                p[d] = vertex.getDoublePosition(d);
            }
            return p;
        }).collect(Collectors.toList()));
        int offset = index;
        for (int i = 0; i < newVertices.size(); ++i) {
            double[] vertex2 = this.vertices.get(offset++);
            this.expandMinMax(vertex2, vertex2);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof Polyline && Polyshape.equals(this, (Polyline)obj);
    }

    public int hashCode() {
        return Polyline.hashCode(this);
    }

    private void updateMinMax() {
        Arrays.fill(this.min, Double.POSITIVE_INFINITY);
        Arrays.fill(this.max, Double.NEGATIVE_INFINITY);
        for (double[] vertex : this.vertices) {
            this.expandMinMax(vertex, vertex);
        }
    }

    private void expandMinMax(double[] mn, double[] mx) {
        for (int d = 0; d < this.numDimensions(); ++d) {
            if (mx[d] > this.max[d]) {
                this.max[d] = mx[d];
            }
            if (!(mn[d] < this.min[d])) continue;
            this.min[d] = mn[d];
        }
    }

    private class PolylineVertex
    extends AbstractRealMaskPoint {
        public PolylineVertex(double[] pos) {
            super(pos);
        }

        @Override
        public void updateBounds() {
            DefaultWritablePolyline.this.updateMinMax();
        }
    }
}

