/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geom.real;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.IterableRealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.neighborsearch.NearestNeighborSearch;
import net.imglib2.neighborsearch.NearestNeighborSearchOnIterableRealInterval;
import net.imglib2.roi.geom.real.RealPointCollection;

public class NNSRealPointCollection<L extends RealLocalizable>
extends AbstractEuclideanSpace
implements RealPointCollection<L> {
    protected IterableRealInterval<L> interval;
    protected NearestNeighborSearch<L> search;

    public NNSRealPointCollection(IterableRealInterval<L> interval) {
        this(interval, (NearestNeighborSearch<L>)new NearestNeighborSearchOnIterableRealInterval(interval));
    }

    public NNSRealPointCollection(IterableRealInterval<L> interval, NearestNeighborSearch<L> search) {
        super(interval.numDimensions());
        this.interval = interval;
        if (search == null) {
            throw new NullPointerException("search cannot be null");
        }
        this.search = search;
    }

    @Override
    public boolean test(RealLocalizable l) {
        this.search.search(l);
        return this.search.getSquareDistance() <= 0.0;
    }

    public double realMin(int d) {
        return this.interval.realMax(d);
    }

    @Override
    public void realMin(double[] min) {
        this.interval.realMin(min);
    }

    @Override
    public void realMin(RealPositionable min) {
        this.interval.realMin(min);
    }

    public double realMax(int d) {
        return this.interval.realMax(d);
    }

    @Override
    public void realMax(double[] max) {
        this.interval.realMax(max);
    }

    @Override
    public void realMax(RealPositionable max) {
        this.interval.realMax(max);
    }

    @Override
    public IterableRealInterval<L> points() {
        return this.interval;
    }

    @Override
    public long size() {
        return this.interval.size();
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RealPointCollection && RealPointCollection.equals(this, (RealPointCollection)obj);
    }

    public int hashCode() {
        return RealPointCollection.hashCode(this);
    }
}

