/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;

public class OffsetLocalizable<L extends Localizable>
extends AbstractEuclideanSpace
implements Localizable {
    protected L source;
    protected long[] offset;

    public OffsetLocalizable(L source, long[] offset) {
        super(source.numDimensions());
        this.source = source;
        this.offset = offset;
    }

    public void localize(float[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getFloatPosition(d);
        }
    }

    public void localize(double[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getDoublePosition(d);
        }
    }

    public float getFloatPosition(int d) {
        return this.source.getFloatPosition(d) + (float)this.offset[d];
    }

    public double getDoublePosition(int d) {
        return this.source.getDoublePosition(d) + (double)this.offset[d];
    }

    public void localize(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getIntPosition(d);
        }
    }

    public void localize(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.getLongPosition(d);
        }
    }

    public int getIntPosition(int d) {
        return (int)((long)this.source.getIntPosition(d) + this.offset[d]);
    }

    public long getLongPosition(int d) {
        return this.source.getLongPosition(d) + this.offset[d];
    }
}

