/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.janelia.saalfeldlab.n5.BlockWriter;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;

public interface DefaultBlockWriter
extends BlockWriter {
    public OutputStream getOutputStream(OutputStream var1) throws IOException;

    @Override
    default public <T> void write(DataBlock<T> dataBlock, OutputStream out) throws IOException {
        ByteBuffer buffer = dataBlock.toByteBuffer();
        try (OutputStream deflater = this.getOutputStream(out);){
            deflater.write(buffer.array());
            deflater.flush();
        }
    }

    public static <T> void writeBlock(OutputStream out, DatasetAttributes datasetAttributes, DataBlock<T> dataBlock) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        int mode = datasetAttributes.getDataType() == DataType.OBJECT || dataBlock.getSize() == null ? 2 : (dataBlock.getNumElements() == DataBlock.getNumElements(dataBlock.getSize()) ? 0 : 1);
        dos.writeShort(mode);
        if (mode != 2) {
            dos.writeShort(datasetAttributes.getNumDimensions());
            for (int size : dataBlock.getSize()) {
                dos.writeInt(size);
            }
        }
        if (mode != 0) {
            dos.writeInt(dataBlock.getNumElements());
        }
        dos.flush();
        BlockWriter writer = datasetAttributes.getCompression().getWriter();
        writer.write(dataBlock, out);
    }
}

