/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.DefaultBlockWriter;
import org.janelia.saalfeldlab.n5.GsonKeyValueN5Reader;
import org.janelia.saalfeldlab.n5.GsonN5Writer;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;

public interface GsonKeyValueN5Writer
extends GsonN5Writer,
GsonKeyValueN5Reader {
    default public void setVersion(String path) {
        if (!VERSION.equals(this.getVersion())) {
            this.setAttribute("/", "n5", VERSION.toString());
        }
    }

    public static String initializeContainer(KeyValueAccess keyValueAccess, String basePath) throws IOException {
        String normBasePath = keyValueAccess.normalize(basePath);
        keyValueAccess.createDirectories(normBasePath);
        return normBasePath;
    }

    @Override
    default public void createGroup(String path) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(path);
        try {
            this.getKeyValueAccess().createDirectories(this.absoluteGroupPath(normalPath));
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to create group " + path, e);
        }
    }

    default public void writeAttributes(String normalGroupPath, JsonElement attributes) throws N5Exception {
        try (LockedChannel lock = this.getKeyValueAccess().lockForWriting(this.absoluteAttributesPath(normalGroupPath));){
            GsonUtils.writeAttributes(lock.newWriter(), attributes, this.getGson());
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to write attributes into " + normalGroupPath, e);
        }
    }

    @Override
    default public void setAttributes(String path, JsonElement attributes) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(path);
        if (!this.exists(normalPath)) {
            throw new N5Exception.N5IOException("" + normalPath + " is not a group or dataset.");
        }
        this.writeAttributes(normalPath, attributes);
    }

    default public void writeAttributes(String normalGroupPath, Map<String, ?> attributes) throws N5Exception {
        if (attributes != null && !attributes.isEmpty()) {
            JsonElement root = this.getAttributes(normalGroupPath);
            root = root != null && root.isJsonObject() ? root.getAsJsonObject() : new JsonObject();
            root = GsonUtils.insertAttributes(root, attributes, this.getGson());
            this.writeAttributes(normalGroupPath, root);
        }
    }

    @Override
    default public void setAttributes(String path, Map<String, ?> attributes) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(path);
        if (!this.exists(normalPath)) {
            throw new N5Exception.N5IOException("" + normalPath + " is not a group or dataset.");
        }
        this.writeAttributes(normalPath, attributes);
    }

    @Override
    default public boolean removeAttribute(String groupPath, String attributePath) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(groupPath);
        String absoluteNormalPath = this.getKeyValueAccess().compose(this.getURI(), normalPath);
        String normalKey = N5URI.normalizeAttributePath(attributePath);
        if (!this.getKeyValueAccess().isDirectory(absoluteNormalPath)) {
            return false;
        }
        if (attributePath.equals("/")) {
            this.setAttributes(normalPath, JsonNull.INSTANCE);
            return true;
        }
        JsonElement attributes = this.getAttributes(normalPath);
        if (GsonUtils.removeAttribute(attributes, normalKey) != null) {
            this.setAttributes(normalPath, attributes);
            return true;
        }
        return false;
    }

    @Override
    default public <T> T removeAttribute(String pathName, String key, Class<T> cls) throws N5Exception {
        T obj;
        String normalPath = N5URI.normalizeGroupPath(pathName);
        String normalKey = N5URI.normalizeAttributePath(key);
        JsonElement attributes = this.getAttributes(normalPath);
        try {
            obj = GsonUtils.removeAttribute(attributes, normalKey, cls, this.getGson());
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
        if (obj != null) {
            this.writeAttributes(normalPath, attributes);
        }
        return obj;
    }

    @Override
    default public boolean removeAttributes(String pathName, List<String> attributes) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(pathName);
        boolean removed = false;
        for (String attribute : attributes) {
            String normalKey = N5URI.normalizeAttributePath(attribute);
            removed |= this.removeAttribute(normalPath, normalKey);
        }
        return removed;
    }

    @Override
    default public <T> void writeBlock(String path, DatasetAttributes datasetAttributes, DataBlock<T> dataBlock) throws N5Exception {
        String blockPath = this.absoluteDataBlockPath(N5URI.normalizeGroupPath(path), dataBlock.getGridPosition());
        try (LockedChannel lock = this.getKeyValueAccess().lockForWriting(blockPath);){
            DefaultBlockWriter.writeBlock(lock.newOutputStream(), datasetAttributes, dataBlock);
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to write block " + Arrays.toString(dataBlock.getGridPosition()) + " into dataset " + path, e);
        }
    }

    @Override
    default public boolean remove(String path) throws N5Exception {
        String normalPath = N5URI.normalizeGroupPath(path);
        String groupPath = this.absoluteGroupPath(normalPath);
        try {
            if (this.getKeyValueAccess().isDirectory(groupPath)) {
                this.getKeyValueAccess().delete(groupPath);
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to remove " + path, e);
        }
        return true;
    }

    @Override
    default public boolean deleteBlock(String path, long ... gridPosition) throws N5Exception {
        String blockPath = this.absoluteDataBlockPath(N5URI.normalizeGroupPath(path), gridPosition);
        try {
            if (this.getKeyValueAccess().isFile(blockPath)) {
                this.getKeyValueAccess().delete(blockPath);
            }
        }
        catch (IOException | UncheckedIOException e) {
            throw new N5Exception.N5IOException("Failed to delete block " + Arrays.toString(gridPosition) + " from dataset " + path, e);
        }
        return true;
    }
}

