/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import org.scijava.convert.AbstractConverter;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.util.ArrayUtils;

@Plugin(type=Converter.class, priority=-10000.0)
public class ArrayToStringConverter
extends AbstractConverter<Object, String> {
    @Parameter(required=false)
    private ConvertService convertService;

    @Override
    public boolean canConvert(Class<?> src, Class<?> dest) {
        return src != null && src.isArray() && dest == String.class;
    }

    @Override
    public boolean canConvert(Object src, Class<?> dest) {
        if (this.convertService == null || src == null) {
            return false;
        }
        if (!this.canConvert(src.getClass(), dest)) {
            return false;
        }
        if (Array.getLength(src) == 0) {
            return true;
        }
        return this.convertService.supports(Array.get(src, 0), dest);
    }

    @Override
    public Object convert(Object src, Type dest) {
        Class<?> srcClass = src.getClass();
        if (srcClass == String[].class || srcClass == Character[].class || srcClass == char[].class) {
            src = this.preprocessCharacters(src);
        }
        String elementString = ArrayUtils.toCollection(src).stream().map(object -> this.convertService.convert(object, String.class)).collect(Collectors.joining(", "));
        return "{" + elementString + "}";
    }

    private String[] preprocessStrings(Object src) {
        int numElements = Array.getLength(src);
        String[] processed = new String[numElements];
        for (int i = 0; i < numElements; ++i) {
            processed[i] = this.preprocessString(Array.get(src, i));
        }
        return processed;
    }

    private String preprocessString(Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        s = s.replace("\\", "\\\\");
        s = s.replace("\"", "\\\"");
        return "\"" + s + "\"";
    }

    private String[] preprocessCharacters(Object src) {
        String[] processed = new String[Array.getLength(src)];
        for (int i = 0; i < processed.length; ++i) {
            Object value = Array.get(src, i);
            processed[i] = value == null ? null : value.toString();
        }
        return this.preprocessStrings(processed);
    }

    @Override
    public <T> T convert(Object src, Class<T> dest) {
        Class<T> destType = dest;
        Object converted = this.convert(src, (Type)destType);
        return (T)converted;
    }

    @Override
    public Class<String> getOutputType() {
        return String.class;
    }

    @Override
    public Class<Object> getInputType() {
        return Object.class;
    }
}

