/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.display;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.scijava.Named;
import org.scijava.display.Display;
import org.scijava.display.DisplayService;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPostprocessorPlugin;
import org.scijava.module.process.PostprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PostprocessorPlugin.class, priority=-10000.0)
public class DisplayPostprocessor
extends AbstractPostprocessorPlugin {
    @Parameter(required=false)
    private DisplayService displayService;
    @Parameter(required=false)
    private LogService log;

    @Override
    public void process(Module module) {
        if (this.displayService == null) {
            return;
        }
        for (ModuleItem<?> outputItem : module.getInfo().outputs()) {
            if (module.isOutputResolved(outputItem.getName())) continue;
            Object value = outputItem.getValue(module);
            String name = this.defaultName(outputItem);
            boolean resolved = this.handleOutput(name, value);
            if (!resolved) continue;
            module.resolveOutput(name);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleOutput(String defaultName, Object output) {
        if (output == null) {
            return false;
        }
        if (output instanceof Display) {
            Display display = (Display)output;
            display.update();
            return true;
        }
        boolean addToExisting = this.addToExisting(output);
        ArrayList<Object> displays = new ArrayList<Object>();
        List<Display<?>> existingDisplays = this.displayService.getDisplays(output);
        displays.addAll(existingDisplays);
        if (displays.isEmpty()) {
            Display<?> activeDisplay = this.displayService.getActiveDisplay();
            if (addToExisting && activeDisplay.canDisplay(output)) {
                activeDisplay.display(output);
                displays.add(activeDisplay);
            } else {
                void var7_12;
                Display<?> display;
                void var7_10;
                Object var7_8 = null;
                if (output instanceof Named) {
                    String string = ((Named)output).getName();
                }
                if (var7_10 == null) {
                    String string = defaultName;
                }
                if ((display = this.displayService.createDisplay((String)var7_12, output)) != null) {
                    displays.add(display);
                }
            }
        }
        if (!displays.isEmpty()) {
            for (Display display : displays) {
                display.update();
            }
            return true;
        }
        if (output instanceof Map) {
            Map map = (Map)output;
            for (Object key : map.keySet()) {
                String itemName = key.toString();
                Object itemValue = map.get(key);
                this.handleOutput(itemName, itemValue);
            }
            return true;
        }
        if (output instanceof Collection) {
            Collection collection = (Collection)output;
            for (Object item : collection) {
                this.handleOutput(defaultName, item);
            }
            return true;
        }
        if (this.log != null) {
            String valueClass = output.getClass().getName();
            this.log.warn("Ignoring unsupported output: " + defaultName + " [" + valueClass + "]");
        }
        return false;
    }

    private boolean addToExisting(Object output) {
        return false;
    }

    private String defaultName(ModuleItem<?> item) {
        String label = item.getLabel();
        if (label != null && !label.isEmpty()) {
            return label;
        }
        String name = item.getName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return "Unnamed";
    }
}

