/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import org.scijava.io.ByteBank;
import org.scijava.util.ByteArray;

public class ByteArrayByteBank
implements ByteBank {
    private final ByteArray buffer;
    private long size;

    public ByteArrayByteBank() {
        this(new ByteArray());
    }

    public ByteArrayByteBank(int initialCapacity) {
        this(ByteArrayByteBank.emptyByteArrayOfCapacity(initialCapacity));
    }

    public ByteArrayByteBank(byte[] bytes) {
        this(new ByteArray(bytes));
    }

    public ByteArrayByteBank(ByteArray bytes) {
        this.buffer = bytes;
        this.size = bytes.size();
    }

    @Override
    public long getMaxBufferSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void setBytes(long startpos, byte[] bytes, int offset, int length) {
        this.checkWritePos(startpos, startpos + (long)length);
        int neededCapacity = (int)(this.size + (long)length);
        this.buffer.ensureCapacity(neededCapacity);
        System.arraycopy(bytes, offset, this.buffer.getArray(), (int)startpos, length);
        this.buffer.setSize(neededCapacity);
        this.updateSize(startpos + (long)length);
    }

    @Override
    public void setByte(long pos, byte b) {
        this.checkWritePos(pos, pos);
        this.buffer.ensureCapacity((int)pos);
        if (pos == (long)this.buffer.size()) {
            this.buffer.setSize((int)(pos + 1L));
        }
        this.buffer.setValue((int)pos, b);
        this.updateSize(pos + 1L);
    }

    @Override
    public void clear() {
        this.buffer.clear();
        this.size = 0L;
    }

    @Override
    public byte getByte(long pos) {
        this.checkReadPos(pos, pos);
        return this.buffer.getValue((int)pos);
    }

    @Override
    public int getBytes(long startPos, byte[] b, int offset, int length) {
        this.checkReadPos(startPos, startPos + (long)length);
        int readLength = (int)Math.min(this.size() - startPos, (long)length);
        System.arraycopy(this.buffer.getArray(), (int)startPos, b, offset, readLength);
        return readLength;
    }

    @Override
    public long size() {
        return this.size;
    }

    private void updateSize(long newSize) {
        this.size = newSize > this.size ? newSize : this.size;
    }

    private static ByteArray emptyByteArrayOfCapacity(int capacity) {
        ByteArray byteArray = new ByteArray(new byte[capacity]);
        byteArray.setSize(0);
        return byteArray;
    }
}

