/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.IOException;
import org.scijava.io.handle.AbstractDataHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;

public abstract class AbstractHigherOrderHandle<L extends Location>
extends AbstractDataHandle<L> {
    private DataHandle<L> handle;
    private boolean closed;

    public AbstractHigherOrderHandle(DataHandle<L> handle) {
        this.handle = handle;
        this.set(handle.get());
    }

    @Override
    public boolean isReadable() {
        return !this.closed && this.handle.isReadable();
    }

    @Override
    public boolean isWritable() {
        return !this.closed && this.handle.isWritable();
    }

    @Override
    public long length() throws IOException {
        this.ensureOpen();
        return this.handle.length();
    }

    @Override
    public Class<L> getType() {
        return this.handle.getType();
    }

    @Override
    public boolean exists() throws IOException {
        return this.handle.exists();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.cleanup();
            this.closed = true;
            this.handle.close();
            this.handle = null;
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("This handle is closed!");
        }
    }

    protected abstract void cleanup() throws IOException;

    protected DataHandle<L> handle() {
        return this.handle;
    }
}

