/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.location;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.scijava.io.location.AbstractLocation;
import org.scijava.io.location.BrowsableLocation;

public class FileLocation
extends AbstractLocation
implements BrowsableLocation {
    private final File file;

    public FileLocation(File file) {
        Objects.requireNonNull(file);
        this.file = file;
    }

    public FileLocation(String path) {
        this(new File(path));
    }

    public FileLocation(URI path) {
        this(new File(path));
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public URI getURI() {
        return this.getFile().toURI();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public FileLocation parent() throws IOException {
        return new FileLocation(this.file.getParentFile());
    }

    @Override
    public Set<BrowsableLocation> children() throws IOException {
        this.validateDirectory();
        File[] files = this.file.listFiles();
        if (files == null) {
            return Collections.emptySet();
        }
        HashSet<BrowsableLocation> out = new HashSet<BrowsableLocation>(files.length);
        for (File child : files) {
            out.add(new FileLocation(child));
        }
        return out;
    }

    @Override
    public FileLocation sibling(String path) {
        return new FileLocation(new File(this.file.getParentFile(), path));
    }

    @Override
    public FileLocation child(String name) {
        this.validateDirectory();
        return new FileLocation(new File(this.file, name));
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    private void validateDirectory() {
        if (this.isDirectory()) {
            return;
        }
        throw new IllegalArgumentException("This location does not point to a directory!");
    }
}

