/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.main.console;

import java.util.ArrayList;
import java.util.LinkedList;
import org.scijava.console.AbstractConsoleArgument;
import org.scijava.console.ConsoleArgument;
import org.scijava.log.LogService;
import org.scijava.main.MainService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=ConsoleArgument.class)
public class MainArgument
extends AbstractConsoleArgument {
    @Parameter(required=false)
    private MainService mainService;
    @Parameter(required=false)
    private LogService log;

    public MainArgument() {
        super(2, "--main", "--main-class");
    }

    @Override
    public void handle(LinkedList<String> args) {
        if (!this.supports(args)) {
            return;
        }
        args.removeFirst();
        String className = args.removeFirst();
        ArrayList<String> argList = new ArrayList<String>();
        while (!(args.isEmpty() || this.isFlag(args) || this.isSeparator(args))) {
            argList.add(args.removeFirst());
        }
        if (this.isSeparator(args)) {
            args.removeFirst();
        }
        String[] mainArgs = argList.toArray(new String[argList.size()]);
        this.mainService.addMain(className, mainArgs);
    }

    @Override
    public boolean supports(LinkedList<String> args) {
        return this.mainService != null && super.supports(args);
    }

    private boolean isSeparator(LinkedList<String> args) {
        if (args == null || args.isEmpty()) {
            return false;
        }
        return args.getFirst().equals("--");
    }
}

