/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.scijava.AbstractUIDetails;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.util.Types;

public abstract class AbstractModuleInfo
extends AbstractUIDetails
implements ModuleInfo {
    private HashMap<String, ModuleItem<?>> inputMap;
    private HashMap<String, ModuleItem<?>> outputMap;
    private ArrayList<ModuleItem<?>> inputList;
    private ArrayList<ModuleItem<?>> outputList;
    private boolean initialized;

    @Override
    public ModuleItem<?> getInput(String name) {
        return this.inputMap().get(name);
    }

    @Override
    public <T> ModuleItem<T> getInput(String name, Class<T> type) {
        return this.castItem(this.getInput(name), type);
    }

    @Override
    public ModuleItem<?> getOutput(String name) {
        return this.outputMap().get(name);
    }

    @Override
    public <T> ModuleItem<T> getOutput(String name, Class<T> type) {
        return this.castItem(this.getOutput(name), type);
    }

    @Override
    public Iterable<ModuleItem<?>> inputs() {
        return Collections.unmodifiableList(this.inputList());
    }

    @Override
    public Iterable<ModuleItem<?>> outputs() {
        return Collections.unmodifiableList(this.outputList());
    }

    protected void parseParameters() {
    }

    protected void clearParameters() {
        this.inputMap.clear();
        this.outputMap.clear();
        this.inputList.clear();
        this.outputList.clear();
    }

    protected void registerInput(ModuleItem<?> input) {
        this.inputMap.put(input.getName(), input);
        this.inputList.add(input);
    }

    protected void registerOutput(ModuleItem<?> output) {
        this.outputMap.put(output.getName(), output);
        this.outputList.add(output);
    }

    protected Map<String, ModuleItem<?>> inputMap() {
        if (!this.initialized) {
            this.initParameters();
        }
        return this.inputMap;
    }

    protected Map<String, ModuleItem<?>> outputMap() {
        if (!this.initialized) {
            this.initParameters();
        }
        return this.outputMap;
    }

    protected List<ModuleItem<?>> inputList() {
        if (!this.initialized) {
            this.initParameters();
        }
        return this.inputList;
    }

    protected List<ModuleItem<?>> outputList() {
        if (!this.initialized) {
            this.initParameters();
        }
        return this.outputList;
    }

    private <T> ModuleItem<T> castItem(ModuleItem<?> item, Class<T> type) {
        Class<?> itemType = item.getType();
        Class<?> saneItemType = Types.box(itemType);
        if (!Types.isAssignable(type, saneItemType)) {
            throw new IllegalArgumentException("Type " + type.getName() + " is incompatible with item of type " + itemType.getName());
        }
        ModuleItem<?> typedItem = item;
        return typedItem;
    }

    private synchronized void initParameters() {
        if (this.initialized) {
            return;
        }
        this.inputMap = new HashMap();
        this.outputMap = new HashMap();
        this.inputList = new ArrayList();
        this.outputList = new ArrayList();
        this.parseParameters();
        this.initialized = true;
    }
}

