/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugin;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.scijava.Prioritized;
import org.scijava.Priority;
import org.scijava.plugin.PluginIndex;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.SciJavaPlugin;
import org.scijava.service.SciJavaService;

public interface PluginService
extends SciJavaService {
    public PluginIndex getIndex();

    public void reloadPlugins();

    public void addPlugin(PluginInfo<?> var1);

    public <T extends PluginInfo<?>> void addPlugins(Collection<T> var1);

    public void removePlugin(PluginInfo<?> var1);

    public <T extends PluginInfo<?>> void removePlugins(Collection<T> var1);

    public List<PluginInfo<?>> getPlugins();

    public <P extends SciJavaPlugin> PluginInfo<SciJavaPlugin> getPlugin(Class<P> var1);

    public <PT extends SciJavaPlugin, P extends PT> PluginInfo<PT> getPlugin(Class<P> var1, Class<PT> var2);

    public PluginInfo<SciJavaPlugin> getPlugin(String var1);

    public <PT extends SciJavaPlugin> List<PluginInfo<PT>> getPluginsOfType(Class<PT> var1);

    public <P extends SciJavaPlugin> List<PluginInfo<SciJavaPlugin>> getPluginsOfClass(Class<P> var1);

    public <PT extends SciJavaPlugin, P extends PT> List<PluginInfo<PT>> getPluginsOfClass(Class<P> var1, Class<PT> var2);

    public List<PluginInfo<SciJavaPlugin>> getPluginsOfClass(String var1);

    public <PT extends SciJavaPlugin> List<PluginInfo<SciJavaPlugin>> getPluginsOfClass(String var1, Class<PT> var2);

    public <PT extends SciJavaPlugin> List<PT> createInstancesOfType(Class<PT> var1);

    public <PT extends SciJavaPlugin> List<PT> createInstances(List<PluginInfo<PT>> var1);

    public <PT extends SciJavaPlugin> PT createInstance(PluginInfo<PT> var1);

    default public <PT extends SciJavaPlugin> void sort(List<PT> instances, Class<PT> type) {
        List<PluginInfo<PT>> plugins = this.getPluginsOfType(type);
        Map infos = plugins.stream().collect(Collectors.toMap(PluginInfo::getPluginClass, Function.identity()));
        Comparator comparator = (o1, o2) -> Priority.compare((Prioritized)infos.get(o1.getClass()), (Prioritized)infos.get(o2.getClass()));
        Collections.sort(instances, comparator);
    }
}

