/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.dnd;

import java.util.List;
import org.scijava.display.Display;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.ui.dnd.AbstractDragAndDropHandler;
import org.scijava.ui.dnd.DragAndDropHandler;
import org.scijava.ui.dnd.DragAndDropService;

@Plugin(type=DragAndDropHandler.class)
public class ListDragAndDropHandler
extends AbstractDragAndDropHandler<List<?>> {
    @Parameter(required=false)
    private DragAndDropService dragAndDropService;

    @Override
    public boolean supports(List<?> list, Display<?> display) {
        if (this.dragAndDropService == null) {
            return false;
        }
        if (!super.supports(list, display)) {
            return false;
        }
        if (list.size() == 0) {
            return true;
        }
        for (Object item : list) {
            if (!this.dragAndDropService.supports(item, display)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean drop(List<?> list, Display<?> display) {
        if (this.dragAndDropService == null) {
            return false;
        }
        this.check(list, display);
        if (list == null) {
            return true;
        }
        if (list.size() == 0) {
            return true;
        }
        boolean success = false;
        for (Object item : list) {
            boolean result;
            if (!this.dragAndDropService.supports(item, display) || !(result = this.dragAndDropService.drop(item, display))) continue;
            success = true;
        }
        return success;
    }

    @Override
    public Class<List<?>> getType() {
        return List.class;
    }
}

