/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InverseRealTransform;
import net.imglib2.realtransform.InvertibleRealTransform;

public final class SphericalToCartesianTransform3D
implements InvertibleRealTransform {
    private static final SphericalToCartesianTransform3D instance = new SphericalToCartesianTransform3D();
    private final InverseRealTransform inverse = new InverseRealTransform(this);

    public static SphericalToCartesianTransform3D getInstance() {
        return instance;
    }

    private SphericalToCartesianTransform3D() {
    }

    private static double x(double r, double inclination, double azimuth) {
        return r * Math.sin(inclination) * Math.cos(azimuth);
    }

    private static double y(double r, double inclination, double azimuth) {
        return r * Math.sin(inclination) * Math.sin(azimuth);
    }

    private static double z(double r, double inclination) {
        return r * Math.cos(inclination);
    }

    private static double r(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    private static double inclination(double x, double y, double z) {
        return Math.acos(z / SphericalToCartesianTransform3D.r(x, y, z));
    }

    private static double azimuth(double x, double y) {
        return Math.atan2(y, x);
    }

    @Override
    public int numSourceDimensions() {
        return 3;
    }

    @Override
    public int numTargetDimensions() {
        return 3;
    }

    @Override
    public void apply(double[] source, double[] target) {
        double r = source[0];
        double inclination = source[1];
        double azimuth = source[2];
        target[0] = SphericalToCartesianTransform3D.x(r, inclination, azimuth);
        target[1] = SphericalToCartesianTransform3D.y(r, inclination, azimuth);
        target[2] = SphericalToCartesianTransform3D.z(r, inclination);
    }

    @Override
    public void apply(float[] source, float[] target) {
        double r = source[0];
        double inclination = source[1];
        double azimuth = source[2];
        target[0] = (float)SphericalToCartesianTransform3D.x(r, inclination, azimuth);
        target[1] = (float)SphericalToCartesianTransform3D.y(r, inclination, azimuth);
        target[2] = (float)SphericalToCartesianTransform3D.z(r, inclination);
    }

    @Override
    public void apply(RealLocalizable source, RealPositionable target) {
        double r = source.getDoublePosition(0);
        double inclination = source.getDoublePosition(1);
        double azimuth = source.getDoublePosition(2);
        target.setPosition(SphericalToCartesianTransform3D.x(r, inclination, azimuth), 0);
        target.setPosition(SphericalToCartesianTransform3D.y(r, inclination, azimuth), 1);
        target.setPosition(SphericalToCartesianTransform3D.z(r, inclination), 2);
    }

    @Override
    public void applyInverse(double[] source, double[] target) {
        double x = target[0];
        double y = target[1];
        double z = target[2];
        source[0] = SphericalToCartesianTransform3D.r(x, y, z);
        source[1] = SphericalToCartesianTransform3D.inclination(x, y, z);
        source[2] = SphericalToCartesianTransform3D.azimuth(x, y);
    }

    @Override
    public void applyInverse(float[] source, float[] target) {
        double x = target[0];
        double y = target[1];
        double z = target[2];
        source[0] = (float)SphericalToCartesianTransform3D.r(x, y, z);
        source[1] = (float)SphericalToCartesianTransform3D.inclination(x, y, z);
        source[2] = (float)SphericalToCartesianTransform3D.azimuth(x, y);
    }

    @Override
    public void applyInverse(RealPositionable source, RealLocalizable target) {
        double x = target.getDoublePosition(0);
        double y = target.getDoublePosition(1);
        double z = target.getDoublePosition(2);
        source.setPosition(SphericalToCartesianTransform3D.r(x, y, z), 0);
        source.setPosition(SphericalToCartesianTransform3D.inclination(x, y, z), 1);
        source.setPosition(SphericalToCartesianTransform3D.azimuth(x, y), 2);
    }

    @Override
    public InvertibleRealTransform inverse() {
        return this.inverse;
    }

    @Override
    public SphericalToCartesianTransform3D copy() {
        return this;
    }
}

