/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.uploaders.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.imagej.plugins.uploaders.ssh.SFTPOperations;
import net.imagej.plugins.uploaders.ssh.SSHSessionCreator;
import net.imagej.updater.AbstractUploader;
import net.imagej.updater.FilesUploader;
import net.imagej.updater.Uploadable;
import net.imagej.updater.Uploader;
import net.imagej.updater.util.UpdateCanceledException;
import net.imagej.updater.util.UpdaterUserInterface;
import org.scijava.log.LogService;
import org.scijava.plugin.Plugin;

@Plugin(type=Uploader.class)
public final class SFTPFileUploader
extends AbstractUploader {
    private SFTPOperations sftp;
    protected LogService log;

    public boolean login(FilesUploader uploader) {
        this.log = uploader.getLog();
        if (!super.login(uploader)) {
            return false;
        }
        Session session = SSHSessionCreator.getSession(uploader);
        if (session == null) {
            return false;
        }
        try {
            this.sftp = new SFTPOperations(session);
            return true;
        }
        catch (JSchException e) {
            this.log.error((Throwable)e);
            return false;
        }
    }

    public void logout() {
        try {
            this.disconnectSession();
        }
        catch (IOException e) {
            this.log.error((Throwable)e);
        }
    }

    public synchronized void upload(List<Uploadable> sources, List<String> locks) throws IOException {
        this.timestamp = this.remoteTimeStamp();
        this.setTitle("Uploading");
        try {
            this.uploadFiles(sources);
        }
        catch (UpdateCanceledException cancel) {
            for (String lock : locks) {
                String path = this.uploadDir + lock + ".lock";
                try {
                    this.sftp.rm(path);
                }
                catch (IOException iOException) {}
            }
            throw cancel;
        }
        for (String lock : locks) {
            String src = this.uploadDir + lock + ".lock";
            String dest = this.uploadDir + lock;
            this.sftp.rename(src, dest);
        }
        this.disconnectSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFiles(List<Uploadable> uploadables) throws IOException {
        this.calculateTotalSize(uploadables);
        int sizeOfFilesUploadedSoFar = 0;
        for (Uploadable uploadable : uploadables) {
            String target = uploadable.getFilename();
            this.addItem(uploadable);
            InputStream input = uploadable.getInputStream();
            final int currentFileSize = (int)uploadable.getFilesize();
            String dest = this.uploadDir + target;
            try {
                UpdaterUserInterface.get().log("Upload '" + uploadable.getFilename() + "', size " + uploadable.getFilesize());
                final int uploadedBytesCount = sizeOfFilesUploadedSoFar;
                SFTPOperations.ProgressListener listener = new SFTPOperations.ProgressListener(){

                    @Override
                    public void progress(long currentCount) {
                        SFTPFileUploader.this.setItemCount((int)currentCount, currentFileSize);
                        SFTPFileUploader.this.setCount(uploadedBytesCount + (int)currentCount, SFTPFileUploader.this.total);
                    }
                };
                this.sftp.put(input, dest, listener);
            }
            finally {
                input.close();
            }
            this.setItemCount(currentFileSize, currentFileSize);
            this.setCount(sizeOfFilesUploadedSoFar += currentFileSize, this.total);
            this.itemDone(uploadable);
        }
        this.done();
    }

    void disconnectSession() throws IOException {
        this.sftp.disconnect();
    }

    private long remoteTimeStamp() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream("".getBytes());
        String destFile = this.uploadDir + "timestamp";
        this.sftp.put(in, destFile);
        long timestamp = this.sftp.timestamp(destFile);
        this.sftp.rm(destFile);
        return timestamp;
    }

    public String getProtocol() {
        return "sftp";
    }
}

