/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.io.Opener;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.PlugInFrame;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.ShortProcessor;
import ij.process.TypeConverter;
import java.awt.Button;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;

class StackSorter
extends PlugInFrame
implements ActionListener,
Measurements {
    Panel panel;
    static Frame instance;
    ImagePlus imp = null;
    ImageStack stack = null;
    int numSlices;
    int slice;
    protected Label label1;
    boolean doScaling = true;
    static int QUIT;
    static int CROP;
    static int SHRINK_SOURCE;
    static int EXPAND_DEST_BORDER;
    static int RESIZE_DEST;

    public StackSorter() {
        super("Stack Sorter");
        if (instance != null) {
            instance.toFront();
            return;
        }
        if (IJ.versionLessThan((String)"1.32c")) {
            IJ.error((String)"This version of Stack Sorter requires ImageJ 1.32c or later.");
            return;
        }
        instance = this;
        this.setLayout(new FlowLayout(1, 5, 5));
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(18, 1, 5, 5));
        this.addLabel("Operate on slice");
        this.addButton("<< First");
        this.addButton("<");
        this.addButton(">");
        this.addButton(">> Last");
        this.addButton("Duplicate");
        this.addButton("Duplicate n");
        this.addButton("Insert");
        this.addButton("Insert File");
        this.addButton("Insert URL");
        this.addButton("Paste (system)");
        this.addButton("Delete");
        this.addButton("Delete n");
        this.addLabel("Whole stack");
        this.addButton("Label Slices");
        this.addButton("Sort by Label");
        this.addButton("Sort by Mean");
        this.addButton("Reverse");
        this.add(this.panel);
        this.pack();
        this.show();
    }

    void addButton(String label) {
        Button b = new Button(label);
        b.addActionListener(this);
        this.panel.add(b);
    }

    void addLabel(String label) {
        Label l = new Label(label, 1);
        this.panel.add(l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String label = e.getActionCommand();
        if (label == null) {
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            if (label.equals("Insert File")) {
                ImagePlus imp;
                String path = this.getFileName();
                if (path != null && (imp = new Opener().openImage(path)) != null) {
                    imp.show();
                }
            } else if (label.equals("Insert URL")) {
                ImagePlus imp = this.getImagePlusFromURL();
                if (imp != null) {
                    imp.show();
                }
            } else if (label.equals("Paste (system)")) {
                ImagePlus imp = this.getSystemClipboardImage();
                if (imp != null) {
                    imp.show();
                }
            } else {
                IJ.noImage();
            }
        } else {
            this.numSlices = this.imp.getStackSize();
            this.slice = this.imp.getCurrentSlice();
            if (!(this.numSlices >= 2 || label.equals("Duplicate") || label.equals("Duplicate n") || label.equals("Insert") || label.equals("Insert File") || label.equals("Paste (system)") || label.equals("Insert URL"))) {
                IJ.showMessage((String)"Stack required");
            } else {
                this.stack = this.imp.getStack();
                if (label.equals("<< First")) {
                    this.first();
                } else if (label.equals("<")) {
                    this.fwd();
                } else if (label.equals(">")) {
                    this.bkwd();
                } else if (label.equals(">> Last")) {
                    this.last();
                } else if (label.equals("Duplicate")) {
                    this.dup();
                } else if (label.equals("Duplicate n")) {
                    this.dupN();
                } else if (label.equals("Insert")) {
                    this.ins();
                } else if (label.equals("Insert File")) {
                    this.insf();
                } else if (label.equals("Insert URL")) {
                    this.insURL();
                } else if (label.equals("Paste (system)")) {
                    this.pasteSys();
                } else if (label.equals("Delete")) {
                    this.del();
                } else if (label.equals("Delete n")) {
                    this.delN();
                } else if (label.equals("Sort by Label")) {
                    this.sortByLabel();
                } else if (label.equals("Sort by Mean")) {
                    this.sortByMean();
                } else if (label.equals("Label Slices")) {
                    this.labelSlices();
                } else if (label.equals("Reverse")) {
                    this.reverse();
                }
            }
        }
    }

    void labelSlices() {
        for (int iSlice = 1; iSlice <= this.numSlices; ++iSlice) {
            String title = "" + iSlice;
            if (iSlice < 10) {
                title = "00000" + title;
            } else if (iSlice < 100) {
                title = "0000" + title;
            } else if (iSlice < 1000) {
                title = "000" + title;
            } else if (iSlice < 10000) {
                title = "00" + title;
            } else if (iSlice < 100000) {
                title = "0" + title;
            }
            this.stack.setSliceLabel(title, iSlice);
        }
        this.imp.setStack(null, this.stack);
        this.imp.updateAndDraw();
    }

    void reverse() {
        for (int iSlice = 1; iSlice < this.numSlices; ++iSlice) {
            this.stack.addSlice(this.stack.getSliceLabel(1), this.stack.getProcessor(1), this.numSlices - iSlice + 1);
            this.stack.deleteSlice(1);
        }
        this.imp.setStack(null, this.stack);
        this.imp.updateAndDraw();
    }

    void sortByLabel() {
        boolean swapped = false;
        for (int pass = 0; pass < this.numSlices; ++pass) {
            for (int iSlice = 1; iSlice < this.numSlices - pass; ++iSlice) {
                int comp = this.stack.getSliceLabel(iSlice).compareTo(this.stack.getSliceLabel(iSlice + 1));
                if (comp <= 0) continue;
                swapped = true;
                this.stack.addSlice(this.stack.getSliceLabel(iSlice), this.stack.getProcessor(iSlice), iSlice + 1);
                this.stack.deleteSlice(iSlice);
            }
            if (!swapped) break;
        }
        this.imp.setStack(null, this.stack);
        this.imp.updateAndDraw();
    }

    void sortByMean() {
        float[] y = this.getZAxisProfile();
        if (y == null) {
            return;
        }
        boolean swapped = false;
        for (int pass = 0; pass < this.numSlices; ++pass) {
            for (int iSlice = 1; iSlice < this.numSlices - pass; ++iSlice) {
                float comp = y[iSlice - 1] - y[iSlice];
                if (!(comp > 0.0f)) continue;
                swapped = true;
                this.stack.addSlice(this.stack.getSliceLabel(iSlice), this.stack.getProcessor(iSlice), iSlice + 1);
                this.stack.deleteSlice(iSlice);
                float temp = y[iSlice - 1];
                y[iSlice - 1] = y[iSlice];
                y[iSlice] = temp;
            }
            if (!swapped) break;
        }
        this.imp.setStack(null, this.stack);
        this.imp.updateAndDraw();
    }

    void first() {
        if (this.slice != 1) {
            this.stack.addSlice(this.stack.getSliceLabel(this.slice), this.stack.getProcessor(this.slice), 0);
            this.stack.deleteSlice(this.slice + 1);
            this.imp.setStack(null, this.stack);
            this.imp.setSlice(1);
            this.imp.updateAndDraw();
        }
    }

    void bkwd() {
        if (this.slice != this.numSlices) {
            this.stack.addSlice(this.stack.getSliceLabel(this.slice), this.stack.getProcessor(this.slice), this.slice + 1);
            this.stack.deleteSlice(this.slice);
            this.imp.setStack(null, this.stack);
            this.imp.setSlice(this.slice + 1);
            this.imp.updateAndDraw();
        }
    }

    void fwd() {
        if (this.slice != 1) {
            this.stack.addSlice(this.stack.getSliceLabel(this.slice), this.stack.getProcessor(this.slice), this.slice - 2);
            this.stack.deleteSlice(this.slice + 1);
            this.imp.setStack(null, this.stack);
            this.imp.setSlice(this.slice - 1);
            this.imp.updateAndDraw();
        }
    }

    void last() {
        if (this.slice != this.numSlices) {
            this.stack.addSlice(this.stack.getSliceLabel(this.slice), this.stack.getProcessor(this.slice), this.numSlices);
            this.stack.deleteSlice(this.slice);
            this.imp.setStack(null, this.stack);
            this.imp.setSlice(this.numSlices);
            this.imp.updateAndDraw();
        }
    }

    void dup() {
        this.stack.addSlice(this.stack.getSliceLabel(this.slice), this.stack.getProcessor(this.slice).duplicate(), this.slice);
        this.imp.setStack(null, this.stack);
        this.imp.setSlice(this.slice + 1);
        this.imp.updateAndDraw();
    }

    void dupN() {
        int n = (int)IJ.getNumber((String)"Number of times to duplicate the slice", (double)1.0);
        for (int i = 0; i < n; ++i) {
            this.dup();
        }
    }

    void ins() {
        ImagePlus imp1 = this.showDialog(this.imp.getTitle());
        this.insImp1(imp1);
    }

    void insf() {
        String path = this.getFileName();
        if (path != null) {
            ImagePlus imp1 = new Opener().openImage(path);
            this.insImp1(imp1);
        }
    }

    void insURL() {
        ImagePlus imp1 = this.getImagePlusFromURL();
        this.insImp1(imp1);
    }

    void pasteSys() {
        ImagePlus imp1 = this.getSystemClipboardImage();
        this.insImp1(imp1);
    }

    ImagePlus getImagePlusFromURL() {
        ImagePlus imp1 = null;
        String url = IJ.getString((String)"URL (or path) for an image", (String)"http://rsb.info.nih.gov/ij/images/clown.gif");
        if (!url.equals("")) {
            imp1 = new ImagePlus(url);
        }
        return imp1;
    }

    ImagePlus getSystemClipboardImage() {
        ImagePlus imp1 = null;
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Clipboard cb = toolkit.getSystemClipboard();
            Transferable trns = cb.getContents(this);
            String name = cb.getName();
            if (trns == null) {
                IJ.showMessage((String)"The system clipboard is empty.");
                return null;
            }
            if (!trns.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                IJ.showMessage((String)"The system clipboard has no usable image.");
                return null;
            }
            Image img = (Image)trns.getTransferData(DataFlavor.imageFlavor);
            if (img != null) {
                imp1 = new ImagePlus(name, img);
            }
        }
        catch (Exception e) {
            IJ.showMessage((String)"Exception with system clipboard.");
        }
        return imp1;
    }

    String getFileName() {
        Frame f = new Frame();
        FileDialog fd = new FileDialog(f, "Image file", 0);
        fd.setVisible(true);
        String path = fd.getDirectory();
        String filename = fd.getFile();
        if (path == null || filename == null) {
            return null;
        }
        return path + filename;
    }

    void insImp1(ImagePlus imp1) {
        if (imp1 == null) {
            return;
        }
        ImageStack stack1 = imp1.getStack();
        int numSlices1 = imp1.getStackSize();
        int slice1 = imp1.getCurrentSlice();
        int maxInsert = numSlices1 - slice1 + 1;
        int nInsert = 1;
        if (maxInsert > 1) {
            nInsert = maxInsert + 1;
            while (nInsert > maxInsert || nInsert < 0) {
                nInsert = (int)IJ.getNumber((String)("Number of slices to insert (max " + maxInsert + ")"), (double)1.0);
                if (nInsert == Integer.MIN_VALUE) {
                    return;
                }
                if (nInsert <= maxInsert && nInsert >= 0) continue;
                IJ.beep();
            }
        }
        if (nInsert == 0) {
            return;
        }
        int w = this.imp.getWidth();
        int h = this.imp.getHeight();
        Rectangle r = imp1.getProcessor().getRoi();
        int w1 = r.width;
        int h1 = r.height;
        int option = CROP;
        if (w1 > w || h1 > h) {
            option = this.showOptionDialog(w1, h1, w, h);
            if (option == QUIT) {
                return;
            }
            if (option == EXPAND_DEST_BORDER) {
                this.expandDestBorder(w1, h1, w, h);
            } else if (option == RESIZE_DEST) {
                this.resizeDest(w1, h1, w, h);
            }
        }
        for (int i = 0; i < nInsert; ++i) {
            ImageProcessor ip0 = stack1.getProcessor(slice1 + i).duplicate();
            ImageProcessor ip1temp = null;
            ip1temp = option == SHRINK_SOURCE ? this.shrink(ip0, w1, h1, w, h) : ip0;
            this.insert(ip1temp, imp1);
        }
    }

    void expandDestBorder(int w1, int h1, int w, int h) {
        int wFinal = w1 > w ? w1 : w;
        int hFinal = h1 > h ? h1 : h;
        ImageStack newStack = new ImageStack(wFinal, hFinal);
        for (int i = 1; i <= this.numSlices; ++i) {
            ImageProcessor ipi2 = this.stack.getProcessor(i).duplicate();
            ImageProcessor ipi = ipi2.resize(wFinal, hFinal);
            ipi.setColor(Toolbar.getBackgroundColor());
            ipi.fill();
            ipi.copyBits(ipi2, (wFinal - w) / 2, (hFinal - h) / 2, 0);
            ipi.setColor(Toolbar.getForegroundColor());
            newStack.addSlice(this.stack.getSliceLabel(i), ipi);
        }
        String title = this.imp.getShortTitle();
        this.stack = newStack;
        Calibration cal = this.imp.getCalibration();
        this.imp.hide();
        this.imp = new ImagePlus(title, this.stack);
        this.imp.setSlice(this.slice);
        this.imp.setCalibration(cal);
        this.imp.show();
    }

    void resizeDest(int w1, int h1, int w, int h) {
        int hFinal;
        int wFinal;
        if ((double)w1 / (double)w > (double)h1 / (double)h) {
            wFinal = w1;
            hFinal = h * w1 / w;
        } else {
            wFinal = w * h1 / h;
            hFinal = h1;
        }
        IJ.run((String)"Size...", (String)("width=" + wFinal + " height=" + hFinal + " constrain interpolate"));
        this.imp = WindowManager.getCurrentImage();
    }

    ImageProcessor shrink(ImageProcessor ip1, int w1, int h1, int w, int h) {
        int hFinal;
        int wFinal;
        if (ip1 == null) {
            return null;
        }
        if ((double)w / (double)w1 < (double)h / (double)h1) {
            wFinal = w;
            hFinal = w * h1 / w1;
        } else {
            wFinal = w1 * h / h1;
            hFinal = h;
        }
        return ip1.resize(wFinal, hFinal);
    }

    void insert(ImageProcessor ip1temp, ImagePlus imp1) {
        IJ.run((String)"Add Slice");
        this.imp.updateAndDraw();
        this.stack = this.imp.getStack();
        ImageProcessor ip = this.stack.getProcessor(this.slice + 1);
        Roi roi = imp1.getRoi();
        ImageProcessor ip1 = this.convertType(ip1temp, ip, this.doScaling);
        ip.setColor(Toolbar.getBackgroundColor());
        ip.fill();
        ip1.setRoi(roi);
        Rectangle r = ip1.getRoi();
        this.clearOutside(ip1, imp1, roi, r);
        if (ip.getWidth() == ip1.getWidth() && ip.getHeight() == ip1.getHeight()) {
            ip.copyBits(ip1, 0, 0, 0);
        } else {
            int x1Cent = r.x + r.width / 2;
            int y1Cent = r.y + r.height / 2;
            int xCent = ip.getWidth() / 2;
            int yCent = ip.getHeight() / 2;
            ip.copyBits(ip1, xCent - x1Cent, yCent - y1Cent, 0);
        }
        ip.setColor(Toolbar.getForegroundColor());
        this.imp.setStack(null, this.stack);
        this.imp.setSlice(++this.slice);
        this.imp.updateAndDraw();
    }

    ImageProcessor convertType(ImageProcessor ip1, ImageProcessor ip, boolean doScaling) {
        ImageProcessor result = null;
        TypeConverter tc = new TypeConverter(ip1, doScaling);
        result = ip instanceof ByteProcessor ? tc.convertToByte() : (ip instanceof FloatProcessor ? ip1.convertToFloat() : (ip instanceof ColorProcessor ? tc.convertToRGB() : (ip instanceof ShortProcessor ? tc.convertToShort() : ip1)));
        return result;
    }

    void del() {
        if (!this.imp.lock()) {
            return;
        }
        ImageStack stack = this.imp.getStack();
        int n = this.imp.getCurrentSlice();
        stack.deleteSlice(n);
        if (stack.getSize() == 1) {
            this.imp.setProcessor(null, stack.getProcessor(1));
            new ImageWindow(this.imp);
        }
        this.imp.setStack(null, stack);
        --this.numSlices;
        if (n > this.numSlices) {
            this.imp.setSlice(this.numSlices);
        } else {
            this.imp.setSlice(n);
        }
        this.imp.unlock();
    }

    void delN() {
        int maxDelete = this.slice == 1 ? this.numSlices - 1 : this.numSlices - this.slice + 1;
        int nDelete = 1;
        if (maxDelete > 1) {
            nDelete = maxDelete + 1;
            while (nDelete > maxDelete || nDelete < 0) {
                nDelete = (int)IJ.getNumber((String)("Number of slices to delete (max " + maxDelete + ")"), (double)1.0);
                if (nDelete == Integer.MIN_VALUE) {
                    return;
                }
                if (nDelete <= maxDelete && nDelete >= 0) continue;
                IJ.beep();
            }
        }
        if (nDelete == 0) {
            return;
        }
        for (int i = 0; i < nDelete; ++i) {
            this.del();
        }
    }

    public void clearOutside(ImageProcessor ip, ImagePlus imp, Roi roi, Rectangle r) {
        if (this.isLineSelection(roi)) {
            return;
        }
        ImageProcessor mask = this.makeMask(ip, r, imp);
        ip.setColor(Toolbar.getBackgroundColor());
        ip.snapshot();
        ip.fill();
        ip.reset(mask);
        int width = ip.getWidth();
        int height = ip.getHeight();
        ip.setRoi(0, 0, r.x, height);
        ip.fill();
        ip.setRoi(r.x, 0, r.width, r.y);
        ip.fill();
        ip.setRoi(r.x, r.y + r.height, r.width, height - (r.y + r.height));
        ip.fill();
        ip.setRoi(r.x + r.width, 0, width - (r.x + r.width), height);
        ip.fill();
        ip.resetRoi();
    }

    boolean isLineSelection(Roi roi) {
        return roi != null && roi.getType() >= 5 && roi.getType() <= 7;
    }

    ImageProcessor makeMask(ImageProcessor ip, Rectangle r, ImagePlus imp) {
        ImageProcessor mask = imp.getMask();
        if (mask == null) {
            mask = new ByteProcessor(r.width, r.height);
            mask.invert();
        } else {
            mask = mask.duplicate();
        }
        mask.invert();
        return mask;
    }

    ImagePlus showDialog(String title) {
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            IJ.noImage();
            return null;
        }
        String[] titles = new String[wList.length];
        int n = titles.length;
        if (n == 1) {
            IJ.showMessage((String)"No image to insert.  Open a second image first, or use Insert File or Paste.");
            return null;
        }
        for (int i = 0; i < wList.length; ++i) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            titles[i] = imp != null ? imp.getTitle() : "";
        }
        String[] titles1 = new String[n - 1];
        int[] wList1 = new int[n - 1];
        int ind = 0;
        for (int i = 0; i < n; ++i) {
            if (title.equals(titles[i])) continue;
            titles1[ind] = titles[i];
            wList1[ind++] = wList[i];
        }
        if (ind != n - 1) {
            IJ.showMessage((String)"The window titles need to be unique for the insert operation to work.");
            return null;
        }
        if (titles1.length == 1) {
            return WindowManager.getImage((int)wList1[0]);
        }
        GenericDialog gd = new GenericDialog("Choose Image");
        gd.addChoice("Image to insert in stack:", titles1, titles1[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        int index = gd.getNextChoiceIndex();
        return WindowManager.getImage((int)wList1[index]);
    }

    int showOptionDialog(int w1, int h1, int w, int h) {
        String[] options = new String[]{"inserting a cropped image", "inserting a reduced size image", "resizing the destination stack by adding border pixels", "resizing the destination stack by scaling it up"};
        GenericDialog gd = new GenericDialog("Options");
        gd.addMessage("The image does not fit. Source: " + w1 + "x" + h1 + " pixels. Dest.: " + w + "x" + h + " pixels.");
        gd.addChoice("Adjust by", options, options[0]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return QUIT;
        }
        return gd.getNextChoiceIndex();
    }

    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
    }

    public void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            instance = null;
        }
    }

    float[] getZAxisProfile() {
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.isLine()) {
            IJ.error((String)"ZAxisProfiler", (String)"This command does not work with line selections.");
            return null;
        }
        ImageProcessor ip = this.imp.getProcessor();
        double minThreshold = ip.getMinThreshold();
        double maxThreshold = ip.getMaxThreshold();
        return this.getZAxisProfile(roi, minThreshold, maxThreshold);
    }

    float[] getZAxisProfile(Roi roi, double minThreshold, double maxThreshold) {
        ImageStack stack = this.imp.getStack();
        int size = stack.getSize();
        float[] values = new float[size];
        Calibration cal = this.imp.getCalibration();
        Analyzer analyzer = new Analyzer(this.imp);
        int measurements = analyzer.getMeasurements();
        boolean showResults = measurements != 0 && measurements != 256;
        boolean showingLabels = (measurements & 0x400) != 0;
        measurements |= 2;
        if (showResults) {
            if (!analyzer.resetCounter()) {
                return null;
            }
        }
        int current = this.imp.getCurrentSlice();
        for (int i = 1; i <= size; ++i) {
            if (showingLabels) {
                this.imp.setSlice(i);
            }
            ImageProcessor ip = stack.getProcessor(i);
            if (minThreshold != -808080.0) {
                ip.setThreshold(minThreshold, maxThreshold, 2);
            }
            ip.setRoi(roi);
            ImageStatistics stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)measurements, (Calibration)cal);
            analyzer.saveResults(stats, roi);
            if (showResults) {
                analyzer.displayResults();
            }
            values[i - 1] = (float)stats.mean;
        }
        if (showingLabels) {
            this.imp.setSlice(current);
        }
        return values;
    }

    static {
        QUIT = -1;
        CROP = 0;
        SHRINK_SOURCE = 1;
        EXPAND_DEST_BORDER = 2;
        RESIZE_DEST = 3;
    }
}

