/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.audioengines.javasound;

import org.jogamp.java3d.audioengines.AuralParameters;
import org.jogamp.java3d.audioengines.javasound.JSPositionalSample;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

class JSDirectionalSample
extends JSPositionalSample {
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, 1.0f);

    void setXformedDirection() {
        if (!this.getVWrldXfrmFlag()) {
            this.xformDirection.set((Tuple3f)this.direction);
        } else {
            this.vworldXfrm.transform(this.direction, this.xformDirection);
        }
    }

    double intersectEllipse(double max, double min) {
        Vector3f xAxis = this.direction;
        Vector3f sourceToHead = this.sourceToCenterEar;
        if (xAxis == null || sourceToHead == null) {
            return -1.0;
        }
        double dotProduct = sourceToHead.dot(xAxis) / (sourceToHead.length() * xAxis.length());
        double theta = (float)Math.acos(dotProduct);
        double minPlusMax = min + max;
        double tangent = Math.tan(theta);
        double xSquared = 1.0 / (4.0 / (minPlusMax * minPlusMax) + tangent * tangent / (min * max));
        double x = Math.sqrt(xSquared);
        double y = tangent * x;
        double ySquared = y * y;
        float distance = (float)Math.sqrt(xSquared + ySquared);
        return distance;
    }

    float findFactor(double distanceToHead, double[] maxDistanceArray, float[] maxFactorArray, double[] minDistanceArray, float[] minFactorArray) {
        if (minDistanceArray == null || minFactorArray == null) {
            return this.findFactor(distanceToHead, maxDistanceArray, maxFactorArray);
        }
        if (maxDistanceArray == null || maxFactorArray == null) {
            return -1.0f;
        }
        int arrayLength = maxDistanceArray.length;
        if (arrayLength < 2) {
            return -1.0f;
        }
        int largestIndex = arrayLength - 1;
        if (distanceToHead >= maxDistanceArray[largestIndex]) {
            return maxFactorArray[largestIndex];
        }
        if (distanceToHead <= minDistanceArray[0]) {
            return minFactorArray[0];
        }
        double[] distanceArray = new double[arrayLength];
        float[] factorArray = new float[arrayLength];
        boolean[] intersectionCalculated = new boolean[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            intersectionCalculated[i] = false;
        }
        boolean intersectionOnEllipse = false;
        int factorIndex = -1;
        int lowIndex = 0;
        int highIndex = largestIndex;
        while (lowIndex < highIndex - 1) {
            if (!intersectionCalculated[lowIndex]) {
                distanceArray[lowIndex] = this.intersectEllipse(maxDistanceArray[lowIndex], minDistanceArray[lowIndex]);
                if (distanceArray[lowIndex] >= 0.0) {
                    intersectionCalculated[lowIndex] = true;
                } else {
                    distanceArray[lowIndex] = (minDistanceArray[lowIndex] + maxDistanceArray[lowIndex]) * 0.5;
                    intersectionCalculated[lowIndex] = true;
                }
            }
            if (!intersectionCalculated[highIndex]) {
                distanceArray[highIndex] = this.intersectEllipse(maxDistanceArray[highIndex], minDistanceArray[highIndex]);
                if (distanceArray[highIndex] >= 0.0) {
                    intersectionCalculated[highIndex] = true;
                } else {
                    distanceArray[highIndex] = (minDistanceArray[highIndex] + maxDistanceArray[highIndex]) * 0.5;
                    intersectionCalculated[highIndex] = true;
                }
            }
            if (distanceArray[lowIndex] >= distanceToHead) {
                if (lowIndex == 0 || distanceToHead < distanceArray[lowIndex]) {
                    // empty if block
                }
                intersectionOnEllipse = true;
                factorIndex = lowIndex;
                break;
            }
            if (distanceArray[highIndex] <= distanceToHead) {
                if (highIndex == largestIndex || distanceToHead > distanceArray[highIndex]) {
                    // empty if block
                }
                intersectionOnEllipse = true;
                factorIndex = highIndex;
                break;
            }
            if (!(distanceToHead > distanceArray[lowIndex]) || !(distanceToHead < distanceArray[highIndex])) continue;
            int indexMid = lowIndex + (highIndex - lowIndex) / 2;
            if (distanceToHead <= distanceArray[indexMid]) {
                highIndex = indexMid;
                continue;
            }
            lowIndex = indexMid;
        }
        if (intersectionOnEllipse && factorIndex >= 0) {
            double returnValue = (distanceArray[factorIndex] - minDistanceArray[factorIndex]) / (maxDistanceArray[factorIndex] - minDistanceArray[factorIndex]) * (double)(maxFactorArray[factorIndex] - minFactorArray[factorIndex]) + (double)minFactorArray[factorIndex];
            return (float)returnValue;
        }
        double highFactorValue = 1.0;
        double lowFactorValue = 0.0;
        highFactorValue = (distanceArray[highIndex] - minDistanceArray[highIndex]) / (maxDistanceArray[highIndex] - minDistanceArray[highIndex]) * (double)(maxFactorArray[highIndex] - minFactorArray[highIndex]) + (double)minFactorArray[highIndex];
        lowFactorValue = (distanceArray[lowIndex] - minDistanceArray[lowIndex]) / (maxDistanceArray[lowIndex] - minDistanceArray[lowIndex]) * (double)(maxFactorArray[lowIndex] - minFactorArray[lowIndex]) + (double)minFactorArray[lowIndex];
        double returnValue = (distanceToHead - distanceArray[lowIndex]) / (distanceArray[highIndex] - distanceArray[lowIndex]) * (highFactorValue - lowFactorValue) + (double)factorArray[lowIndex];
        return (float)returnValue;
    }

    @Override
    float calculateDistanceAttenuation(float distance) {
        float factor = this.findFactor(distance, this.attenuationDistance, this.attenuationGain, this.backAttenuationDistance, this.backAttenuationGain);
        if (factor < 0.0f) {
            return 1.0f;
        }
        return factor;
    }

    @Override
    float calculateAngularGain() {
        float angle = this.findAngularOffset();
        float factor = this.findFactor(angle, this.angularDistance, this.angularGain);
        if (factor < 0.0f) {
            return 1.0f;
        }
        return factor;
    }

    float findAngularOffset() {
        Vector3f unitToEar = new Vector3f();
        Vector3f unitDirection = new Vector3f();
        Point3f xformPosition = this.positions[this.currentIndex];
        Point3f xformCenterEar = this.centerEars[this.currentIndex];
        unitToEar.x = xformCenterEar.x - xformPosition.x;
        unitToEar.y = xformCenterEar.y - xformPosition.y;
        unitToEar.z = xformCenterEar.z - xformPosition.z;
        unitToEar.normalize();
        unitDirection.normalize(this.direction);
        float dotProduct = unitToEar.dot(unitDirection);
        float angle = (float)Math.acos(dotProduct);
        return angle;
    }

    @Override
    void calculateFilter(float distance, AuralParameters attribs) {
        float distanceFilter = 44100.0f;
        float angularFilter = 44100.0f;
        int arrayLength = attribs.getDistanceFilterLength();
        int filterType = attribs.getDistanceFilterType();
        boolean distanceFilterFound = false;
        boolean angularFilterFound = false;
        if (filterType == -1 && arrayLength > 0) {
            double[] distanceArray = new double[arrayLength];
            float[] cutoffArray = new float[arrayLength];
            attribs.getDistanceFilter(distanceArray, cutoffArray);
            float angle = this.findAngularOffset();
            distanceFilter = this.findFactor(angle, this.angularDistance, this.angularFilterCutoff);
            distanceFilterFound = !(distanceFilter < 0.0f);
        } else {
            distanceFilterFound = false;
            distanceFilter = -1.0f;
        }
        arrayLength = this.angularDistance.length;
        filterType = this.angularFilterType;
        if (filterType != -1 && arrayLength > 0) {
            angularFilter = this.findFactor(distance, this.angularDistance, this.angularFilterCutoff);
            angularFilterFound = !(angularFilter < 0.0f);
        } else {
            angularFilterFound = false;
            angularFilter = -1.0f;
        }
        boolean bl = this.filterFlag = distanceFilterFound || angularFilterFound;
        this.filterFreq = distanceFilter < 0.0f ? angularFilter : (angularFilter < 0.0f ? distanceFilter : Math.min(distanceFilter, angularFilter));
    }
}

