/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders;

import java.util.Hashtable;
import java.util.Vector;
import org.jogamp.java3d.Background;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Fog;
import org.jogamp.java3d.Light;
import org.jogamp.java3d.Sound;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.loaders.Scene;

public class SceneBase
implements Scene {
    BranchGroup sceneGroup = null;
    BranchGroup behaviorGroup = null;
    Hashtable namedObjects = new Hashtable();
    String description = null;
    Vector viewVector = new Vector();
    Vector hfovVector = new Vector();
    Vector behaviorVector = new Vector();
    Vector lightVector = new Vector();
    Vector fogVector = new Vector();
    Vector backgroundVector = new Vector();
    Vector soundVector = new Vector();

    public void setSceneGroup(BranchGroup scene) {
        this.sceneGroup = scene;
    }

    public void addViewGroup(TransformGroup tg) {
        this.viewVector.addElement(tg);
    }

    public void addHorizontalFOV(float hfov) {
        this.hfovVector.addElement(new Float(hfov));
    }

    public void addBehaviorNode(Behavior b) {
        this.behaviorVector.addElement(b);
    }

    public void addLightNode(Light light) {
        this.lightVector.addElement(light);
    }

    public void addBackgroundNode(Background background) {
        this.backgroundVector.addElement(background);
    }

    public void addSoundNode(Sound sound) {
        this.soundVector.addElement(sound);
    }

    public void addFogNode(Fog fog) {
        this.fogVector.addElement(fog);
    }

    public void addDescription(String descriptionString) {
        this.description = descriptionString;
    }

    public void addNamedObject(String name, Object object) {
        if (this.namedObjects.get(name) == null) {
            this.namedObjects.put(name, object);
        } else {
            int nameIndex = 1;
            boolean done = false;
            while (!done) {
                String tempName = name + "[" + nameIndex + "]";
                if (this.namedObjects.get(tempName) == null) {
                    this.namedObjects.put(tempName, object);
                    done = true;
                }
                ++nameIndex;
            }
        }
    }

    @Override
    public BranchGroup getSceneGroup() {
        return this.sceneGroup;
    }

    @Override
    public TransformGroup[] getViewGroups() {
        if (this.viewVector.isEmpty()) {
            return null;
        }
        Object[] viewGroups = new TransformGroup[this.viewVector.size()];
        this.viewVector.copyInto(viewGroups);
        return viewGroups;
    }

    @Override
    public float[] getHorizontalFOVs() {
        if (this.hfovVector.isEmpty()) {
            return null;
        }
        int arraySize = this.hfovVector.size();
        float[] hfovs = new float[arraySize];
        Object[] tmpFovs = new Float[this.hfovVector.size()];
        this.hfovVector.copyInto(tmpFovs);
        for (int i = 0; i < arraySize; ++i) {
            hfovs[i] = ((Float)tmpFovs[i]).floatValue();
            tmpFovs[i] = null;
        }
        return hfovs;
    }

    @Override
    public Light[] getLightNodes() {
        if (this.lightVector.isEmpty()) {
            return null;
        }
        Object[] lightNodes = new Light[this.lightVector.size()];
        this.lightVector.copyInto(lightNodes);
        return lightNodes;
    }

    @Override
    public Hashtable getNamedObjects() {
        return this.namedObjects;
    }

    @Override
    public Background[] getBackgroundNodes() {
        if (this.backgroundVector.isEmpty()) {
            return null;
        }
        Object[] backgroundNodes = new Background[this.backgroundVector.size()];
        this.backgroundVector.copyInto(backgroundNodes);
        return backgroundNodes;
    }

    @Override
    public Fog[] getFogNodes() {
        if (this.fogVector.isEmpty()) {
            return null;
        }
        Object[] fogNodes = new Fog[this.fogVector.size()];
        this.fogVector.copyInto(fogNodes);
        return fogNodes;
    }

    @Override
    public Behavior[] getBehaviorNodes() {
        if (this.behaviorVector.isEmpty()) {
            return null;
        }
        Object[] behaviorNodes = new Behavior[this.behaviorVector.size()];
        this.behaviorVector.copyInto(behaviorNodes);
        return behaviorNodes;
    }

    @Override
    public Sound[] getSoundNodes() {
        if (this.soundVector.isEmpty()) {
            return null;
        }
        Object[] soundNodes = new Sound[this.soundVector.size()];
        this.soundVector.copyInto(soundNodes);
        return soundNodes;
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

