/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.interpolators;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransformInterpolator;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.behaviors.interpolators.KBKeyFrame;

public abstract class KBSplinePathInterpolator
extends TransformInterpolator {
    private int keysLength;
    protected KBKeyFrame[] keyFrames;
    protected float currentU;
    protected int lowerKnot;
    protected int upperKnot;

    KBSplinePathInterpolator() {
    }

    public KBSplinePathInterpolator(Alpha alpha, KBKeyFrame[] keys) {
        this(alpha, null, keys);
    }

    public KBSplinePathInterpolator(Alpha alpha, TransformGroup target, KBKeyFrame[] keys) {
        super(alpha, target);
        this.processKeyFrames(keys);
    }

    public KBSplinePathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, KBKeyFrame[] keys) {
        super(alpha, target, axisOfTransform);
        this.processKeyFrames(keys);
    }

    private void processKeyFrames(KBKeyFrame[] keys) {
        int i;
        this.keysLength = keys.length;
        if (this.keysLength < 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator0"));
        }
        if ((double)keys[0].knot < -1.0E-4 || (double)keys[0].knot > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator1"));
        }
        if ((double)keys[this.keysLength - 1].knot - 1.0 < -1.0E-4 || (double)keys[this.keysLength - 1].knot - 1.0 > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator2"));
        }
        for (i = 0; i < this.keysLength; ++i) {
            if (i <= 0 || !(keys[i].knot < keys[i - 1].knot)) continue;
            throw new IllegalArgumentException(J3dUtilsI18N.getString("KBSplinePathInterpolator3"));
        }
        this.keyFrames = new KBKeyFrame[this.keysLength + 2];
        this.keyFrames[0] = new KBKeyFrame();
        this.keyFrames[0] = keys[0];
        for (i = 1; i < this.keysLength + 1; ++i) {
            this.keyFrames[i] = keys[i - 1];
        }
        this.keyFrames[this.keysLength + 1] = new KBKeyFrame();
        this.keyFrames[this.keysLength + 1] = keys[this.keysLength - 1];
        this.keysLength += 2;
    }

    public int getArrayLength() {
        return this.keysLength - 2;
    }

    public KBKeyFrame getKeyFrame(int index) {
        return this.keyFrames[index + 1];
    }

    public void setKeyFrame(int index, KBKeyFrame keyFrame) {
        this.keyFrames[index + 1] = keyFrame;
    }

    public void setKeyFrames(KBKeyFrame[] keyFrames) {
        this.processKeyFrames(keyFrames);
    }

    protected void computePathInterpolation() {
        this.computePathInterpolation(this.getAlpha().value());
    }

    protected void computePathInterpolation(float alphaValue) {
        int i;
        int len = this.keysLength - 2;
        for (i = 1; alphaValue > this.keyFrames[i].knot && i < len; ++i) {
        }
        if (i == 1) {
            this.currentU = 0.0f;
            this.lowerKnot = 1;
            this.upperKnot = 2;
        } else {
            this.currentU = (alphaValue - this.keyFrames[i - 1].knot) / (this.keyFrames[i].knot - this.keyFrames[i - 1].knot);
            this.lowerKnot = i - 1;
            this.upperKnot = i;
        }
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
        KBSplinePathInterpolator originalSpline = (KBSplinePathInterpolator)originalNode;
        this.setAlpha(originalSpline.getAlpha());
        this.keysLength = originalSpline.keysLength;
        this.keyFrames = new KBKeyFrame[this.keysLength];
        System.arraycopy(originalSpline.keyFrames, 0, this.keyFrames, 0, this.keysLength);
    }
}

