/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.interpolators;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.behaviors.interpolators.CubicSplineCurve;
import org.jogamp.java3d.utils.behaviors.interpolators.CubicSplineSegment;
import org.jogamp.java3d.utils.behaviors.interpolators.TCBKeyFrame;
import org.jogamp.java3d.utils.behaviors.interpolators.TCBSplinePathInterpolator;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Quat4f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Tuple4f;
import org.jogamp.vecmath.Vector3d;
import org.jogamp.vecmath.Vector3f;

public class RotPosScaleTCBSplinePathInterpolator
extends TCBSplinePathInterpolator {
    private Transform3D rotation = new Transform3D();
    private Matrix4d tMat = new Matrix4d();
    private Matrix4d sMat = new Matrix4d();
    private Quat4f iQuat = new Quat4f();
    private Vector3f iPos = new Vector3f();
    private Point3f iScale = new Point3f();
    CubicSplineCurve cubicSplineCurve = new CubicSplineCurve();
    CubicSplineSegment[] cubicSplineSegments;
    int numSegments;
    int currentSegmentIndex;
    CubicSplineSegment currentSegment;

    RotPosScaleTCBSplinePathInterpolator() {
    }

    public RotPosScaleTCBSplinePathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, TCBKeyFrame[] keys) {
        super(alpha, target, axisOfTransform, keys);
        this.cubicSplineCurve = new CubicSplineCurve(this.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }

    public void setAxisOfRotPosScale(Transform3D axisOfRotPosScale) {
        this.setTransformAxis(axisOfRotPosScale);
    }

    public Transform3D getAxisOfRotPosScale() {
        return this.getTransformAxis();
    }

    @Override
    public void computeTransform(float alphaValue, Transform3D transform) {
        this.computePathInterpolation(alphaValue);
        this.currentSegmentIndex = this.lowerKnot - 1;
        if (this.currentSegmentIndex == 0 && this.currentU == 0.0f) {
            this.iQuat.set((Tuple4f)this.keyFrames[1].quat);
            this.iPos.set((Tuple3f)this.keyFrames[1].position);
            this.iScale.set((Tuple3f)this.keyFrames[1].scale);
        } else if (this.currentSegmentIndex == this.numSegments - 1 && (double)this.currentU == 1.0) {
            this.iQuat.set((Tuple4f)this.keyFrames[this.upperKnot].quat);
            this.iPos.set((Tuple3f)this.keyFrames[this.upperKnot].position);
            this.iScale.set((Tuple3f)this.keyFrames[this.upperKnot].scale);
        } else {
            this.currentSegment = this.cubicSplineCurve.getSegment(this.currentSegmentIndex);
            this.currentSegment.getInterpolatedQuaternion(this.currentU, this.iQuat);
            this.currentSegment.getInterpolatedPositionVector(this.currentU, this.iPos);
            this.currentSegment.getInterpolatedScale(this.currentU, this.iScale);
        }
        this.iQuat.normalize();
        this.tMat.set(this.iQuat);
        this.tMat.m03 = this.iPos.x;
        this.tMat.m13 = this.iPos.y;
        this.tMat.m23 = this.iPos.z;
        this.rotation.set(this.tMat);
        transform.mul(this.axis, this.rotation);
        transform.setScale(new Vector3d((Tuple3f)this.iScale));
        transform.mul(transform, this.axisInverse);
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        RotPosScaleTCBSplinePathInterpolator spline = new RotPosScaleTCBSplinePathInterpolator();
        spline.duplicateNode(this, forceDuplicate);
        return spline;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
        RotPosScaleTCBSplinePathInterpolator interpolator = (RotPosScaleTCBSplinePathInterpolator)originalNode;
        this.cubicSplineCurve = new CubicSplineCurve(interpolator.keyFrames);
        this.numSegments = this.cubicSplineCurve.numSegments;
    }
}

