/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.BBox;
import org.jogamp.java3d.utils.geometry.Basic;
import org.jogamp.java3d.utils.geometry.Bridge;
import org.jogamp.java3d.utils.geometry.Distance;
import org.jogamp.java3d.utils.geometry.Heap;
import org.jogamp.java3d.utils.geometry.NoHash;
import org.jogamp.java3d.utils.geometry.Numerics;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Tuple2f;

class Desperate {
    Desperate() {
    }

    static boolean desperate(Triangulator triRef, int ind, int i, boolean[] splitted) {
        int[] i1 = new int[1];
        int[] i2 = new int[1];
        int[] i3 = new int[1];
        int[] i4 = new int[1];
        int[] ind1 = new int[1];
        int[] ind2 = new int[1];
        int[] ind3 = new int[1];
        int[] ind4 = new int[1];
        splitted[0] = false;
        if (Desperate.existsCrossOver(triRef, ind, ind1, i1, ind2, i2, ind3, i3, ind4, i4)) {
            Desperate.handleCrossOver(triRef, ind1[0], i1[0], ind2[0], i2[0], ind3[0], i3[0], ind4[0], i4[0]);
            return false;
        }
        NoHash.prepareNoHashEdges(triRef, i, i + 1);
        if (Desperate.existsSplit(triRef, ind, ind1, i1, ind2, i2)) {
            Desperate.handleSplit(triRef, ind1[0], i1[0], ind2[0], i2[0]);
            splitted[0] = true;
            return false;
        }
        return true;
    }

    static boolean existsCrossOver(Triangulator triRef, int ind, int[] ind1, int[] i1, int[] ind2, int[] i2, int[] ind3, int[] i3, int[] ind4, int[] i4) {
        ind1[0] = ind;
        i1[0] = triRef.fetchData(ind1[0]);
        ind2[0] = triRef.fetchNextData(ind1[0]);
        i2[0] = triRef.fetchData(ind2[0]);
        ind3[0] = triRef.fetchNextData(ind2[0]);
        i3[0] = triRef.fetchData(ind3[0]);
        ind4[0] = triRef.fetchNextData(ind3[0]);
        i4[0] = triRef.fetchData(ind4[0]);
        do {
            BBox bb2;
            BBox bb1;
            if ((bb1 = new BBox(triRef, i1[0], i2[0])).BBoxOverlap(bb2 = new BBox(triRef, i3[0], i4[0])) && Numerics.segIntersect(triRef, bb1.imin, bb1.imax, bb2.imin, bb2.imax, -1)) {
                return true;
            }
            ind1[0] = ind2[0];
            i1[0] = i2[0];
            ind2[0] = ind3[0];
            i2[0] = i3[0];
            ind3[0] = ind4[0];
            i3[0] = i4[0];
            ind4[0] = triRef.fetchNextData(ind3[0]);
            i4[0] = triRef.fetchData(ind4[0]);
        } while (ind1[0] != ind);
        return false;
    }

    static void handleCrossOver(Triangulator triRef, int ind1, int i1, int ind2, int i2, int ind3, int i3, int ind4, int i4) {
        boolean first;
        int angle4;
        int angle1 = triRef.getAngle(ind1);
        if (angle1 < (angle4 = triRef.getAngle(ind4))) {
            first = true;
        } else if (angle1 > angle4) {
            first = false;
        } else if (triRef.earsSorted) {
            double ratio1 = Numerics.getRatio(triRef, i3, i4, i1);
            double ratio4 = Numerics.getRatio(triRef, i1, i2, i4);
            first = !(ratio4 < ratio1);
        } else {
            first = true;
        }
        if (first) {
            triRef.deleteLinks(ind2);
            triRef.storeTriangle(ind1, ind2, ind3);
            triRef.setAngle(ind3, 1);
            Heap.insertIntoHeap(triRef, 0.0, ind3, ind1, ind4);
        } else {
            triRef.deleteLinks(ind3);
            triRef.storeTriangle(ind2, ind3, ind4);
            triRef.setAngle(ind2, 1);
            Heap.insertIntoHeap(triRef, 0.0, ind2, ind1, ind4);
        }
    }

    static boolean letsHope(Triangulator triRef, int ind) {
        int ind1 = ind;
        int i1 = triRef.fetchData(ind1);
        do {
            if (triRef.getAngle(ind1) > 0) {
                int ind0 = triRef.fetchPrevData(ind1);
                int i0 = triRef.fetchData(ind0);
                int ind2 = triRef.fetchNextData(ind1);
                int i2 = triRef.fetchData(ind2);
                Heap.insertIntoHeap(triRef, 0.0, ind1, ind0, ind2);
                return true;
            }
            ind1 = triRef.fetchNextData(ind1);
            i1 = triRef.fetchData(ind1);
        } while (ind1 != ind);
        triRef.setAngle(ind, 1);
        int ind0 = triRef.fetchPrevData(ind);
        int i0 = triRef.fetchData(ind0);
        int ind2 = triRef.fetchNextData(ind);
        int i2 = triRef.fetchData(ind2);
        Heap.insertIntoHeap(triRef, 0.0, ind, ind0, ind2);
        i1 = triRef.fetchData(ind);
        return true;
    }

    static boolean existsSplit(Triangulator triRef, int ind, int[] ind1, int[] i1, int[] ind2, int[] i2) {
        int i3;
        int ind3;
        int i5;
        if (triRef.numPoints > triRef.maxNumDist) {
            triRef.maxNumDist = triRef.numPoints;
            triRef.distances = new Distance[triRef.maxNumDist];
            for (int k = 0; k < triRef.maxNumDist; ++k) {
                triRef.distances[k] = new Distance();
            }
        }
        ind1[0] = ind;
        i1[0] = triRef.fetchData(ind1[0]);
        int ind4 = triRef.fetchNextData(ind1[0]);
        int i4 = triRef.fetchData(ind4);
        int ind5 = triRef.fetchNextData(ind4);
        if (Desperate.foundSplit(triRef, ind5, i5 = triRef.fetchData(ind5), ind3 = triRef.fetchPrevData(ind1[0]), ind1[0], i1[0], i3 = triRef.fetchData(ind3), i4, ind2, i2)) {
            return true;
        }
        i3 = i1[0];
        ind1[0] = ind4;
        i1[0] = i4;
        ind4 = ind5;
        i4 = i5;
        ind5 = triRef.fetchNextData(ind4);
        i5 = triRef.fetchData(ind5);
        while (ind5 != ind) {
            if (Desperate.foundSplit(triRef, ind5, i5, ind, ind1[0], i1[0], i3, i4, ind2, i2)) {
                return true;
            }
            i3 = i1[0];
            ind1[0] = ind4;
            i1[0] = i4;
            ind4 = ind5;
            i4 = i5;
            ind5 = triRef.fetchNextData(ind4);
            i5 = triRef.fetchData(ind5);
        }
        return false;
    }

    static int windingNumber(Triangulator triRef, int ind, Point2f p) {
        int i1 = triRef.fetchData(ind);
        int ind2 = triRef.fetchNextData(ind);
        int i2 = triRef.fetchData(ind2);
        double angle = Numerics.angle(triRef, p, triRef.points[i1], triRef.points[i2]);
        while (ind2 != ind) {
            i1 = i2;
            ind2 = triRef.fetchNextData(ind2);
            i2 = triRef.fetchData(ind2);
            angle += Numerics.angle(triRef, p, triRef.points[i1], triRef.points[i2]);
        }
        int number = (int)((angle += Math.PI) / (Math.PI * 2));
        return number;
    }

    static boolean foundSplit(Triangulator triRef, int ind5, int i5, int ind, int ind1, int i1, int i3, int i4, int[] ind2, int[] i2) {
        int numDist = 0;
        do {
            triRef.distances[numDist].dist = Numerics.baseLength((Tuple2f)triRef.points[i1], (Tuple2f)triRef.points[i5]);
            triRef.distances[numDist].ind = ind5;
            ++numDist;
            ind5 = triRef.fetchNextData(ind5);
            i5 = triRef.fetchData(ind5);
        } while (ind5 != ind);
        Bridge.sortDistance(triRef.distances, numDist);
        for (int j = 0; j < numDist; ++j) {
            BBox bb;
            boolean convex;
            int ind7;
            int i7;
            int ind6;
            int i6;
            boolean coneOk;
            ind2[0] = triRef.distances[j].ind;
            i2[0] = triRef.fetchData(ind2[0]);
            if (i1 == i2[0] || !(coneOk = Numerics.isInCone(triRef, i6 = triRef.fetchData(ind6 = triRef.fetchPrevData(ind2[0])), i2[0], i7 = triRef.fetchData(ind7 = triRef.fetchNextData(ind2[0])), i1, convex = triRef.getAngle(ind2[0]) > 0)) || !(coneOk = Numerics.isInCone(triRef, i3, i1, i4, i2[0], convex = triRef.getAngle(ind1) > 0)) || NoHash.noHashEdgeIntersectionExists(triRef, bb = new BBox(triRef, i1, i2[0]), -1, -1, ind1, -1)) continue;
            Point2f center = new Point2f();
            Basic.vectorAdd2D((Tuple2f)triRef.points[i1], (Tuple2f)triRef.points[i2[0]], (Tuple2f)center);
            Basic.multScalar2D(0.5, (Tuple2f)center);
            if (Desperate.windingNumber(triRef, ind, center) != 1) continue;
            return true;
        }
        return false;
    }

    static void handleSplit(Triangulator triRef, int ind1, int i1, int ind3, int i3) {
        int comIndex = -1;
        int ind2 = triRef.makeNode(i1);
        triRef.insertAfter(ind1, ind2);
        comIndex = triRef.list[ind1].getCommonIndex();
        triRef.list[ind2].setCommonIndex(comIndex);
        int ind4 = triRef.makeNode(i3);
        triRef.insertAfter(ind3, ind4);
        comIndex = triRef.list[ind3].getCommonIndex();
        triRef.list[ind4].setCommonIndex(comIndex);
        triRef.splitSplice(ind1, ind2, ind3, ind4);
        triRef.storeChain(ind1);
        triRef.storeChain(ind3);
        int next = triRef.fetchNextData(ind1);
        int nxt = triRef.fetchData(next);
        int prev = triRef.fetchPrevData(ind1);
        int prv = triRef.fetchData(prev);
        int angle = Numerics.isConvexAngle(triRef, prv, i1, nxt, ind1);
        triRef.setAngle(ind1, angle);
        next = triRef.fetchNextData(ind2);
        nxt = triRef.fetchData(next);
        prev = triRef.fetchPrevData(ind2);
        prv = triRef.fetchData(prev);
        angle = Numerics.isConvexAngle(triRef, prv, i1, nxt, ind2);
        triRef.setAngle(ind2, angle);
        next = triRef.fetchNextData(ind3);
        nxt = triRef.fetchData(next);
        prev = triRef.fetchPrevData(ind3);
        prv = triRef.fetchData(prev);
        angle = Numerics.isConvexAngle(triRef, prv, i3, nxt, ind3);
        triRef.setAngle(ind3, angle);
        next = triRef.fetchNextData(ind4);
        nxt = triRef.fetchData(next);
        prev = triRef.fetchPrevData(ind4);
        prv = triRef.fetchData(prev);
        angle = Numerics.isConvexAngle(triRef, prv, i3, nxt, ind4);
        triRef.setAngle(ind4, angle);
    }
}

