/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.GeometryStripArray;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.IndexedGeometryStripArray;
import org.jogamp.java3d.IndexedQuadArray;
import org.jogamp.java3d.IndexedTriangleArray;
import org.jogamp.java3d.IndexedTriangleFanArray;
import org.jogamp.java3d.IndexedTriangleStripArray;
import org.jogamp.java3d.J3DBuffer;
import org.jogamp.java3d.QuadArray;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.java3d.TriangleFanArray;
import org.jogamp.java3d.TriangleStripArray;
import org.jogamp.java3d.internal.BufferWrapper;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.geometry.GeometryInfo;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Color4f;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.TexCoord2f;
import org.jogamp.vecmath.TexCoord3f;
import org.jogamp.vecmath.TexCoord4f;
import org.jogamp.vecmath.Vector3f;

class GeometryInfoGenerator {
    GeometryInfoGenerator() {
    }

    public static void create(GeometryInfo geomInfo, GeometryArray geomArray) {
        if (geomArray instanceof GeometryStripArray) {
            GeometryInfoGenerator.create(geomInfo, (GeometryStripArray)geomArray);
        } else if (geomArray instanceof TriangleArray) {
            geomInfo.reset(1);
            GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        } else if (geomArray instanceof QuadArray) {
            geomInfo.reset(2);
            GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        } else if (geomArray instanceof IndexedGeometryArray) {
            GeometryInfoGenerator.create(geomInfo, (IndexedGeometryArray)geomArray);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfoGenerator0"));
        }
    }

    private static void create(GeometryInfo geomInfo, GeometryStripArray geomArray) {
        if (geomArray instanceof TriangleFanArray) {
            geomInfo.reset(3);
        } else if (geomArray instanceof TriangleStripArray) {
            geomInfo.reset(4);
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeometryInfoGenerator0"));
        }
        GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        GeometryInfoGenerator.processStripArray(geomInfo, geomArray);
    }

    private static void create(GeometryInfo geomInfo, IndexedGeometryArray geomArray) {
        if (geomArray instanceof IndexedQuadArray) {
            geomInfo.reset(2);
        } else if (geomArray instanceof IndexedTriangleArray) {
            geomInfo.reset(1);
        } else if (geomArray instanceof IndexedTriangleFanArray) {
            geomInfo.reset(3);
            GeometryInfoGenerator.processIndexStripArray(geomInfo, (IndexedGeometryStripArray)geomArray);
        } else if (geomArray instanceof IndexedTriangleStripArray) {
            geomInfo.reset(4);
            GeometryInfoGenerator.processIndexStripArray(geomInfo, (IndexedGeometryStripArray)geomArray);
        }
        GeometryInfoGenerator.processGeometryArray(geomInfo, geomArray);
        GeometryInfoGenerator.processIndexedArray(geomInfo, geomArray);
    }

    private static void processGeometryArray(GeometryInfo geomInfo, GeometryArray geomArray) {
        block153: {
            Object[] t;
            Object[] c;
            Buffer bb;
            J3DBuffer buf;
            boolean nio;
            boolean byRef;
            int i;
            int valid;
            int texSets;
            int vertexFormat;
            block161: {
                Color3f[] colors;
                block164: {
                    int initial;
                    block162: {
                        Object[] c2;
                        block163: {
                            block157: {
                                Color4f[] colors2;
                                block160: {
                                    int initial2;
                                    block158: {
                                        block159: {
                                            Point3f[] coords;
                                            block156: {
                                                int initial3;
                                                block154: {
                                                    Object[] c3;
                                                    block155: {
                                                        block152: {
                                                            Color4f[] color;
                                                            int j;
                                                            TexCoord2f[] tex;
                                                            int[] map;
                                                            float[] d;
                                                            vertexFormat = geomArray.getVertexFormat();
                                                            texSets = geomArray.getTexCoordSetCount();
                                                            if (geomArray instanceof GeometryStripArray) {
                                                                GeometryStripArray gsa = (GeometryStripArray)geomArray;
                                                                int[] strips = new int[gsa.getNumStrips()];
                                                                gsa.getStripVertexCounts(strips);
                                                                valid = 0;
                                                                for (i = 0; i < strips.length; ++i) {
                                                                    valid += strips[i];
                                                                }
                                                            } else {
                                                                valid = geomArray instanceof IndexedGeometryArray ? geomArray.getVertexCount() : geomArray.getValidVertexCount();
                                                            }
                                                            if ((vertexFormat & 0x100) == 0) break block152;
                                                            int wpv = 3;
                                                            if ((vertexFormat & 2) != 0) {
                                                                wpv += 3;
                                                            }
                                                            if ((vertexFormat & 0xC) == 12) {
                                                                wpv += 4;
                                                            } else if ((vertexFormat & 4) != 0) {
                                                                wpv += 3;
                                                            }
                                                            if ((vertexFormat & 0x20) != 0) {
                                                                wpv += 2 * texSets;
                                                            } else if ((vertexFormat & 0x40) != 0) {
                                                                wpv += 3 * texSets;
                                                            } else if ((vertexFormat & 0x400) != 0) {
                                                                wpv += 4 * texSets;
                                                            }
                                                            int initial4 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                                                            if ((vertexFormat & 0x800) != 0) {
                                                                J3DBuffer b = geomArray.getInterleavedVertexBuffer();
                                                                FloatBuffer w = (FloatBuffer)b.getBuffer();
                                                                d = new float[w.limit()];
                                                                w.position(0);
                                                                w.get(d);
                                                            } else {
                                                                d = geomArray.getInterleavedVertices();
                                                            }
                                                            int offset = 0;
                                                            if ((vertexFormat & 0x20) != 0) {
                                                                geomInfo.setTextureCoordinateParams(texSets, 2);
                                                                map = new int[geomArray.getTexCoordSetMapLength()];
                                                                geomArray.getTexCoordSetMap(map);
                                                                geomInfo.setTexCoordSetMap(map);
                                                                for (i = 0; i < texSets; ++i) {
                                                                    tex = new TexCoord2f[valid];
                                                                    for (j = 0; j < valid; ++j) {
                                                                        tex[j] = new TexCoord2f(d[wpv * (j + initial4) + offset], d[wpv * (j + initial4) + offset + 1]);
                                                                    }
                                                                    geomInfo.setTextureCoordinates(i, tex);
                                                                    offset += 2;
                                                                }
                                                            } else if ((vertexFormat & 0x40) != 0) {
                                                                geomInfo.setTextureCoordinateParams(texSets, 3);
                                                                map = new int[geomArray.getTexCoordSetMapLength()];
                                                                geomArray.getTexCoordSetMap(map);
                                                                geomInfo.setTexCoordSetMap(map);
                                                                for (i = 0; i < texSets; ++i) {
                                                                    tex = new TexCoord3f[valid];
                                                                    for (j = 0; j < valid; ++j) {
                                                                        tex[j] = new TexCoord3f(d[wpv * (j + initial4) + offset], d[wpv * (j + initial4) + offset + 1], d[wpv * (j + initial4) + offset + 2]);
                                                                    }
                                                                    geomInfo.setTextureCoordinates(i, (TexCoord3f[])tex);
                                                                    offset += 3;
                                                                }
                                                            } else if ((vertexFormat & 0x400) != 0) {
                                                                geomInfo.setTextureCoordinateParams(texSets, 4);
                                                                map = new int[geomArray.getTexCoordSetMapLength()];
                                                                geomArray.getTexCoordSetMap(map);
                                                                geomInfo.setTexCoordSetMap(map);
                                                                for (i = 0; i < texSets; ++i) {
                                                                    tex = new TexCoord4f[valid];
                                                                    for (j = 0; j < valid; ++j) {
                                                                        tex[j] = new TexCoord4f(d[wpv * (j + initial4) + offset], d[wpv * (j + initial4) + offset + 1], d[wpv * (j + initial4) + offset + 2], d[wpv * (j + initial4) + offset + 3]);
                                                                    }
                                                                    geomInfo.setTextureCoordinates(i, (TexCoord4f[])tex);
                                                                    offset += 4;
                                                                }
                                                            }
                                                            if ((vertexFormat & 0xC) == 12) {
                                                                color = new Color4f[valid];
                                                                for (i = 0; i < valid; ++i) {
                                                                    color[i] = new Color4f(d[wpv * (i + initial4) + offset], d[wpv * (i + initial4) + offset + 1], d[wpv * (i + initial4) + offset + 2], d[wpv * (i + initial4) + offset + 3]);
                                                                }
                                                                geomInfo.setColors(color);
                                                                offset += 4;
                                                            } else if ((vertexFormat & 4) != 0) {
                                                                color = new Color3f[valid];
                                                                for (i = 0; i < valid; ++i) {
                                                                    color[i] = new Color3f(d[wpv * (i + initial4) + offset], d[wpv * (i + initial4) + offset + 1], d[wpv * (i + initial4) + offset + 2]);
                                                                }
                                                                geomInfo.setColors((Color3f[])color);
                                                                offset += 3;
                                                            }
                                                            if ((vertexFormat & 2) != 0) {
                                                                Vector3f[] normals = new Vector3f[valid];
                                                                for (i = 0; i < valid; ++i) {
                                                                    normals[i] = new Vector3f(d[wpv * (i + initial4) + offset], d[wpv * (i + initial4) + offset + 1], d[wpv * (i + initial4) + offset + 2]);
                                                                }
                                                                geomInfo.setNormals(normals);
                                                                offset += 3;
                                                            }
                                                            Point3f[] coords2 = new Point3f[valid];
                                                            for (i = 0; i < valid; ++i) {
                                                                coords2[i] = new Point3f(d[wpv * (i + initial4) + offset], d[wpv * (i + initial4) + offset + 1], d[wpv * (i + initial4) + offset + 2]);
                                                            }
                                                            geomInfo.setCoordinates(coords2);
                                                            break block153;
                                                        }
                                                        byRef = (vertexFormat & 0x80) != 0;
                                                        nio = (vertexFormat & 0x800) != 0;
                                                        coords = null;
                                                        if (!byRef) break block154;
                                                        initial3 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialCoordIndex() : 0;
                                                        if (!nio) break block155;
                                                        J3DBuffer buf2 = geomArray.getCoordRefBuffer();
                                                        switch (BufferWrapper.getBufferType(buf2)) {
                                                            case 3: {
                                                                Buffer bb2 = (FloatBuffer)buf2.getBuffer();
                                                                Object[] c4 = new float[valid * 3];
                                                                ((FloatBuffer)bb2).position(initial3 * 3);
                                                                ((FloatBuffer)bb2).get((float[])c4, 0, valid * 3);
                                                                coords = new Point3f[valid];
                                                                for (i = 0; i < valid; ++i) {
                                                                    coords[i] = new Point3f(c4[i * 3 + 0], c4[i * 3 + 1], c4[i * 3 + 2]);
                                                                }
                                                                break block156;
                                                            }
                                                            case 4: {
                                                                Buffer bb2 = (DoubleBuffer)buf2.getBuffer();
                                                                Object[] c4 = new double[valid * 3];
                                                                ((DoubleBuffer)bb2).position(initial3 * 3);
                                                                ((DoubleBuffer)bb2).get((double[])c4, 0, valid * 3);
                                                                coords = new Point3f[valid];
                                                                for (i = 0; i < valid; ++i) {
                                                                    coords[i] = new Point3f(c4[i * 3 + 0], c4[i * 3 + 1], c4[i * 3 + 2]);
                                                                }
                                                                break;
                                                            }
                                                        }
                                                        break block156;
                                                    }
                                                    if (geomArray.getCoordRef3f() != null) {
                                                        if (initial3 != 0) {
                                                            c3 = geomArray.getCoordRef3f();
                                                            coords = new Point3f[valid];
                                                            for (i = 0; i < valid; ++i) {
                                                                coords[i] = new Point3f(c3[i + initial3]);
                                                            }
                                                        } else {
                                                            coords = geomArray.getCoordRef3f();
                                                        }
                                                    } else if (geomArray.getCoordRef3d() != null) {
                                                        c3 = geomArray.getCoordRef3d();
                                                        coords = new Point3f[valid];
                                                        for (i = 0; i < valid; ++i) {
                                                            coords[i] = new Point3f((Point3d)c3[i + initial3]);
                                                        }
                                                    } else if (geomArray.getCoordRefFloat() != null) {
                                                        c3 = geomArray.getCoordRefFloat();
                                                        coords = new Point3f[valid];
                                                        for (i = 0; i < valid; ++i) {
                                                            coords[i] = new Point3f((float)c3[(i + initial3) * 3], (float)c3[(i + initial3) * 3 + 1], (float)c3[(i + initial3) * 3 + 2]);
                                                        }
                                                    } else if (geomArray.getCoordRefDouble() != null) {
                                                        c3 = geomArray.getCoordRefDouble();
                                                        coords = new Point3f[valid];
                                                        for (i = 0; i < valid; ++i) {
                                                            coords[i] = new Point3f((float)c3[(i + initial3) * 3], (float)c3[(i + initial3) * 3 + 1], (float)c3[(i + initial3) * 3 + 2]);
                                                        }
                                                    }
                                                    break block156;
                                                }
                                                initial3 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                                                coords = new Point3f[valid];
                                                for (i = 0; i < valid; ++i) {
                                                    coords[i] = new Point3f();
                                                }
                                                geomArray.getCoordinates(initial3, coords);
                                            }
                                            geomInfo.setCoordinates(coords);
                                            if ((vertexFormat & 2) != 0) {
                                                int initial5;
                                                Vector3f[] normals = null;
                                                if (byRef) {
                                                    Object[] n;
                                                    initial5 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialNormalIndex() : 0;
                                                    if (nio) {
                                                        buf = geomArray.getNormalRefBuffer();
                                                        if (BufferWrapper.getBufferType(buf) == 3) {
                                                            bb = (FloatBuffer)buf.getBuffer();
                                                            c = new float[valid * 3];
                                                            ((FloatBuffer)bb).position(initial5 * 3);
                                                            ((FloatBuffer)bb).get((float[])c, 0, valid * 3);
                                                            normals = new Vector3f[valid];
                                                            for (i = 0; i < valid; ++i) {
                                                                normals[i] = new Vector3f(c[i * 3 + 0], c[i * 3 + 1], c[i * 3 + 2]);
                                                            }
                                                        }
                                                    } else if (geomArray.getNormalRef3f() != null) {
                                                        if (initial5 != 0) {
                                                            n = geomArray.getNormalRef3f();
                                                            normals = new Vector3f[valid];
                                                            for (i = 0; i < valid; ++i) {
                                                                normals[i] = new Vector3f(n[i + initial5]);
                                                            }
                                                        } else {
                                                            normals = geomArray.getNormalRef3f();
                                                        }
                                                    } else if (geomArray.getNormalRefFloat() != null) {
                                                        n = geomArray.getNormalRefFloat();
                                                        normals = new Vector3f[valid];
                                                        for (i = 0; i < valid; ++i) {
                                                            normals[i] = new Vector3f((float)n[(i + initial5) * 3], (float)n[(i + initial5) * 3 + 1], (float)n[(i + initial5) * 3 + 2]);
                                                        }
                                                    }
                                                } else {
                                                    initial5 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                                                    normals = new Vector3f[valid];
                                                    for (i = 0; i < valid; ++i) {
                                                        normals[i] = new Vector3f();
                                                    }
                                                    geomArray.getNormals(initial5, normals);
                                                }
                                                geomInfo.setNormals(normals);
                                            }
                                            if ((vertexFormat & 0xC) != 12) break block157;
                                            colors2 = null;
                                            if (!byRef) break block158;
                                            initial2 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialColorIndex() : 0;
                                            if (!nio) break block159;
                                            buf = geomArray.getColorRefBuffer();
                                            switch (BufferWrapper.getBufferType(buf)) {
                                                case 3: {
                                                    bb = (FloatBuffer)buf.getBuffer();
                                                    c = new float[valid * 4];
                                                    ((FloatBuffer)bb).position(initial2 * 4);
                                                    ((FloatBuffer)bb).get((float[])c, 0, valid * 4);
                                                    colors2 = new Color4f[valid];
                                                    for (i = 0; i < valid; ++i) {
                                                        colors2[i] = new Color4f(c[i * 4 + 0], c[i * 4 + 1], c[i * 4 + 2], c[i * 4 + 3]);
                                                    }
                                                    break block160;
                                                }
                                                case 2: {
                                                    bb = (ByteBuffer)buf.getBuffer();
                                                    c = new byte[valid * 4];
                                                    ((ByteBuffer)bb).position(initial2 * 4);
                                                    ((ByteBuffer)bb).get((byte[])c, 0, valid * 4);
                                                    colors2 = new Color4f[valid];
                                                    for (i = 0; i < valid; ++i) {
                                                        colors2[i] = new Color4f((float)(c[i * 4 + 0] & 0xFF) / 255.0f, (float)(c[i * 4 + 1] & 0xFF) / 255.0f, (float)(c[i * 4 + 2] & 0xFF) / 255.0f, (float)(c[i * 4 + 3] & 0xFF) / 255.0f);
                                                    }
                                                    break;
                                                }
                                            }
                                            break block160;
                                        }
                                        if (geomArray.getColorRef4f() != null) {
                                            if (initial2 != 0) {
                                                c2 = geomArray.getColorRef4f();
                                                colors2 = new Color4f[valid];
                                                for (i = 0; i < valid; ++i) {
                                                    colors2[i] = new Color4f(c2[i + initial2]);
                                                }
                                            } else {
                                                colors2 = geomArray.getColorRef4f();
                                            }
                                        } else if (geomArray.getColorRefFloat() != null) {
                                            c2 = geomArray.getColorRefFloat();
                                            colors2 = new Color4f[valid];
                                            for (i = 0; i < valid; ++i) {
                                                colors2[i] = new Color4f((float)c2[(i + initial2) * 4 + 0], (float)c2[(i + initial2) * 4 + 1], (float)c2[(i + initial2) * 4 + 2], (float)c2[(i + initial2) * 4 + 3]);
                                            }
                                        } else if (geomArray.getColorRefByte() != null) {
                                            c2 = geomArray.getColorRefByte();
                                            colors2 = new Color4f[valid];
                                            for (i = 0; i < valid; ++i) {
                                                colors2[i] = new Color4f((float)(c2[(i + initial2) * 4 + 0] & 0xFF) / 255.0f, (float)(c2[(i + initial2) * 4 + 1] & 0xFF) / 255.0f, (float)(c2[(i + initial2) * 4 + 2] & 0xFF) / 255.0f, (float)(c2[(i + initial2) * 4 + 3] & 0xFF) / 255.0f);
                                            }
                                        } else if (geomArray.getColorRef4b() != null) {
                                            c2 = geomArray.getColorRef4b();
                                            colors2 = new Color4f[valid];
                                            for (i = 0; i < valid; ++i) {
                                                colors2[i] = new Color4f((float)(c2[i + initial2].x & 0xFF) / 255.0f, (float)(c2[i + initial2].y & 0xFF) / 255.0f, (float)(c2[i + initial2].z & 0xFF) / 255.0f, (float)(c2[i + initial2].w & 0xFF) / 255.0f);
                                            }
                                        }
                                        break block160;
                                    }
                                    initial2 = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                                    colors2 = new Color4f[valid];
                                    for (i = 0; i < valid; ++i) {
                                        colors2[i] = new Color4f();
                                    }
                                    geomArray.getColors(initial2, colors2);
                                }
                                geomInfo.setColors(colors2);
                                break block161;
                            }
                            if ((vertexFormat & 4) == 0) break block161;
                            colors = null;
                            if (!byRef) break block162;
                            initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialColorIndex() : 0;
                            if (!nio) break block163;
                            buf = geomArray.getColorRefBuffer();
                            switch (BufferWrapper.getBufferType(buf)) {
                                case 3: {
                                    bb = (FloatBuffer)buf.getBuffer();
                                    c = new float[valid * 3];
                                    ((FloatBuffer)bb).position(initial * 3);
                                    ((FloatBuffer)bb).get((float[])c, 0, valid * 3);
                                    colors = new Color3f[valid];
                                    for (i = 0; i < valid; ++i) {
                                        colors[i] = new Color3f(c[i * 3 + 0], c[i * 3 + 1], c[i * 3 + 2]);
                                    }
                                    break block164;
                                }
                                case 2: {
                                    bb = (ByteBuffer)buf.getBuffer();
                                    c = new byte[valid * 3];
                                    ((ByteBuffer)bb).position(initial * 3);
                                    ((ByteBuffer)bb).get((byte[])c, 0, valid * 3);
                                    colors = new Color3f[valid];
                                    for (i = 0; i < valid; ++i) {
                                        colors[i] = new Color3f((float)(c[i * 3 + 0] & 0xFF) / 255.0f, (float)(c[i * 3 + 1] & 0xFF) / 255.0f, (float)(c[i * 3 + 2] & 0xFF) / 255.0f);
                                    }
                                    break;
                                }
                            }
                            break block164;
                        }
                        if (geomArray.getColorRef3f() != null) {
                            if (initial != 0) {
                                c2 = geomArray.getColorRef3f();
                                colors = new Color3f[valid];
                                for (i = 0; i < valid; ++i) {
                                    colors[i] = new Color3f((Color3f)c2[i + initial]);
                                }
                            } else {
                                colors = geomArray.getColorRef3f();
                            }
                        } else if (geomArray.getColorRefFloat() != null) {
                            c2 = geomArray.getColorRefFloat();
                            colors = new Color3f[valid];
                            for (i = 0; i < valid; ++i) {
                                colors[i] = new Color3f((float)c2[(i + initial) * 3 + 0], (float)c2[(i + initial) * 3 + 1], (float)c2[(i + initial) * 3 + 2]);
                            }
                        } else if (geomArray.getColorRefByte() != null) {
                            c2 = geomArray.getColorRefByte();
                            colors = new Color3f[valid];
                            for (i = 0; i < valid; ++i) {
                                colors[i] = new Color3f((float)(c2[(i + initial) * 3 + 0] & 0xFF) / 255.0f, (float)(c2[(i + initial) * 3 + 1] & 0xFF) / 255.0f, (float)(c2[(i + initial) * 3 + 2] & 0xFF) / 255.0f);
                            }
                        } else if (geomArray.getColorRef3b() != null) {
                            c2 = geomArray.getColorRef3b();
                            colors = new Color3f[valid];
                            for (i = 0; i < valid; ++i) {
                                colors[i] = new Color3f((float)(c2[i + initial].x & 0xFF) / 255.0f, (float)(c2[i + initial].y & 0xFF) / 255.0f, (float)(c2[i + initial].z & 0xFF) / 255.0f);
                            }
                        }
                        break block164;
                    }
                    initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                    colors = new Color3f[valid];
                    for (i = 0; i < valid; ++i) {
                        colors[i] = new Color3f();
                    }
                    geomArray.getColors(initial, colors);
                }
                geomInfo.setColors(colors);
            }
            if ((vertexFormat & 0x400) != 0) {
                geomInfo.setTextureCoordinateParams(texSets, 4);
                for (i = 0; i < texSets; ++i) {
                    int j;
                    int initial;
                    TexCoord4f[] tex = null;
                    if (byRef) {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialTexCoordIndex(i) : 0;
                        if (nio) {
                            buf = geomArray.getTexCoordRefBuffer(i);
                            if (BufferWrapper.getBufferType(buf) == 3) {
                                bb = (FloatBuffer)buf.getBuffer();
                                c = new float[valid * 4];
                                ((FloatBuffer)bb).position(initial * 4);
                                ((FloatBuffer)bb).get((float[])c, 0, valid * 4);
                                tex = new TexCoord4f[valid];
                                for (j = 0; j < valid; ++j) {
                                    tex[j] = new TexCoord4f(c[j * 4 + 0], c[j * 4 + 1], c[j * 4 + 2], c[j * 4 + 3]);
                                }
                            }
                        } else {
                            t = geomArray.getTexCoordRefFloat(i);
                            tex = new TexCoord4f[valid];
                            for (j = 0; j < valid; ++j) {
                                tex[j] = new TexCoord4f(t[(j + initial) * 4], t[(j + initial) * 4 + 1], t[(j + initial) * 4 + 2], t[(j + initial) * 4 + 3]);
                            }
                        }
                    } else {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                        tex = new TexCoord4f[valid];
                        for (j = 0; j < valid; ++j) {
                            tex[j] = new TexCoord4f();
                        }
                        geomArray.getTextureCoordinates(i, initial, tex);
                    }
                    geomInfo.setTextureCoordinates(i, tex);
                }
                int[] map = new int[geomArray.getTexCoordSetMapLength()];
                geomArray.getTexCoordSetMap(map);
                geomInfo.setTexCoordSetMap(map);
            } else if ((vertexFormat & 0x40) != 0) {
                geomInfo.setTextureCoordinateParams(texSets, 3);
                for (i = 0; i < texSets; ++i) {
                    int j;
                    int initial;
                    TexCoord3f[] tex = null;
                    if (byRef) {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialTexCoordIndex(i) : 0;
                        if (nio) {
                            buf = geomArray.getTexCoordRefBuffer(i);
                            if (BufferWrapper.getBufferType(buf) == 3) {
                                bb = (FloatBuffer)buf.getBuffer();
                                c = new float[valid * 3];
                                ((FloatBuffer)bb).position(initial * 3);
                                ((FloatBuffer)bb).get((float[])c, 0, valid * 3);
                                tex = new TexCoord3f[valid];
                                for (j = 0; j < valid; ++j) {
                                    tex[j] = new TexCoord3f(c[j * 3 + 0], c[j * 3 + 1], c[j * 3 + 2]);
                                }
                            }
                        } else if (geomArray.getTexCoordRef3f(i) != null) {
                            if (initial != 0) {
                                t = geomArray.getTexCoordRef3f(i);
                                tex = new TexCoord3f[valid];
                                for (j = 0; j < valid; ++j) {
                                    tex[j] = new TexCoord3f((TexCoord3f)t[j + initial]);
                                }
                            } else {
                                tex = geomArray.getTexCoordRef3f(i);
                            }
                        } else if (geomArray.getTexCoordRefFloat(i) != null) {
                            t = geomArray.getTexCoordRefFloat(i);
                            tex = new TexCoord3f[valid];
                            for (j = 0; j < valid; ++j) {
                                tex[j] = new TexCoord3f(t[(j + initial) * 3], t[(j + initial) * 3 + 1], t[(j + initial) * 3 + 2]);
                            }
                        }
                    } else {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                        tex = new TexCoord3f[valid];
                        for (j = 0; j < valid; ++j) {
                            tex[j] = new TexCoord3f();
                        }
                        geomArray.getTextureCoordinates(i, initial, tex);
                    }
                    geomInfo.setTextureCoordinates(i, tex);
                }
                int[] map = new int[geomArray.getTexCoordSetMapLength()];
                geomArray.getTexCoordSetMap(map);
                geomInfo.setTexCoordSetMap(map);
            } else if ((vertexFormat & 0x20) != 0) {
                geomInfo.setTextureCoordinateParams(texSets, 2);
                for (i = 0; i < texSets; ++i) {
                    int j;
                    int initial;
                    TexCoord2f[] tex = null;
                    if (byRef) {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialTexCoordIndex(i) : 0;
                        if (nio) {
                            buf = geomArray.getTexCoordRefBuffer(i);
                            if (BufferWrapper.getBufferType(buf) == 3) {
                                bb = (FloatBuffer)buf.getBuffer();
                                c = new float[valid * 2];
                                ((FloatBuffer)bb).position(initial * 2);
                                ((FloatBuffer)bb).get((float[])c, 0, valid * 2);
                                tex = new TexCoord2f[valid];
                                for (j = 0; j < valid; ++j) {
                                    tex[j] = new TexCoord2f(c[j * 2 + 0], c[j * 2 + 1]);
                                }
                            }
                        } else if (geomArray.getTexCoordRefFloat(i) != null) {
                            t = geomArray.getTexCoordRefFloat(i);
                            tex = new TexCoord2f[valid];
                            for (j = 0; j < valid; ++j) {
                                tex[j] = new TexCoord2f(t[(j + initial) * 2 + 0], t[(j + initial) * 2 + 1]);
                            }
                        } else if (geomArray.getTexCoordRef2f(i) != null) {
                            if (initial != 0) {
                                t = geomArray.getTexCoordRef2f(i);
                                tex = new TexCoord2f[valid];
                                for (j = 0; j < valid; ++j) {
                                    tex[j] = new TexCoord2f((TexCoord2f)t[j + initial]);
                                }
                            } else {
                                tex = geomArray.getTexCoordRef2f(i);
                            }
                        }
                    } else {
                        initial = !(geomArray instanceof IndexedGeometryArray) ? geomArray.getInitialVertexIndex() : 0;
                        tex = new TexCoord2f[valid];
                        for (j = 0; j < valid; ++j) {
                            tex[j] = new TexCoord2f();
                        }
                        geomArray.getTextureCoordinates(i, initial, tex);
                    }
                    geomInfo.setTextureCoordinates(i, tex);
                }
                int[] map = new int[geomArray.getTexCoordSetMapLength()];
                geomArray.getTexCoordSetMap(map);
                geomInfo.setTexCoordSetMap(map);
            }
        }
    }

    private static void processIndexedArray(GeometryInfo geomInfo, IndexedGeometryArray geomArray) {
        block11: {
            int valid;
            int texSets;
            int vertexFormat;
            int initial;
            block10: {
                initial = geomArray.getInitialIndexIndex();
                vertexFormat = geomArray.getVertexFormat();
                texSets = geomArray.getTexCoordSetCount();
                if (geomArray instanceof IndexedGeometryStripArray) {
                    IndexedGeometryStripArray igsa = (IndexedGeometryStripArray)geomArray;
                    int[] strips = new int[igsa.getNumStrips()];
                    igsa.getStripIndexCounts(strips);
                    valid = 0;
                    for (int i = 0; i < strips.length; ++i) {
                        valid += strips[i];
                    }
                } else {
                    valid = geomArray.getValidIndexCount();
                }
                int[] coordI = new int[valid];
                geomArray.getCoordinateIndices(initial, coordI);
                geomInfo.setCoordinateIndices(coordI);
                if ((vertexFormat & 0x200) == 0) break block10;
                if ((vertexFormat & 2) != 0) {
                    geomInfo.setNormalIndices(coordI);
                }
                if ((vertexFormat & 4) != 0 || (vertexFormat & 0xC) != 0) {
                    geomInfo.setColorIndices(coordI);
                }
                if ((vertexFormat & 0x20) == 0 && (vertexFormat & 0x40) == 0 && (vertexFormat & 0x400) == 0) break block11;
                for (int i = 0; i < texSets; ++i) {
                    geomInfo.setTextureCoordinateIndices(i, coordI);
                }
                break block11;
            }
            if ((vertexFormat & 2) != 0) {
                int[] normalI = new int[valid];
                geomArray.getNormalIndices(initial, normalI);
                geomInfo.setNormalIndices(normalI);
            }
            if ((vertexFormat & 4) != 0 || (vertexFormat & 0xC) != 0) {
                int[] colorI = new int[valid];
                geomArray.getColorIndices(initial, colorI);
                geomInfo.setColorIndices(colorI);
            }
            if ((vertexFormat & 0x20) != 0 || (vertexFormat & 0x40) != 0 || (vertexFormat & 0x400) != 0) {
                for (int i = 0; i < texSets; ++i) {
                    int[] texI = new int[valid];
                    geomArray.getTextureCoordinateIndices(i, initial, texI);
                    geomInfo.setTextureCoordinateIndices(i, texI);
                }
            }
        }
    }

    private static void processStripArray(GeometryInfo geomInfo, GeometryStripArray geomArray) {
        int[] strips = new int[geomArray.getNumStrips()];
        geomArray.getStripVertexCounts(strips);
        geomInfo.setStripCounts(strips);
    }

    private static void processIndexStripArray(GeometryInfo geomInfo, IndexedGeometryStripArray geomArray) {
        int[] strips = new int[geomArray.getNumStrips()];
        geomArray.getStripIndexCounts(strips);
        geomInfo.setStripCounts(strips);
    }
}

