/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Basic;
import org.jogamp.java3d.utils.geometry.Numerics;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Matrix4f;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Tuple3f;
import org.jogamp.vecmath.Vector3f;

class Project {
    Project() {
    }

    static void projectFace(Triangulator triRef, int loopMin, int loopMax) {
        Vector3f normal = new Vector3f();
        Vector3f nr = new Vector3f();
        Project.determineNormal(triRef, triRef.loops[loopMin], normal);
        int j = loopMin + 1;
        if (j < loopMax) {
            for (int i = j; i < loopMax; ++i) {
                Project.determineNormal(triRef, triRef.loops[i], nr);
                if (Basic.dotProduct((Tuple3f)normal, (Tuple3f)nr) < 0.0) {
                    Basic.invertVector((Tuple3f)nr);
                }
                Basic.vectorAdd((Tuple3f)normal, (Tuple3f)nr, (Tuple3f)normal);
            }
            double d = Basic.lengthL2((Tuple3f)normal);
            if (Numerics.gt(d, 1.0E-8)) {
                Basic.divScalar(d, (Tuple3f)normal);
            } else {
                normal.y = 0.0f;
                normal.x = 0.0f;
                normal.z = 1.0f;
            }
        }
        Project.projectPoints(triRef, loopMin, loopMax, normal);
    }

    static void determineNormal(Triangulator triRef, int ind, Vector3f normal) {
        int ind1 = ind;
        int i1 = triRef.fetchData(ind1);
        int ind0 = triRef.fetchPrevData(ind1);
        int i0 = triRef.fetchData(ind0);
        int ind2 = triRef.fetchNextData(ind1);
        int i2 = triRef.fetchData(ind2);
        Vector3f pq = new Vector3f();
        Basic.vectorSub((Tuple3f)triRef.vertices[i0], (Tuple3f)triRef.vertices[i1], (Tuple3f)pq);
        Vector3f pr = new Vector3f();
        Basic.vectorSub((Tuple3f)triRef.vertices[i2], (Tuple3f)triRef.vertices[i1], (Tuple3f)pr);
        Vector3f nr = new Vector3f();
        Basic.vectorProduct((Tuple3f)pq, (Tuple3f)pr, (Tuple3f)nr);
        double d = Basic.lengthL2((Tuple3f)nr);
        if (Numerics.gt(d, 1.0E-8)) {
            Basic.divScalar(d, (Tuple3f)nr);
            normal.set((Tuple3f)nr);
        } else {
            normal.z = 0.0f;
            normal.y = 0.0f;
            normal.x = 0.0f;
        }
        pq.set((Tuple3f)pr);
        ind1 = ind2;
        ind2 = triRef.fetchNextData(ind1);
        i2 = triRef.fetchData(ind2);
        while (ind1 != ind) {
            Basic.vectorSub((Tuple3f)triRef.vertices[i2], (Tuple3f)triRef.vertices[i1], (Tuple3f)pr);
            Basic.vectorProduct((Tuple3f)pq, (Tuple3f)pr, (Tuple3f)nr);
            d = Basic.lengthL2((Tuple3f)nr);
            if (Numerics.gt(d, 1.0E-8)) {
                Basic.divScalar(d, (Tuple3f)nr);
                if (Basic.dotProduct((Tuple3f)normal, (Tuple3f)nr) < 0.0) {
                    Basic.invertVector((Tuple3f)nr);
                }
                Basic.vectorAdd((Tuple3f)normal, (Tuple3f)nr, (Tuple3f)normal);
            }
            pq.set((Tuple3f)pr);
            ind1 = ind2;
            ind2 = triRef.fetchNextData(ind1);
            i2 = triRef.fetchData(ind2);
        }
        d = Basic.lengthL2((Tuple3f)normal);
        if (Numerics.gt(d, 1.0E-8)) {
            Basic.divScalar(d, (Tuple3f)normal);
        } else {
            normal.y = 0.0f;
            normal.x = 0.0f;
            normal.z = 1.0f;
        }
    }

    static void projectPoints(Triangulator triRef, int i1, int i2, Vector3f n3) {
        Matrix4f matrix = new Matrix4f();
        Point3f vtx = new Point3f();
        Vector3f n1 = new Vector3f();
        Vector3f n2 = new Vector3f();
        if ((double)Math.abs(n3.x) > 0.1 || (double)Math.abs(n3.y) > 0.1) {
            n1.x = -n3.y;
            n1.y = n3.x;
            n1.z = 0.0f;
        } else {
            n1.x = n3.z;
            n1.z = -n3.x;
            n1.y = 0.0f;
        }
        double d = Basic.lengthL2((Tuple3f)n1);
        Basic.divScalar(d, (Tuple3f)n1);
        Basic.vectorProduct((Tuple3f)n1, (Tuple3f)n3, (Tuple3f)n2);
        d = Basic.lengthL2((Tuple3f)n2);
        Basic.divScalar(d, (Tuple3f)n2);
        matrix.m00 = n1.x;
        matrix.m01 = n1.y;
        matrix.m02 = n1.z;
        matrix.m03 = 0.0f;
        matrix.m10 = n2.x;
        matrix.m11 = n2.y;
        matrix.m12 = n2.z;
        matrix.m13 = 0.0f;
        matrix.m20 = n3.x;
        matrix.m21 = n3.y;
        matrix.m22 = n3.z;
        matrix.m23 = 0.0f;
        matrix.m30 = 0.0f;
        matrix.m31 = 0.0f;
        matrix.m32 = 0.0f;
        matrix.m33 = 1.0f;
        triRef.initPnts(20);
        for (int i = i1; i < i2; ++i) {
            int ind;
            int ind1 = ind = triRef.loops[i];
            int j1 = triRef.fetchData(ind1);
            matrix.transform(triRef.vertices[j1], vtx);
            j1 = triRef.storePoint(vtx.x, vtx.y);
            triRef.updateIndex(ind1, j1);
            ind1 = triRef.fetchNextData(ind1);
            j1 = triRef.fetchData(ind1);
            while (ind1 != ind) {
                matrix.transform(triRef.vertices[j1], vtx);
                j1 = triRef.storePoint(vtx.x, vtx.y);
                triRef.updateIndex(ind1, j1);
                ind1 = triRef.fetchNextData(ind1);
                j1 = triRef.fetchData(ind1);
            }
        }
    }
}

