/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.pickfast.behaviors;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.utils.behaviors.mouse.MouseBehaviorCallback;
import org.jogamp.java3d.utils.behaviors.mouse.MouseZoom;
import org.jogamp.java3d.utils.pickfast.behaviors.PickMouseBehavior;
import org.jogamp.java3d.utils.pickfast.behaviors.PickingCallback;

public class PickZoomBehavior
extends PickMouseBehavior
implements MouseBehaviorCallback {
    MouseZoom zoom = new MouseZoom(1);
    private PickingCallback callback = null;
    private TransformGroup currentTG;

    public PickZoomBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
        super(canvas, root, bounds);
        this.zoom.setTransformGroup(this.currGrp);
        this.currGrp.addChild(this.zoom);
        this.zoom.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
    }

    public PickZoomBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, int pickMode) {
        super(canvas, root, bounds);
        this.zoom.setTransformGroup(this.currGrp);
        this.currGrp.addChild(this.zoom);
        this.zoom.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.setMode(pickMode);
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        TransformGroup tg = null;
        if (this.mevent.isAltDown() && !this.mevent.isMetaDown()) {
            this.pickCanvas.setShapeLocation(xpos, ypos);
            this.pickCanvas.setFlags(3);
            PickInfo pickInfo = this.pickCanvas.pickClosest();
            if (pickInfo != null) {
                tg = (TransformGroup)this.pickCanvas.getNode(pickInfo, 32);
                if (tg != null && tg.getCapability(17) && tg.getCapability(18)) {
                    this.zoom.setTransformGroup(tg);
                    this.zoom.wakeup();
                    this.currentTG = tg;
                }
            } else if (this.callback != null) {
                this.callback.transformChanged(3, null);
            }
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(2, this.currentTG);
    }

    public void setupCallback(PickingCallback callback) {
        this.callback = callback;
        if (callback == null) {
            this.zoom.setupCallback(null);
        } else {
            this.zoom.setupCallback(this);
        }
    }
}

