/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.retained;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.SceneGraphObjectState;

public class SymbolTableData {
    public int nodeID;
    public SceneGraphObjectState nodeState;
    public SceneGraphObject j3dNode;
    public int referenceCount;
    public long filePosition;
    public boolean isNodeComponent;
    public int branchGraphID;
    public long branchGraphFilePointer;
    public boolean graphBuilt = false;

    public SymbolTableData(int nodeID, SceneGraphObject j3dNode, SceneGraphObjectState nodeState, int branchGraphID) {
        this.nodeID = nodeID;
        this.j3dNode = j3dNode;
        this.nodeState = nodeState;
        this.branchGraphID = branchGraphID;
        this.referenceCount = 1;
        this.isNodeComponent = false;
    }

    public void writeObject(DataOutput out) throws IOException {
        out.writeInt(this.nodeID);
        out.writeInt(this.referenceCount);
        out.writeLong(this.filePosition);
        out.writeBoolean(this.isNodeComponent);
        out.writeInt(this.branchGraphID);
        out.writeLong(this.branchGraphFilePointer);
    }

    public void readObject(DataInput in) throws IOException {
        this.nodeID = in.readInt();
        this.referenceCount = in.readInt();
        this.filePosition = in.readLong();
        this.isNodeComponent = in.readBoolean();
        this.branchGraphID = in.readInt();
        this.branchGraphFilePointer = in.readLong();
    }

    public final int getNodeID() {
        return this.nodeID;
    }

    public final SceneGraphObjectState getNodeState() {
        return this.nodeState;
    }

    public final void setNodeState(SceneGraphObjectState state) {
        this.nodeState = state;
    }

    public final SceneGraphObject getJ3dNode() {
        return this.j3dNode;
    }

    public final long getFilePosition() {
        return this.filePosition;
    }

    public final int getReferenceCount() {
        return this.referenceCount;
    }

    public final void incrementReferenceCount() {
        ++this.referenceCount;
    }

    public final boolean isNodeComponent() {
        return this.isNodeComponent;
    }

    public String toString() {
        return new String(this.nodeID + " " + this.filePosition + "  " + this.j3dNode);
    }
}

