/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij;

import ij.process.ImageProcessor;
import java.util.concurrent.atomic.AtomicInteger;
import jitk.spline.ThinPlateR2LogRSplineKernelTransform;

public class ThinPlateSplineMapping {
    ThinPlateR2LogRSplineKernelTransform xfm;

    public ThinPlateSplineMapping(ThinPlateR2LogRSplineKernelTransform xfm) {
        this.xfm = xfm;
    }

    public ThinPlateR2LogRSplineKernelTransform getTransform() {
        return this.xfm;
    }

    public void map(ImageProcessor source, ImageProcessor target) {
        ThinPlateSplineMapping.mapInterval(this.xfm, source, target);
    }

    public void mapInterpolated(ImageProcessor source, ImageProcessor target) {
        System.out.println("mapping interpolated");
        ThinPlateSplineMapping.mapInterval(this.xfm, source, target);
    }

    public static final void mapInterval(ThinPlateR2LogRSplineKernelTransform xfm, ImageProcessor src, ImageProcessor tgt) {
        int w = tgt.getWidth() - 1;
        int h = tgt.getHeight() - 1;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                double[] srcPt = xfm.apply(new double[]{x, y});
                tgt.putPixel(x, y, src.getPixelInterpolated(srcPt[0], srcPt[1]));
            }
        }
    }

    private static final class MapThinPlateSplineInterpolatedThread
    extends Thread {
        private final AtomicInteger i;

        MapThinPlateSplineInterpolatedThread(AtomicInteger i) {
            this.i = i;
        }

        @Override
        public final void run() {
            int k = this.i.getAndIncrement();
        }
    }
}

