/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2;

import net.imglib2.Cursor;
import net.imglib2.PairIterator;
import net.imglib2.PredicateCursor;
import net.imglib2.RandomAccess;
import net.imglib2.predicate.MaskPredicate;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;

public class TwinCursor<T extends Type<T>>
implements Cursor<T>,
PairIterator<T> {
    protected final PredicateCursor<BitType> mask;
    protected final RandomAccess<T> channel1;
    protected final RandomAccess<T> channel2;
    protected final long[] position;
    protected boolean gotNext;

    public TwinCursor(RandomAccess<T> channel1, RandomAccess<T> channel2, Cursor<BitType> mask) {
        MaskPredicate predicate = new MaskPredicate();
        this.mask = new PredicateCursor<BitType>(mask, predicate);
        this.channel1 = channel1;
        this.channel2 = channel2;
        this.position = new long[mask.numDimensions()];
        mask.localize(this.position);
    }

    @Override
    public final boolean hasNext() {
        this.gotNext = false;
        return this.mask.hasNext();
    }

    public final void getNext() {
        if (this.gotNext) {
            return;
        }
        this.mask.next();
        this.mask.localize(this.position);
        this.channel1.setPosition(this.position);
        this.channel2.setPosition(this.position);
        this.gotNext = true;
    }

    @Override
    public final T getFirst() {
        this.getNext();
        return (T)((Type)this.channel1.get());
    }

    @Override
    public final T getSecond() {
        this.getNext();
        return (T)((Type)this.channel2.get());
    }

    @Override
    public void reset() {
        this.gotNext = false;
        this.mask.reset();
    }

    @Override
    public void fwd() {
        if (this.hasNext()) {
            this.getNext();
        }
    }

    public void jumpFwd(long arg0) {
        throw new UnsupportedOperationException("This method has not been implemented, yet.");
    }

    public T next() {
        throw new UnsupportedOperationException("This method has not been implemented, yet.");
    }

    public void remove() {
        throw new UnsupportedOperationException("This method has not been implemented, yet.");
    }

    public double getDoublePosition(int arg0) {
        return this.mask.getDoublePosition(arg0);
    }

    public float getFloatPosition(int arg0) {
        return this.mask.getFloatPosition(arg0);
    }

    public void localize(float[] arg0) {
        this.mask.localize(arg0);
    }

    public void localize(double[] arg0) {
        this.mask.localize(arg0);
    }

    public int numDimensions() {
        return this.mask.numDimensions();
    }

    public T get() {
        throw new UnsupportedOperationException("This method has not been implemented, yet.");
    }

    public int getIntPosition(int arg0) {
        return this.mask.getIntPosition(arg0);
    }

    public long getLongPosition(int arg0) {
        return this.mask.getLongPosition(arg0);
    }

    public void localize(int[] arg0) {
        this.mask.localize(arg0);
    }

    public void localize(long[] arg0) {
        this.mask.localize(arg0);
    }

    public Cursor<T> copy() {
        throw new UnsupportedOperationException("This method has not been implemented, yet.");
    }
}

