/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import ij.measure.ResultsTable;
import java.util.EnumSet;
import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Algorithm;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.DataContainer;
import sc.fiji.coloc.results.ResultHandler;

public class Histogram2D<T extends RealType<T>>
extends Algorithm<T> {
    EnumSet<DrawingFlags> drawingSettings;
    protected int xBins = 256;
    protected int yBins = 256;
    protected String title = "";
    protected boolean swapChannels = false;
    protected String ch1Label = "Channel 1";
    protected String ch2Label = "Channel 2";
    private RandomAccessibleInterval<LongType> plotImage;
    private double xBinWidth = 0.0;
    private double yBinWidth = 0.0;
    private String xLabel = "";
    private String yLabel = "";
    private double xMin = 0.0;
    private double xMax = 0.0;
    private double yMin = 0.0;
    private double yMax = 0.0;

    public Histogram2D() {
        this("2D Histogram");
    }

    public Histogram2D(String title) {
        this(title, false);
    }

    public Histogram2D(String title, boolean swapChannels) {
        this(title, swapChannels, EnumSet.of(DrawingFlags.Plot, DrawingFlags.RegressionLine));
    }

    public Histogram2D(String title, boolean swapChannels, EnumSet<DrawingFlags> drawingSettings) {
        super(title);
        this.title = title;
        this.swapChannels = swapChannels;
        if (swapChannels) {
            int xBins = this.xBins;
            this.xBins = this.yBins;
            this.yBins = xBins;
        }
        this.drawingSettings = drawingSettings;
    }

    protected double getMinCh1(DataContainer<T> container) {
        return this.swapChannels ? container.getMinCh2() : container.getMinCh1();
    }

    protected double getMinCh2(DataContainer<T> container) {
        return this.swapChannels ? container.getMinCh1() : container.getMinCh2();
    }

    protected double getMaxCh1(DataContainer<T> container) {
        return this.swapChannels ? container.getMaxCh2() : container.getMaxCh1();
    }

    protected double getMaxCh2(DataContainer<T> container) {
        return this.swapChannels ? container.getMaxCh1() : container.getMaxCh2();
    }

    protected RandomAccessibleInterval<T> getImageCh1(DataContainer<T> container) {
        return this.swapChannels ? container.getSourceImage2() : container.getSourceImage1();
    }

    protected RandomAccessibleInterval<T> getImageCh2(DataContainer<T> container) {
        return this.swapChannels ? container.getSourceImage1() : container.getSourceImage2();
    }

    protected String getLabelCh1() {
        return this.swapChannels ? this.ch2Label : this.ch1Label;
    }

    protected String getLabelCh2() {
        return this.swapChannels ? this.ch1Label : this.ch2Label;
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        this.generateHistogramData(container);
    }

    protected void generateHistogramData(DataContainer<T> container) {
        double ch1BinWidth = this.getXBinWidth(container);
        double ch2BinWidth = this.getYBinWidth(container);
        RandomAccessibleInterval<T> img1 = this.getImageCh1(container);
        RandomAccessibleInterval<T> img2 = this.getImageCh2(container);
        RandomAccessibleInterval<BitType> mask = container.getMask();
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        ArrayImgFactory scatterFactory = new ArrayImgFactory();
        this.plotImage = scatterFactory.create(new int[]{this.xBins, this.yBins}, (Object)new LongType());
        RandomAccess histogram2DCursor = this.plotImage.randomAccess();
        long ignoredPixelCount = 0L;
        long[] pos = new long[this.plotImage.numDimensions()];
        while (cursor.hasNext()) {
            cursor.fwd();
            double ch1 = ((RealType)cursor.getFirst()).getRealDouble();
            double ch2 = ((RealType)cursor.getSecond()).getRealDouble();
            pos[0] = this.getXValue(ch1, ch1BinWidth, ch2, ch2BinWidth);
            pos[1] = this.getYValue(ch1, ch1BinWidth, ch2, ch2BinWidth);
            if (pos[0] >= 0L && pos[1] >= 0L && pos[0] < (long)this.xBins && pos[1] < (long)this.yBins) {
                histogram2DCursor.setPosition(pos);
                long count = ((LongType)histogram2DCursor.get()).getIntegerLong();
                ((LongType)histogram2DCursor.get()).set(++count);
                continue;
            }
            ++ignoredPixelCount;
        }
        if (ignoredPixelCount > 0L) {
            this.addWarning("Ignored pixels while generating histogram.", "" + ignoredPixelCount + " pixels were ignored while generating the 2D histogram \"" + this.title + "\" because the grey values were out of range.This may happen, if an image contains negative pixel values.");
        }
        this.xBinWidth = ch1BinWidth;
        this.yBinWidth = ch2BinWidth;
        this.xLabel = this.getLabelCh1();
        this.yLabel = this.getLabelCh2();
        this.xMin = this.getXMin(container);
        this.xMax = this.getXMax(container);
        this.yMin = this.getYMin(container);
        this.yMax = this.getYMax(container);
    }

    public String getData() {
        StringBuffer sb = new StringBuffer();
        double xBinWidth = 1.0 / this.getXBinWidth();
        double yBinWidth = 1.0 / this.getYBinWidth();
        double xMin = this.getXMin();
        double yMin = this.getYMin();
        boolean xBinWidthIsOne = Math.abs(xBinWidth - 1.0) < 1.0E-5;
        boolean yBinWidthIsOne = Math.abs(yBinWidth - 1.0) < 1.0E-5;
        int xDecimalPlaces = xBinWidthIsOne ? 0 : 3;
        int yDecimalPlaces = yBinWidthIsOne ? 0 : 3;
        RandomAccess cursor = this.plotImage.randomAccess();
        int i = 0;
        while ((long)i < this.plotImage.dimension(0)) {
            int j = 0;
            while ((long)j < this.plotImage.dimension(1)) {
                cursor.setPosition(i, 0);
                cursor.setPosition(j, 1);
                sb.append(ResultsTable.d2s((double)(xMin + (double)i * xBinWidth), (int)xDecimalPlaces) + "\t" + ResultsTable.d2s((double)(yMin + (double)j * yBinWidth), (int)yDecimalPlaces) + "\t" + ResultsTable.d2s((double)((LongType)cursor.get()).getRealDouble(), (int)0) + "\n");
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public void processResults(ResultHandler<T> handler) {
        super.processResults(handler);
        handler.handleHistogram(this, this.title);
    }

    protected double getXBinWidth(DataContainer<T> container) {
        double ch1Max = this.getMaxCh1(container);
        if (ch1Max < (double)this.yBins) {
            return 1.0;
        }
        return ((double)this.yBins - 0.50001) / ch1Max;
    }

    protected double getYBinWidth(DataContainer<T> container) {
        double ch2Max = this.getMaxCh2(container);
        if (ch2Max < (double)this.yBins) {
            return 1.0;
        }
        return ((double)this.yBins - 0.50001) / ch2Max;
    }

    protected int getXValue(double ch1Val, double ch1BinWidth, double ch2Val, double ch2BinWidth) {
        return (int)(ch1Val * ch1BinWidth + 0.5);
    }

    protected int getYValue(double ch1Val, double ch1BinWidth, double ch2Val, double ch2BinWidth) {
        return this.yBins - 1 - (int)(ch2Val * ch2BinWidth + 0.5);
    }

    protected double getXMin(DataContainer<T> container) {
        return 0.0;
    }

    protected double getXMax(DataContainer<T> container) {
        return this.swapChannels ? this.getMaxCh2(container) : this.getMaxCh1(container);
    }

    protected double getYMin(DataContainer<T> container) {
        return 0.0;
    }

    protected double getYMax(DataContainer<T> container) {
        return this.swapChannels ? this.getMaxCh1(container) : this.getMaxCh2(container);
    }

    public RandomAccessibleInterval<LongType> getPlotImage() {
        return this.plotImage;
    }

    public double getXBinWidth() {
        return this.xBinWidth;
    }

    public double getYBinWidth() {
        return this.yBinWidth;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public double getXMin() {
        return this.xMin;
    }

    public double getXMax() {
        return this.xMax;
    }

    public double getYMin() {
        return this.yMin;
    }

    public double getYMax() {
        return this.yMax;
    }

    public String getTitle() {
        return this.title;
    }

    public EnumSet<DrawingFlags> getDrawingSettings() {
        return this.drawingSettings;
    }

    public static enum DrawingFlags {
        Plot,
        RegressionLine,
        Axes;

    }
}

