/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.lang.reflect.Field;
import java.util.List;
import net.imagej.ops.Op;
import net.imagej.ops.OpListing;
import net.imagej.ops.OpUtils;
import org.scijava.Prioritized;
import org.scijava.command.CommandInfo;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;
import org.scijava.util.ClassUtils;

public class OpInfo
implements Comparable<OpInfo> {
    private final CommandInfo cInfo;

    public OpInfo(CommandInfo cInfo) {
        this.cInfo = cInfo;
    }

    public OpInfo(Class<? extends Op> opClass) {
        this(new CommandInfo(opClass));
    }

    public CommandInfo cInfo() {
        return this.cInfo;
    }

    public List<ModuleItem<?>> inputs() {
        return OpUtils.inputs((ModuleInfo)this.cInfo());
    }

    public List<ModuleItem<?>> outputs() {
        return OpUtils.outputs((ModuleInfo)this.cInfo());
    }

    public boolean isNamed() {
        String name = this.getName();
        return name != null && !name.isEmpty();
    }

    public String getName() {
        String name = this.cInfo().getName();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        return this.getFieldValue(String.class, "NAME");
    }

    public String getSimpleName() {
        return OpUtils.stripNamespace(this.getName());
    }

    public boolean nameMatches(String name) {
        if (name == null) {
            return true;
        }
        String opName = this.getName();
        if (OpInfo.nameMatches(opName, name)) {
            return true;
        }
        String[] aliases = this.getAliases();
        if (aliases != null) {
            for (String a : aliases) {
                if (!OpInfo.nameMatches(a, name)) continue;
                return true;
            }
        }
        return false;
    }

    public String[] getAliases() {
        String alias = this.cInfo().get("alias");
        if (alias != null) {
            return new String[]{alias};
        }
        String aliases = this.cInfo().get("aliases");
        if (aliases != null) {
            return aliases.split("\\s*,\\s*");
        }
        String aliasField = this.getFieldValue(String.class, "ALIAS");
        if (aliasField != null) {
            return new String[]{aliasField};
        }
        String aliasesField = this.getFieldValue(String.class, "ALIASES");
        if (aliasesField != null) {
            return aliasesField.split("\\s*,\\s*");
        }
        return null;
    }

    public String getNamespace() {
        return OpUtils.getNamespace(this.getName());
    }

    public boolean isNamespace(String namespace) {
        String ns = this.getNamespace();
        if (ns == null) {
            return namespace == null;
        }
        return ns.equals(namespace) || ns.startsWith(namespace + ".");
    }

    public Class<? extends Op> getType() {
        Class type = this.cInfo.getAnnotation().type();
        if (type == null || !Op.class.isAssignableFrom(type)) {
            throw new IllegalStateException("Op type " + type + " is not an Op!");
        }
        Class opType = type;
        return opType;
    }

    public OpListing listing() {
        return new OpListing(this);
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpInfo)) {
            return false;
        }
        OpInfo that = (OpInfo)o;
        return this.cInfo().equals(that.cInfo());
    }

    public int hashCode() {
        return this.cInfo().hashCode();
    }

    public String toString() {
        return OpUtils.opString((ModuleInfo)this.cInfo());
    }

    @Override
    public int compareTo(OpInfo that) {
        return this.cInfo().compareTo((Prioritized)that.cInfo());
    }

    private <T> T getFieldValue(Class<T> fieldType, String fieldName) {
        Class<? extends Op> opType = this.getType();
        Field nameField = ClassUtils.getField(opType, (String)fieldName);
        if (nameField == null) {
            return null;
        }
        if (!fieldType.isAssignableFrom(nameField.getType())) {
            return null;
        }
        Object value = ClassUtils.getValue((Field)nameField, null);
        return (T)value;
    }

    private static boolean nameMatches(String opName, String name) {
        if (opName == null) {
            return false;
        }
        if (name.equals(opName)) {
            return true;
        }
        int dot = opName.lastIndexOf(".");
        return dot >= 0 && name.equals(opName.substring(dot + 1));
    }
}

