/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.util.ArrayList;
import java.util.List;
import net.imagej.ops.OpListingInfo;
import net.imagej.ops.OpService;
import net.imagej.ops.OpUtils;
import org.scijava.module.AbstractModule;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleItem;

class OpListingModule
extends AbstractModule {
    private final OpService opService;
    private final OpListingInfo info;

    public OpListingModule(OpService opService, OpListingInfo info) {
        this.opService = opService;
        this.info = info;
    }

    public ModuleInfo getInfo() {
        return this.info;
    }

    public void run() {
        Object[] args = this.opArgs();
        Object out = this.opService.run(this.info.getName(), args);
        this.resolveOutput(out);
    }

    private void resolveOutput(Object out) {
        List<ModuleItem<?>> outputs = OpUtils.outputs(this.getInfo());
        if (outputs.size() == 1) {
            this.setOutput(outputs.get(0).getName(), out);
        } else if (outputs.size() > 1) {
            if (!(out instanceof List)) {
                throw new IllegalArgumentException("Op with multiple declared outputs only returns one!");
            }
            List outs = (List)out;
            if (outs.size() != outputs.size()) {
                throw new IllegalArgumentException("Op declared " + outputs.size() + " outputs but only returned " + outs.size() + " outputs!");
            }
            for (int i = 0; i < outs.size(); ++i) {
                this.setOutput(outputs.get(i).getName(), outs.get(i));
            }
        }
    }

    private Object[] opArgs() {
        ArrayList<Object> args = new ArrayList<Object>();
        for (ModuleItem item : this.info.inputs()) {
            args.add(this.getInput(item.getName()));
        }
        return args.toArray();
    }
}

