/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.scijava.util.Types;

public class OpMatchingUtil {
    private OpMatchingUtil() {
    }

    public static Class<?> getClass(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Class) {
            return Types.box((Class)((Class)obj));
        }
        if (obj instanceof ParameterizedType) {
            return (Class)((ParameterizedType)obj).getRawType();
        }
        return obj.getClass();
    }

    public static int findCastLevels(Class<?> dest, Class<?> origin) {
        if (dest.equals(origin)) {
            return 0;
        }
        int level = 1;
        Class<?> currType = origin;
        if (dest.isInterface()) {
            HashSet<String> seen = new HashSet<String>();
            ArrayList<Type> currIfaces = new ArrayList<Type>(Arrays.asList(currType.getGenericInterfaces()));
            do {
                ArrayList<Type> nextIfaces = new ArrayList<Type>();
                for (Type iface : currIfaces) {
                    if (seen.contains(iface.getTypeName())) continue;
                    Class<?> cls = OpMatchingUtil.getClass(iface);
                    if (cls.equals(dest)) {
                        return level;
                    }
                    seen.add(iface.getTypeName());
                    nextIfaces.addAll(Arrays.asList(cls.getGenericInterfaces()));
                }
                currIfaces.clear();
                currIfaces.addAll(nextIfaces);
                if (currType.getSuperclass() != null) {
                    currType = currType.getSuperclass();
                    currIfaces.addAll(Arrays.asList(currType.getGenericInterfaces()));
                }
                ++level;
            } while (!currIfaces.isEmpty() || currType.getSuperclass() != null);
        } else {
            while (currType.getSuperclass() != null) {
                if ((currType = currType.getSuperclass()).equals(dest)) {
                    return level;
                }
                ++level;
            }
        }
        return -1;
    }
}

