/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.deconvolve;

import net.imagej.ops.Ops;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.Hybrids;
import net.imagej.ops.special.hybrid.UnaryHybridCF;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Deconvolve.FirstGuess.class, priority=-100.0)
public class NonCirculantFirstGuess<I extends RealType<I>, O extends RealType<O>, K extends RealType<K>, C extends ComplexType<C>>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<I>, RandomAccessibleInterval<O>>
implements Ops.Deconvolve.FirstGuess {
    @Parameter
    private O outType;
    @Parameter
    private Dimensions k;
    UnaryFunctionOp<Dimensions, Img<O>> create;
    UnaryHybridCF<RandomAccessibleInterval<I>, O> sum;

    @Override
    public void initialize() {
        super.initialize();
        this.create = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, Dimensions.class, new Object[]{this.outType});
        this.sum = Hybrids.unaryCF(this.ops(), Ops.Stats.Sum.class, this.outType, RandomAccessibleInterval.class, new Object[0]);
    }

    @Override
    public RandomAccessibleInterval<O> calculate(RandomAccessibleInterval<I> in) {
        Img<O> firstGuess = this.create.calculate((Dimensions)in);
        RealType s = (RealType)this.sum.calculate(in);
        long numPixels = 1L;
        for (int d = 0; d < this.k.numDimensions(); ++d) {
            numPixels *= this.k.dimension(d);
        }
        double average = s.getRealDouble() / (double)numPixels;
        for (RealType type : firstGuess) {
            type.setReal(average);
        }
        return firstGuess;
    }
}

