/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocPXMinusY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.Contrast.class, label="Haralick: Contrast")
public class DefaultContrast<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.Contrast {
    private UnaryFunctionOp<double[][], double[]> coocPXMinusYFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocPXMinusYFunc = Functions.unary(this.ops(), CoocPXMinusY.class, double[].class, double[][].class, new Object[0]);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double[] pxminusxy = this.coocPXMinusYFunc.calculate(matrix);
        double res = 0.0;
        for (int k = 0; k <= matrix.length - 1; ++k) {
            res += (double)(k * k) * pxminusxy[k];
        }
        output.set(res);
    }
}

