/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.tamura2d;

import java.util.ArrayList;
import net.imagej.ops.Ops;
import net.imagej.ops.features.tamura2d.AbstractTamuraFeature;
import net.imagej.ops.image.histogram.HistogramCreate;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.gradient.PartialDerivative;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Tamura.Directionality.class, label="Tamura 2D: Directionality")
public class DefaultDirectionalityFeature<I extends RealType<I>, O extends RealType<O>>
extends AbstractTamuraFeature<I, O>
implements Ops.Tamura.Directionality {
    @Parameter(required=true)
    private int histogramSize = 16;
    private UnaryFunctionOp<Iterable, Histogram1d> histOp;
    private UnaryFunctionOp<Iterable, RealType> stdOp;
    private UnaryFunctionOp<RandomAccessibleInterval<I>, Img<I>> imgCreator;

    @Override
    public void initialize() {
        this.stdOp = Functions.unary(this.ops(), Ops.Stats.StdDev.class, RealType.class, Iterable.class, new Object[0]);
        this.histOp = Functions.unary(this.ops(), HistogramCreate.class, Histogram1d.class, Iterable.class, new Object[]{this.histogramSize});
        this.imgCreator = Functions.unary(this.ops(), Ops.Create.Img.class, Img.class, this.in(), Util.getTypeFromInterval((Interval)((Interval)this.in())));
    }

    @Override
    public void compute(RandomAccessibleInterval<I> input, O output) {
        ArrayList<DoubleType> dirList = new ArrayList<DoubleType>();
        long[] dims = new long[input.numDimensions()];
        input.dimensions(dims);
        Img<I> derX = this.imgCreator.calculate(input);
        Img<I> derY = this.imgCreator.calculate(input);
        PartialDerivative.gradientCentralDifference2((RandomAccessible)Views.extendMirrorSingle(input), derX, (int)0);
        PartialDerivative.gradientCentralDifference2((RandomAccessible)Views.extendMirrorSingle(input), derY, (int)1);
        Cursor cX = derX.cursor();
        Cursor cY = derY.cursor();
        while (cX.hasNext()) {
            cX.next();
            cY.next();
            double dx = ((RealType)cX.get()).getRealDouble();
            double dy = ((RealType)cY.get()).getRealDouble();
            double dir = 0.0;
            double mag = 0.0;
            mag = Math.sqrt(dx * dx + dy * dy);
            if (dx == 0.0 || !(mag > 0.0)) continue;
            dir = Math.atan(dy / dx) + 1.5707963267948966;
            dirList.add(new DoubleType(dir));
        }
        if (dirList.isEmpty()) {
            output.setReal(0.0);
        } else {
            Histogram1d hist = this.histOp.calculate(dirList);
            double std = this.stdOp.calculate((Iterable)hist).getRealDouble();
            output.setReal(1.0 / std);
        }
    }
}

