/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.hessian;

import java.util.ArrayList;
import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RAIs;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.Hessian.class)
public class HessianRAI<T extends RealType<T>>
extends AbstractUnaryFunctionOp<RandomAccessibleInterval<T>, CompositeIntervalView<T, RealComposite<T>>>
implements Ops.Filter.Hessian {
    private UnaryComputerOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>>[] derivativeComputers;
    private UnaryFunctionOp<RandomAccessibleInterval<T>, RandomAccessibleInterval<T>> createRAI;

    @Override
    public void initialize() {
        this.createRAI = RAIs.function(this.ops(), Ops.Create.Img.class, (RandomAccessibleInterval)this.in(), new Object[0]);
        this.derivativeComputers = new UnaryComputerOp[((RandomAccessibleInterval)this.in()).numDimensions()];
        for (int i = 0; i < ((RandomAccessibleInterval)this.in()).numDimensions(); ++i) {
            this.derivativeComputers[i] = RAIs.computer(this.ops(), Ops.Filter.PartialDerivative.class, (RandomAccessibleInterval)this.in(), i);
        }
    }

    @Override
    public CompositeIntervalView<T, RealComposite<T>> calculate(RandomAccessibleInterval<T> input) {
        ArrayList<RandomAccessibleInterval<T>> derivatives = new ArrayList<RandomAccessibleInterval<T>>();
        for (int i = 0; i < this.derivativeComputers.length; ++i) {
            RandomAccessibleInterval<T> derivative = this.createRAI.calculate(input);
            this.derivativeComputers[i].compute(input, derivative);
            for (int j = 0; j < this.derivativeComputers.length; ++j) {
                RandomAccessibleInterval<T> out = this.createRAI.calculate(input);
                this.derivativeComputers[j].compute(derivative, out);
                derivatives.add(out);
            }
        }
        RandomAccessibleInterval stackedDerivatives = Views.stack(derivatives);
        return Views.collapseReal((RandomAccessibleInterval)stackedDerivatives);
    }
}

