/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.pad;

import net.imagej.ops.Ops;
import net.imagej.ops.filter.pad.PaddingIntervalCentered;
import net.imagej.ops.filter.pad.PaddingIntervalOrigin;
import net.imagej.ops.special.function.AbstractBinaryFunctionOp;
import net.imagej.ops.special.function.BinaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.PadShiftFFTKernel.class, priority=101.0)
public class PadShiftKernel<T extends ComplexType<T>, I extends RandomAccessibleInterval<T>, O extends RandomAccessibleInterval<T>>
extends AbstractBinaryFunctionOp<I, Dimensions, O>
implements Ops.Filter.PadShiftFFTKernel {
    private BinaryFunctionOp<I, Dimensions, O> paddingIntervalCentered;
    private BinaryFunctionOp<I, Interval, O> paddingIntervalOrigin;
    private UnaryFunctionOp<Dimensions, long[][]> fftSizeOp;

    @Override
    public void initialize() {
        super.initialize();
        this.paddingIntervalCentered = (BinaryFunctionOp)Functions.unary(this.ops(), PaddingIntervalCentered.class, Interval.class, RandomAccessibleInterval.class, new Object[]{Dimensions.class});
        this.paddingIntervalOrigin = (BinaryFunctionOp)Functions.unary(this.ops(), PaddingIntervalOrigin.class, Interval.class, RandomAccessibleInterval.class, new Object[]{Interval.class});
        this.fftSizeOp = null;
    }

    @Override
    public O calculate(I kernel, Dimensions paddedDimensions) {
        Dimensions paddedFFTInputDimensions;
        if (this.fftSizeOp != null) {
            long[][] sizes = this.fftSizeOp.calculate(paddedDimensions);
            paddedFFTInputDimensions = new FinalDimensions(sizes[0]);
        } else {
            paddedFFTInputDimensions = paddedDimensions;
        }
        Interval kernelConvolutionInterval = (Interval)this.paddingIntervalCentered.calculate(kernel, paddedFFTInputDimensions);
        Interval kernelConvolutionIntervalOrigin = (Interval)this.paddingIntervalOrigin.calculate(kernel, kernelConvolutionInterval);
        return (O)Views.interval((RandomAccessible)Views.extendPeriodic((RandomAccessibleInterval)Views.interval((RandomAccessible)Views.extendValue(kernel, (Type)((ComplexType)Util.getTypeFromInterval(kernel)).createVariable()), (Interval)kernelConvolutionInterval)), (Interval)kernelConvolutionIntervalOrigin);
    }

    protected void setFFTSizeOp(UnaryFunctionOp<Dimensions, long[][]> fftSizeOp) {
        this.fftSizeOp = fftSizeOp;
    }
}

