/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.List;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.GeomUtils;
import net.imagej.ops.special.function.AbstractUnaryFunctionOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.util.Pair;
import net.imglib2.util.ValuePair;
import org.apache.commons.math3.geometry.Point;
import org.apache.commons.math3.geometry.euclidean.twod.Line;
import org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.MinimumFeret.class)
public class DefaultMinimumFeret
extends AbstractUnaryFunctionOp<Polygon2D, Pair<RealLocalizable, RealLocalizable>>
implements Ops.Geometric.MinimumFeret {
    private UnaryFunctionOp<Polygon2D, Polygon2D> function;

    @Override
    public void initialize() {
        this.function = Functions.unary(this.ops(), Ops.Geometric.ConvexHull.class, Polygon2D.class, this.in(), new Object[0]);
    }

    @Override
    public Pair<RealLocalizable, RealLocalizable> calculate(Polygon2D input) {
        List<RealLocalizable> points = GeomUtils.vertices(this.function.calculate(input));
        double distance = Double.POSITIVE_INFINITY;
        RealLocalizable p0 = points.get(0);
        RealLocalizable p1 = points.get(0);
        double tmpDist = 0.0;
        RealLocalizable tmpP0 = p0;
        RealLocalizable tmpP1 = p1;
        for (int i = 0; i < points.size() - 2; ++i) {
            RealLocalizable lineStart = points.get(i);
            RealLocalizable lineEnd = points.get(i + 1);
            tmpDist = 0.0;
            Line l = new Line(new Vector2D(lineStart.getDoublePosition(0), lineStart.getDoublePosition(1)), new Vector2D(lineEnd.getDoublePosition(0), lineEnd.getDoublePosition(1)), 1.0E-11);
            for (int j = 0; j < points.size(); ++j) {
                RealLocalizable ttmpP0;
                double tmp;
                if (j == i || j == i + 1 || !((tmp = l.distance(new Vector2D((ttmpP0 = points.get(j)).getDoublePosition(0), ttmpP0.getDoublePosition(1)))) > tmpDist)) continue;
                tmpDist = tmp;
                Vector2D vp = (Vector2D)l.project((Point)new Vector2D(ttmpP0.getDoublePosition(0), ttmpP0.getDoublePosition(1)));
                tmpP0 = new RealPoint(new double[]{vp.getX(), vp.getY()});
                tmpP1 = ttmpP0;
            }
            if (!(tmpDist < distance)) continue;
            distance = tmpDist;
            p0 = tmpP0;
            p1 = tmpP1;
        }
        RealLocalizable lineStart = points.get(points.size() - 1);
        RealLocalizable lineEnd = points.get(0);
        Line l = new Line(new Vector2D(lineStart.getDoublePosition(0), lineStart.getDoublePosition(1)), new Vector2D(lineEnd.getDoublePosition(0), lineEnd.getDoublePosition(1)), 1.0E-11);
        tmpDist = 0.0;
        for (int j = 0; j < points.size(); ++j) {
            RealLocalizable ttmpP0;
            double tmp;
            if (j == points.size() - 1 || j == 1 || !((tmp = l.distance(new Vector2D((ttmpP0 = points.get(j)).getDoublePosition(0), ttmpP0.getDoublePosition(1)))) > tmpDist)) continue;
            tmpDist = tmp;
            Vector2D vp = (Vector2D)l.project((Point)new Vector2D(ttmpP0.getDoublePosition(0), ttmpP0.getDoublePosition(1)));
            tmpP0 = new RealPoint(new double[]{vp.getX(), vp.getY()});
            tmpP1 = ttmpP0;
        }
        if (tmpDist < distance) {
            distance = tmpDist;
            p0 = tmpP0;
            p1 = tmpP1;
        }
        return new ValuePair((Object)p0, (Object)p1);
    }
}

