/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.integral;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCI;
import net.imglib2.Dimensions;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.util.Util;
import net.imglib2.view.Views;

public abstract class AbstractIntegralImg<I extends RealType<I>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<I>, RandomAccessibleInterval<RealType<?>>>
implements Contingent {
    private UnaryComputerOp[] slicewiseOps;
    private UnaryFunctionOp<Dimensions, RandomAccessibleInterval> createLongRAI;
    private UnaryFunctionOp<Dimensions, RandomAccessibleInterval> createDoubleRAI;

    @Override
    public void initialize() {
        if (this.in() != null) {
            this.slicewiseOps = new UnaryComputerOp[((RandomAccessibleInterval)this.in()).numDimensions()];
            for (int i = 0; i < ((RandomAccessibleInterval)this.in()).numDimensions(); ++i) {
                this.slicewiseOps[i] = Computers.unary(this.ops(), Ops.Slice.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[]{this.getComputer(i), i});
            }
        }
        this.createLongRAI = Functions.unary(this.ops(), Ops.Create.Img.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{new LongType()});
        this.createDoubleRAI = Functions.unary(this.ops(), Ops.Create.Img.class, RandomAccessibleInterval.class, Dimensions.class, new Object[]{new DoubleType()});
    }

    @Override
    public void compute(RandomAccessibleInterval<I> input, RandomAccessibleInterval<RealType<?>> output) {
        if (this.slicewiseOps == null) {
            this.slicewiseOps = new UnaryComputerOp[((RandomAccessibleInterval)this.in()).numDimensions()];
            for (int i = 0; i < ((RandomAccessibleInterval)this.in()).numDimensions(); ++i) {
                this.slicewiseOps[i] = Computers.unary(this.ops(), Ops.Slice.class, RandomAccessibleInterval.class, RandomAccessibleInterval.class, new Object[]{this.getComputer(i), i});
            }
        }
        Object generalizedInput = input;
        for (int i = 0; i < input.numDimensions(); ++i) {
            this.slicewiseOps[i].compute(generalizedInput, output);
            generalizedInput = output;
        }
    }

    @Override
    public RandomAccessibleInterval<RealType<?>> createOutput(RandomAccessibleInterval<I> input) {
        if (Util.getTypeFromInterval(input) instanceof IntegerType) {
            return this.createLongRAI.calculate((Dimensions)input);
        }
        return this.createDoubleRAI.calculate((Dimensions)input);
    }

    @Override
    public boolean conforms() {
        return this.in() != null && this.out() != null ? Views.iterable((RandomAccessibleInterval)((RandomAccessibleInterval)this.in())).iterationOrder().equals(Views.iterable((RandomAccessibleInterval)((RandomAccessibleInterval)this.out()))) : true;
    }

    public abstract AbstractUnaryHybridCI<IterableInterval<I>, IterableInterval<I>> getComputer(int var1);
}

