/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.image.invert;

import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedVariableBitLengthType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Image.Invert.class)
public class InvertII<T extends RealType<T>>
extends AbstractUnaryComputerOp<IterableInterval<T>, IterableInterval<T>>
implements Ops.Image.Invert {
    @Parameter(required=false)
    private T min;
    @Parameter(required=false)
    private T max;
    private UnaryComputerOp<IterableInterval<T>, IterableInterval<T>> mapper;

    @Override
    public void compute(IterableInterval<T> input, IterableInterval<T> output) {
        if (this.mapper == null) {
            double minValue = this.min == null ? ((RealType)input.firstElement()).getMinValue() : this.min.getRealDouble();
            double maxValue = this.max == null ? ((RealType)input.firstElement()).getMaxValue() : this.max.getRealDouble();
            final double minMax = maxValue + minValue;
            this.mapper = Computers.unary(this.ops(), Ops.Map.class, output, input, new AbstractUnaryComputerOp<T, T>(){

                @Override
                public void compute(T in, T out) {
                    if (minMax - in.getRealDouble() <= out.getMinValue()) {
                        out.setReal(out.getMinValue());
                    } else if (minMax - in.getRealDouble() >= out.getMaxValue()) {
                        out.setReal(out.getMaxValue());
                    } else {
                        out.setReal(minMax - in.getRealDouble());
                    }
                }
            });
        }
        this.mapper.compute(input, output);
    }

    public static <T extends RealType<T>> T minValue(T type) {
        if (type instanceof UnsignedVariableBitLengthType) {
            return (T)new UnsignedVariableBitLengthType(0L, 1);
        }
        RealType min = (RealType)type.createVariable();
        min.setReal(min.getMinValue());
        return (T)min;
    }
}

