/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.imagemoments.centralmoments;

import net.imagej.ops.Ops;
import net.imagej.ops.imagemoments.AbstractImageMomentOp;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.ImageMoments.CentralMoment02.class, label="Image Moment: CentralMoment02")
public class DefaultCentralMoment02<I extends RealType<I>, O extends RealType<O>>
extends AbstractImageMomentOp<I, O>
implements Ops.ImageMoments.CentralMoment02 {
    private UnaryFunctionOp<IterableInterval<I>, O> moment00Func;
    private UnaryFunctionOp<IterableInterval<I>, O> moment01Func;

    @Override
    public void initialize() {
        this.moment00Func = RTs.function(this.ops(), Ops.ImageMoments.Moment00.class, this.in(), new Object[0]);
        this.moment01Func = RTs.function(this.ops(), Ops.ImageMoments.Moment01.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(IterableInterval<I> input, O output) {
        double moment00 = ((RealType)this.moment00Func.calculate(input)).getRealDouble();
        double moment01 = ((RealType)this.moment01Func.calculate(input)).getRealDouble();
        double centerY = moment01 / moment00;
        double centralmoment02 = 0.0;
        Cursor it = input.localizingCursor();
        while (it.hasNext()) {
            it.fwd();
            double y = it.getDoublePosition(1) - centerY;
            double val = ((RealType)it.get()).getRealDouble();
            centralmoment02 += val * y * y;
        }
        output.setReal(centralmoment02);
    }
}

