/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.labeling.cca;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.labeling.ConnectedComponents;
import net.imglib2.roi.labeling.ImgLabeling;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.thread.ThreadService;

@Plugin(type=Ops.Labeling.CCA.class, priority=1.0)
public class DefaultCCA<T extends IntegerType<T>, L, I extends IntegerType<I>>
extends AbstractUnaryHybridCF<RandomAccessibleInterval<T>, ImgLabeling<L, I>>
implements Contingent,
Ops.Labeling.CCA {
    @Parameter
    private ThreadService threads;
    @Parameter
    private ConnectedComponents.StructuringElement se;
    @Parameter(required=false)
    private Iterator<L> labelGenerator;
    private UnaryFunctionOp<Interval, ImgLabeling<L, I>> imgLabelingCreator;

    @Override
    public void initialize() {
        this.imgLabelingCreator = Functions.unary(this.ops(), Ops.Create.ImgLabeling.class, ImgLabeling.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(RandomAccessibleInterval<T> input, ImgLabeling<L, I> output) {
        if (this.labelGenerator == null) {
            this.labelGenerator = new DefaultLabelIterator();
        }
        ConnectedComponents.labelAllConnectedComponents(input, output, this.labelGenerator, (ConnectedComponents.StructuringElement)this.se, (ExecutorService)this.threads.getExecutorService());
    }

    @Override
    public ImgLabeling<L, I> createOutput(RandomAccessibleInterval<T> input) {
        return this.imgLabelingCreator.calculate((Interval)input);
    }

    @Override
    public boolean conforms() {
        if (this.out() == null) {
            return true;
        }
        return Intervals.equalDimensions((Interval)((Interval)this.in()), (Interval)((Interval)this.out()));
    }

    class DefaultLabelIterator
    implements Iterator<Integer> {
        private Integer i = 0;

        DefaultLabelIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < Integer.MAX_VALUE;
        }

        @Override
        public Integer next() {
            Integer n = this.i;
            Integer n2 = this.i = Integer.valueOf(this.i + 1);
            return n;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

