/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.logic;

import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractBinaryComputerOp;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCFI;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCFI;
import net.imglib2.type.BooleanType;
import org.scijava.plugin.Plugin;

public class BooleanTypeLogic {
    private BooleanTypeLogic() {
    }

    @Plugin(type=Ops.Logic.Xor.class)
    public static class Xor<T extends BooleanType<T>>
    extends AbstractBinaryHybridCFI<T, T>
    implements Ops.Logic.Xor {
        @Override
        public T createOutput(T in1, T in2) {
            return (T)((BooleanType)in1.createVariable());
        }

        @Override
        public void compute(T in1, T in2, T out) {
            out.set(in1);
            out.xor(in2);
        }

        @Override
        public void mutate1(T arg, T in) {
            this.compute(arg, in, arg);
        }

        @Override
        public void mutate2(T in, T arg) {
            this.compute(in, arg, arg);
        }
    }

    @Plugin(type=Ops.Logic.Or.class)
    public static class Or<T extends BooleanType<T>>
    extends AbstractBinaryHybridCFI<T, T>
    implements Ops.Logic.Or {
        @Override
        public T createOutput(T in1, T in2) {
            return (T)((BooleanType)in1.createVariable());
        }

        @Override
        public void compute(T in1, T in2, T out) {
            out.set(in1);
            out.or(in2);
        }

        @Override
        public void mutate1(T arg, T in) {
            this.compute(arg, in, arg);
        }

        @Override
        public void mutate2(T in, T arg) {
            this.compute(in, arg, arg);
        }
    }

    @Plugin(type=Ops.Logic.NotEqual.class)
    public static class ObjectsNotEqual<O extends BooleanType<O>>
    extends AbstractBinaryComputerOp<Object, Object, O>
    implements Ops.Logic.NotEqual {
        @Override
        public void compute(Object in1, Object in2, O out) {
            out.set(!in1.equals(in2));
        }
    }

    @Plugin(type=Ops.Logic.Equal.class)
    public static class ObjectsEqual<O extends BooleanType<O>>
    extends AbstractBinaryComputerOp<Object, Object, O>
    implements Ops.Logic.Equal {
        @Override
        public void compute(Object in1, Object in2, O out) {
            out.set(in1.equals(in2));
        }
    }

    @Plugin(type=Ops.Logic.Not.class)
    public static class Not<T extends BooleanType<T>>
    extends AbstractUnaryHybridCFI<T, T>
    implements Ops.Logic.Not {
        @Override
        public T createOutput(T in) {
            return (T)((BooleanType)in.createVariable());
        }

        @Override
        public void compute(T in, T out) {
            out.set(in);
            out.not();
        }

        @Override
        public void mutate(T arg) {
            arg.not();
        }
    }

    @Plugin(type=Ops.Logic.LessThanOrEqual.class)
    public static class ComparableLessThanOrEqual<I extends Comparable<I>, O extends BooleanType<O>>
    extends AbstractBinaryComputerOp<I, I, O>
    implements Ops.Logic.LessThanOrEqual {
        @Override
        public void compute(I in1, I in2, O out) {
            out.set(in1.compareTo(in2) <= 0);
        }
    }

    @Plugin(type=Ops.Logic.LessThan.class)
    public static class ComparableLessThan<I extends Comparable<I>, O extends BooleanType<O>>
    extends AbstractBinaryComputerOp<I, I, O>
    implements Ops.Logic.LessThan {
        @Override
        public void compute(I in1, I in2, O out) {
            out.set(in1.compareTo(in2) < 0);
        }
    }

    @Plugin(type=Ops.Logic.GreaterThanOrEqual.class)
    public static class ComparableGreaterThanOrEqual<I extends Comparable<I>, O extends BooleanType<O>>
    extends AbstractBinaryComputerOp<I, I, O>
    implements Ops.Logic.GreaterThanOrEqual {
        @Override
        public void compute(I in1, I in2, O out) {
            out.set(in1.compareTo(in2) >= 0);
        }
    }

    @Plugin(type=Ops.Logic.GreaterThan.class)
    public static class ComparableGreaterThan<I extends Comparable<I>, O extends BooleanType<O>>
    extends AbstractBinaryComputerOp<I, I, O>
    implements Ops.Logic.GreaterThan {
        @Override
        public void compute(I in1, I in2, O out) {
            out.set(in1.compareTo(in2) > 0);
        }
    }

    @Plugin(type=Ops.Logic.And.class)
    public static class And<T extends BooleanType<T>>
    extends AbstractBinaryHybridCFI<T, T>
    implements Ops.Logic.And {
        @Override
        public T createOutput(T in1, T in2) {
            return (T)((BooleanType)in1.createVariable());
        }

        @Override
        public void compute(T in1, T in2, T out) {
            out.set(in1);
            out.and(in2);
        }

        @Override
        public void mutate1(T arg, T in) {
            this.compute(arg, in, arg);
        }

        @Override
        public void mutate2(T in, T arg) {
            this.compute(in, arg, arg);
        }
    }
}

