/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.map;

import net.imagej.ops.special.computer.BinaryComputerOp;
import net.imagej.ops.special.computer.NullaryComputerOp;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imagej.ops.special.inplace.BinaryInplace1Op;
import net.imagej.ops.special.inplace.BinaryInplaceOp;
import net.imagej.ops.special.inplace.UnaryInplaceOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.util.Intervals;

public class Maps {
    private Maps() {
    }

    public static <I, O> boolean compatible(IterableInterval<I> a, IterableInterval<O> b) {
        return a.iterationOrder().equals(b.iterationOrder());
    }

    public static <I, O> boolean compatible(IterableInterval<I> a, RandomAccessibleInterval<O> b) {
        return Intervals.contains(b, a);
    }

    public static <I, O> boolean compatible(RandomAccessibleInterval<I> a, IterableInterval<O> b) {
        return Intervals.contains(a, b);
    }

    public static <I1, I2, O> boolean compatible(IterableInterval<I1> a, IterableInterval<I2> b, IterableInterval<O> c) {
        return a.iterationOrder().equals(b.iterationOrder()) && a.iterationOrder().equals(c.iterationOrder());
    }

    public static <I1, I2, O> boolean compatible(IterableInterval<I1> a, IterableInterval<I2> b, RandomAccessibleInterval<O> c) {
        return a.iterationOrder().equals(b.iterationOrder()) && Intervals.contains(c, a);
    }

    public static <I1, I2, O> boolean compatible(IterableInterval<I1> a, RandomAccessibleInterval<I2> b, IterableInterval<O> c) {
        return a.iterationOrder().equals(c.iterationOrder()) && Intervals.contains(b, a);
    }

    public static <I1, I2, O> boolean compatible(RandomAccessibleInterval<I1> a, IterableInterval<I2> b, IterableInterval<O> c) {
        return b.iterationOrder().equals(c.iterationOrder()) && Intervals.contains(a, b);
    }

    public static <I1, I2, O> boolean compatible(IterableInterval<I1> a, RandomAccessibleInterval<I2> b, RandomAccessibleInterval<O> c) {
        return Intervals.contains(b, a) && Intervals.contains(c, a);
    }

    public static <I1, I2, O> boolean compatible(RandomAccessibleInterval<I1> a, IterableInterval<I2> b, RandomAccessibleInterval<O> c) {
        return Intervals.contains(a, b) && Intervals.contains(c, b);
    }

    public static <I1, I2, O> boolean compatible(RandomAccessibleInterval<I1> a, RandomAccessibleInterval<I2> b, IterableInterval<O> c) {
        return Intervals.contains(a, c) && Intervals.contains(b, c);
    }

    public static <O> void map(Iterable<O> a, NullaryComputerOp<O> op) {
        for (O e : a) {
            op.compute(e);
        }
    }

    public static <O> void map(IterableInterval<O> a, NullaryComputerOp<O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor aCursor = a.cursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            aCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            op.compute(aCursor.get());
        }
    }

    public static <I, O> void map(IterableInterval<I> a, IterableInterval<O> b, UnaryComputerOp<I, O> op) {
        Cursor aCursor = a.cursor();
        Cursor bCursor = b.cursor();
        while (aCursor.hasNext()) {
            op.compute(aCursor.next(), bCursor.next());
        }
    }

    public static <I, O> void map(IterableInterval<I> a, RandomAccessibleInterval<O> b, UnaryComputerOp<I, O> op) {
        Cursor aCursor = a.localizingCursor();
        RandomAccess bAccess = b.randomAccess();
        while (aCursor.hasNext()) {
            aCursor.fwd();
            bAccess.setPosition((Localizable)aCursor);
            op.compute(aCursor.get(), bAccess.get());
        }
    }

    public static <I, O> void map(RandomAccessibleInterval<I> a, IterableInterval<O> b, UnaryComputerOp<I, O> op) {
        RandomAccess aAccess = a.randomAccess();
        Cursor bCursor = b.localizingCursor();
        while (bCursor.hasNext()) {
            bCursor.fwd();
            aAccess.setPosition((Localizable)bCursor);
            op.compute(aAccess.get(), bCursor.get());
        }
    }

    public static <I1, I2, O> void map(IterableInterval<I1> a, IterableInterval<I2> b, IterableInterval<O> c, BinaryComputerOp<I1, I2, O> op) {
        Cursor aCursor = a.cursor();
        Cursor bCursor = b.cursor();
        Cursor cCursor = c.cursor();
        while (aCursor.hasNext()) {
            op.compute(aCursor.next(), bCursor.next(), cCursor.next());
        }
    }

    public static <I1, I2, O> void map(IterableInterval<I1> a, IterableInterval<I2> b, RandomAccessibleInterval<O> c, BinaryComputerOp<I1, I2, O> op) {
        Cursor aCursor = a.localizingCursor();
        Cursor bCursor = b.cursor();
        RandomAccess cAccess = c.randomAccess();
        while (aCursor.hasNext()) {
            aCursor.fwd();
            cAccess.setPosition((Localizable)aCursor);
            op.compute(aCursor.get(), bCursor.next(), cAccess.get());
        }
    }

    public static <I1, I2, O> void map(IterableInterval<I1> a, RandomAccessibleInterval<I2> b, IterableInterval<O> c, BinaryComputerOp<I1, I2, O> op) {
        Cursor aCursor = a.localizingCursor();
        RandomAccess bAccess = b.randomAccess();
        Cursor cCursor = c.cursor();
        while (aCursor.hasNext()) {
            aCursor.fwd();
            bAccess.setPosition((Localizable)aCursor);
            op.compute(aCursor.get(), bAccess.get(), cCursor.next());
        }
    }

    public static <I1, I2, O> void map(RandomAccessibleInterval<I1> a, IterableInterval<I2> b, IterableInterval<O> c, BinaryComputerOp<I1, I2, O> op) {
        RandomAccess aAccess = a.randomAccess();
        Cursor bCursor = b.localizingCursor();
        Cursor cCursor = c.cursor();
        while (bCursor.hasNext()) {
            bCursor.fwd();
            aAccess.setPosition((Localizable)bCursor);
            op.compute(aAccess.get(), bCursor.get(), cCursor.next());
        }
    }

    public static <I1, I2, O> void map(IterableInterval<I1> a, RandomAccessibleInterval<I2> b, RandomAccessibleInterval<O> c, BinaryComputerOp<I1, I2, O> op) {
        Cursor aCursor = a.localizingCursor();
        RandomAccess bAccess = b.randomAccess();
        RandomAccess cAccess = c.randomAccess();
        while (aCursor.hasNext()) {
            aCursor.fwd();
            bAccess.setPosition((Localizable)aCursor);
            cAccess.setPosition((Localizable)aCursor);
            op.compute(aCursor.get(), bAccess.get(), cAccess.get());
        }
    }

    public static <I1, I2, O> void map(RandomAccessibleInterval<I1> a, IterableInterval<I2> b, RandomAccessibleInterval<O> c, BinaryComputerOp<I1, I2, O> op) {
        RandomAccess aAccess = a.randomAccess();
        Cursor bCursor = b.localizingCursor();
        RandomAccess cAccess = c.randomAccess();
        while (bCursor.hasNext()) {
            bCursor.fwd();
            aAccess.setPosition((Localizable)bCursor);
            cAccess.setPosition((Localizable)bCursor);
            op.compute(aAccess.get(), bCursor.get(), cAccess.get());
        }
    }

    public static <I1, I2, O> void map(RandomAccessibleInterval<I1> a, RandomAccessibleInterval<I2> b, IterableInterval<O> c, BinaryComputerOp<I1, I2, O> op) {
        RandomAccess aAccess = a.randomAccess();
        RandomAccess bAccess = b.randomAccess();
        Cursor cCursor = c.localizingCursor();
        while (cCursor.hasNext()) {
            cCursor.fwd();
            aAccess.setPosition((Localizable)cCursor);
            bAccess.setPosition((Localizable)cCursor);
            op.compute(aAccess.get(), bAccess.get(), cCursor.get());
        }
    }

    public static <I, O> void map(IterableInterval<I> a, IterableInterval<O> b, UnaryComputerOp<I, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor aCursor = a.cursor();
        Cursor bCursor = b.cursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            long m = ctr == 0L ? startIndex + 1L : stepSize;
            aCursor.jumpFwd(m);
            bCursor.jumpFwd(m);
            op.compute(aCursor.get(), bCursor.get());
        }
    }

    public static <I, O> void map(IterableInterval<I> a, RandomAccessibleInterval<O> b, UnaryComputerOp<I, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor aCursor = a.localizingCursor();
        RandomAccess bAccess = b.randomAccess();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            aCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            bAccess.setPosition((Localizable)aCursor);
            op.compute(aCursor.get(), bAccess.get());
        }
    }

    public static <I, O> void map(RandomAccessibleInterval<I> a, IterableInterval<O> b, UnaryComputerOp<I, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        RandomAccess aAccess = a.randomAccess();
        Cursor bCursor = b.localizingCursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            bCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            aAccess.setPosition((Localizable)bCursor);
            op.compute(aAccess.get(), bCursor.get());
        }
    }

    public static <I1, I2, O> void map(IterableInterval<I1> a, IterableInterval<I2> b, IterableInterval<O> c, BinaryComputerOp<I1, I2, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor aCursor = a.cursor();
        Cursor bCursor = b.cursor();
        Cursor cCursor = c.cursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            long m = ctr == 0L ? startIndex + 1L : stepSize;
            aCursor.jumpFwd(m);
            bCursor.jumpFwd(m);
            cCursor.jumpFwd(m);
            op.compute(aCursor.get(), bCursor.get(), cCursor.get());
        }
    }

    public static <I1, I2, O> void map(IterableInterval<I1> a, IterableInterval<I2> b, RandomAccessibleInterval<O> c, BinaryComputerOp<I1, I2, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor aCursor = a.localizingCursor();
        Cursor bCursor = b.cursor();
        RandomAccess cAccess = c.randomAccess();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            long m = ctr == 0L ? startIndex + 1L : stepSize;
            aCursor.jumpFwd(m);
            bCursor.jumpFwd(m);
            cAccess.setPosition((Localizable)aCursor);
            op.compute(aCursor.get(), bCursor.get(), cAccess.get());
        }
    }

    public static <I1, I2, O> void map(IterableInterval<I1> a, RandomAccessibleInterval<I2> b, IterableInterval<O> c, BinaryComputerOp<I1, I2, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor aCursor = a.localizingCursor();
        RandomAccess bAccess = b.randomAccess();
        Cursor cCursor = c.cursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            long m = ctr == 0L ? startIndex + 1L : stepSize;
            aCursor.jumpFwd(m);
            cCursor.jumpFwd(m);
            bAccess.setPosition((Localizable)aCursor);
            op.compute(aCursor.get(), bAccess.get(), cCursor.get());
        }
    }

    public static <I1, I2, O> void map(RandomAccessibleInterval<I1> a, IterableInterval<I2> b, IterableInterval<O> c, BinaryComputerOp<I1, I2, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        RandomAccess aAccess = a.randomAccess();
        Cursor bCursor = b.localizingCursor();
        Cursor cCursor = c.cursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            long m = ctr == 0L ? startIndex + 1L : stepSize;
            bCursor.jumpFwd(m);
            cCursor.jumpFwd(m);
            aAccess.setPosition((Localizable)bCursor);
            op.compute(aAccess.get(), bCursor.get(), cCursor.get());
        }
    }

    public static <I1, I2, O> void map(IterableInterval<I1> a, RandomAccessibleInterval<I2> b, RandomAccessibleInterval<O> c, BinaryComputerOp<I1, I2, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor aCursor = a.localizingCursor();
        RandomAccess bAccess = b.randomAccess();
        RandomAccess cAccess = c.randomAccess();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            aCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            bAccess.setPosition((Localizable)aCursor);
            cAccess.setPosition((Localizable)aCursor);
            op.compute(aCursor.get(), bAccess.get(), cAccess.get());
        }
    }

    public static <I1, I2, O> void map(RandomAccessibleInterval<I1> a, IterableInterval<I2> b, RandomAccessibleInterval<O> c, BinaryComputerOp<I1, I2, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        RandomAccess aAccess = a.randomAccess();
        Cursor bCursor = b.localizingCursor();
        RandomAccess cAccess = c.randomAccess();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            bCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            aAccess.setPosition((Localizable)bCursor);
            cAccess.setPosition((Localizable)bCursor);
            op.compute(aAccess.get(), bCursor.get(), cAccess.get());
        }
    }

    public static <I1, I2, O> void map(RandomAccessibleInterval<I1> a, RandomAccessibleInterval<I2> b, IterableInterval<O> c, BinaryComputerOp<I1, I2, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        RandomAccess aAccess = a.randomAccess();
        RandomAccess bAccess = b.randomAccess();
        Cursor cCursor = c.localizingCursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            cCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            aAccess.setPosition((Localizable)cCursor);
            bAccess.setPosition((Localizable)cCursor);
            op.compute(aAccess.get(), bAccess.get(), cCursor.get());
        }
    }

    public static <I, O extends I> void inplace(Iterable<O> arg, UnaryInplaceOp<I, O> op) {
        for (O e : arg) {
            op.mutate(e);
        }
    }

    public static <I, O extends I> void inplace(IterableInterval<O> arg, UnaryInplaceOp<I, O> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor argCursor = arg.cursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            argCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            op.mutate(argCursor.get());
        }
    }

    public static <I1, I2, O extends I1> void inplace(IterableInterval<O> arg, IterableInterval<I2> in, BinaryInplace1Op<I1, I2, O> op) {
        Cursor argCursor = arg.cursor();
        Cursor inCursor = in.cursor();
        while (argCursor.hasNext()) {
            op.mutate1(argCursor.next(), inCursor.next());
        }
    }

    public static <I1, I2, O extends I1> void inplace(IterableInterval<O> arg, RandomAccessibleInterval<I2> in, BinaryInplace1Op<I1, I2, O> op) {
        Cursor argCursor = arg.localizingCursor();
        RandomAccess inAccess = in.randomAccess();
        while (argCursor.hasNext()) {
            argCursor.fwd();
            inAccess.setPosition((Localizable)argCursor);
            op.mutate1(argCursor.get(), inAccess.get());
        }
    }

    public static <A, I> void inplace(RandomAccessibleInterval<A> arg, IterableInterval<I> in, BinaryInplace1Op<A, I, A> op) {
        RandomAccess argAccess = arg.randomAccess();
        Cursor inCursor = in.localizingCursor();
        while (inCursor.hasNext()) {
            inCursor.fwd();
            argAccess.setPosition((Localizable)inCursor);
            op.mutate1(argAccess.get(), inCursor.get());
        }
    }

    public static <A, I> void inplace(IterableInterval<A> arg, IterableInterval<I> in, BinaryInplace1Op<A, I, A> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor argCursor = arg.cursor();
        Cursor inCursor = in.cursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            long m = ctr == 0L ? startIndex + 1L : stepSize;
            argCursor.jumpFwd(m);
            inCursor.jumpFwd(m);
            op.mutate1(argCursor.get(), inCursor.get());
        }
    }

    public static <A, I> void inplace(IterableInterval<A> arg, RandomAccessibleInterval<I> in, BinaryInplace1Op<A, I, A> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor argCursor = arg.localizingCursor();
        RandomAccess inAccess = in.randomAccess();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            argCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            inAccess.setPosition((Localizable)argCursor);
            op.mutate1(argCursor.get(), inAccess.get());
        }
    }

    public static <A, I> void inplace(RandomAccessibleInterval<A> arg, IterableInterval<I> in, BinaryInplace1Op<A, I, A> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        RandomAccess argAccess = arg.randomAccess();
        Cursor inCursor = in.localizingCursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            inCursor.jumpFwd(ctr == 0L ? startIndex + 1L : stepSize);
            argAccess.setPosition((Localizable)inCursor);
            op.mutate1(argAccess.get(), inCursor.get());
        }
    }

    public static <A> void inplace(IterableInterval<A> arg, IterableInterval<A> in, BinaryInplaceOp<A, A> op) {
        Cursor argCursor = arg.cursor();
        Cursor inCursor = in.cursor();
        while (argCursor.hasNext()) {
            op.mutate2(argCursor.next(), inCursor.next());
        }
    }

    public static <A> void inplace(IterableInterval<A> arg, IterableInterval<A> in, BinaryInplaceOp<A, A> op, long startIndex, long stepSize, long numSteps) {
        if (numSteps <= 0L) {
            return;
        }
        Cursor argCursor = arg.cursor();
        Cursor inCursor = in.cursor();
        for (long ctr = 0L; ctr < numSteps; ++ctr) {
            long m = ctr == 0L ? startIndex + 1L : stepSize;
            argCursor.jumpFwd(m);
            inCursor.jumpFwd(m);
            op.mutate2(argCursor.get(), inCursor.get());
        }
    }
}

