/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public final class ConstantToIIOutputRAI {
    private ConstantToIIOutputRAI() {
    }

    @Plugin(type=Ops.Math.Divide.class, priority=-10000.0)
    public static class Divide<T extends NumericType<T>>
    extends AbstractUnaryComputerOp<IterableInterval<T>, RandomAccessibleInterval<T>>
    implements Ops.Math.Divide {
        @Parameter
        private T value;

        @Override
        public void compute(IterableInterval<T> input, RandomAccessibleInterval<T> output) {
            Cursor c = input.localizingCursor();
            RandomAccess ra = output.randomAccess();
            while (c.hasNext()) {
                NumericType in = (NumericType)c.next();
                ra.setPosition((Localizable)c);
                NumericType out = (NumericType)ra.get();
                out.set((Type)in);
                out.div(this.value);
            }
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=-10000.0)
    public static class Multiply<T extends NumericType<T>>
    extends AbstractUnaryComputerOp<IterableInterval<T>, RandomAccessibleInterval<T>>
    implements Ops.Math.Multiply {
        @Parameter
        private T value;

        @Override
        public void compute(IterableInterval<T> input, RandomAccessibleInterval<T> output) {
            Cursor c = input.localizingCursor();
            RandomAccess ra = output.randomAccess();
            while (c.hasNext()) {
                NumericType in = (NumericType)c.next();
                ra.setPosition((Localizable)c);
                NumericType out = (NumericType)ra.get();
                out.set((Type)in);
                out.mul(this.value);
            }
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=-10000.0)
    public static class Subtract<T extends NumericType<T>>
    extends AbstractUnaryComputerOp<IterableInterval<T>, RandomAccessibleInterval<T>>
    implements Ops.Math.Subtract {
        @Parameter
        private T value;

        @Override
        public void compute(IterableInterval<T> input, RandomAccessibleInterval<T> output) {
            Cursor c = input.localizingCursor();
            RandomAccess ra = output.randomAccess();
            while (c.hasNext()) {
                NumericType in = (NumericType)c.next();
                ra.setPosition((Localizable)c);
                NumericType out = (NumericType)ra.get();
                out.set((Type)in);
                out.sub(this.value);
            }
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=-10000.0)
    public static class Add<T extends NumericType<T>>
    extends AbstractUnaryComputerOp<IterableInterval<T>, RandomAccessibleInterval<T>>
    implements Ops.Math.Add {
        @Parameter
        private T value;

        @Override
        public void compute(IterableInterval<T> input, RandomAccessibleInterval<T> output) {
            Cursor c = input.localizingCursor();
            RandomAccess ra = output.randomAccess();
            while (c.hasNext()) {
                NumericType in = (NumericType)c.next();
                ra.setPosition((Localizable)c);
                NumericType out = (NumericType)ra.get();
                out.set((Type)in);
                out.add(this.value);
            }
        }
    }
}

