/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractBinaryHybridCFI1;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Intervals;
import org.scijava.plugin.Plugin;

public final class IIToRAIOutputII {
    private IIToRAIOutputII() {
    }

    @Plugin(type=Ops.Math.Divide.class)
    public static class Divide<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI1<IterableInterval<T>, RandomAccessibleInterval<T>, IterableInterval<T>>
    implements Ops.Math.Divide,
    Contingent {
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in1(), ((NumericType)((IterableInterval)this.in1()).firstElement()).createVariable());
        }

        @Override
        public boolean conforms() {
            if (!Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.in2()))) {
                return false;
            }
            if (this.out() == null) {
                return true;
            }
            return Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.out())) && ((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input1, RandomAccessibleInterval<T> input2) {
            return this.outputCreator.calculate(input1);
        }

        @Override
        public void compute(IterableInterval<T> input1, RandomAccessibleInterval<T> input2, IterableInterval<T> output) {
            Cursor in1Cursor = input1.localizingCursor();
            RandomAccess in2Access = input2.randomAccess();
            Cursor outCursor = output.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)in1Cursor.next());
                in2Access.setPosition((Localizable)in1Cursor);
                ((NumericType)outCursor.get()).div(in2Access.get());
            }
        }

        @Override
        public void mutate1(IterableInterval<T> arg, RandomAccessibleInterval<T> in) {
            Cursor in1Cursor = arg.localizingCursor();
            RandomAccess in2Access = in.randomAccess();
            while (in1Cursor.hasNext()) {
                in1Cursor.fwd();
                in2Access.setPosition((Localizable)in1Cursor);
                ((NumericType)in1Cursor.get()).div(in2Access.get());
            }
        }

        @Override
        public Divide<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class)
    public static class Multiply<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI1<IterableInterval<T>, RandomAccessibleInterval<T>, IterableInterval<T>>
    implements Ops.Math.Multiply,
    Contingent {
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in1(), ((NumericType)((IterableInterval)this.in1()).firstElement()).createVariable());
        }

        @Override
        public boolean conforms() {
            if (!Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.in2()))) {
                return false;
            }
            if (this.out() == null) {
                return true;
            }
            return Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.out())) && ((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input1, RandomAccessibleInterval<T> input2) {
            return this.outputCreator.calculate(input1);
        }

        @Override
        public void compute(IterableInterval<T> input1, RandomAccessibleInterval<T> input2, IterableInterval<T> output) {
            Cursor in1Cursor = input1.localizingCursor();
            RandomAccess in2Access = input2.randomAccess();
            Cursor outCursor = output.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)in1Cursor.next());
                in2Access.setPosition((Localizable)in1Cursor);
                ((NumericType)outCursor.get()).mul(in2Access.get());
            }
        }

        @Override
        public void mutate1(IterableInterval<T> arg, RandomAccessibleInterval<T> in) {
            Cursor in1Cursor = arg.localizingCursor();
            RandomAccess in2Access = in.randomAccess();
            while (in1Cursor.hasNext()) {
                in1Cursor.fwd();
                in2Access.setPosition((Localizable)in1Cursor);
                ((NumericType)in1Cursor.get()).mul(in2Access.get());
            }
        }

        @Override
        public Multiply<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class)
    public static class Subtract<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI1<IterableInterval<T>, RandomAccessibleInterval<T>, IterableInterval<T>>
    implements Ops.Math.Subtract,
    Contingent {
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in1(), ((NumericType)((IterableInterval)this.in1()).firstElement()).createVariable());
        }

        @Override
        public boolean conforms() {
            if (!Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.in2()))) {
                return false;
            }
            if (this.out() == null) {
                return true;
            }
            return Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.out())) && ((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input1, RandomAccessibleInterval<T> input2) {
            return this.outputCreator.calculate(input1);
        }

        @Override
        public void compute(IterableInterval<T> input1, RandomAccessibleInterval<T> input2, IterableInterval<T> output) {
            Cursor in1Cursor = input1.localizingCursor();
            RandomAccess in2Access = input2.randomAccess();
            Cursor outCursor = output.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)in1Cursor.next());
                in2Access.setPosition((Localizable)in1Cursor);
                ((NumericType)outCursor.get()).sub(in2Access.get());
            }
        }

        @Override
        public void mutate1(IterableInterval<T> arg, RandomAccessibleInterval<T> in) {
            Cursor in1Cursor = arg.localizingCursor();
            RandomAccess in2Access = in.randomAccess();
            while (in1Cursor.hasNext()) {
                in1Cursor.fwd();
                in2Access.setPosition((Localizable)in1Cursor);
                ((NumericType)in1Cursor.get()).sub(in2Access.get());
            }
        }

        @Override
        public Subtract<T> getIndependentInstance() {
            return this;
        }
    }

    @Plugin(type=Ops.Math.Add.class)
    public static class Add<T extends NumericType<T>>
    extends AbstractBinaryHybridCFI1<IterableInterval<T>, RandomAccessibleInterval<T>, IterableInterval<T>>
    implements Ops.Math.Add,
    Contingent {
        private UnaryFunctionOp<IterableInterval<T>, IterableInterval<T>> outputCreator;

        @Override
        public void initialize() {
            this.outputCreator = Functions.unary(this.ops(), Ops.Create.Img.class, IterableInterval.class, this.in1(), ((NumericType)((IterableInterval)this.in1()).firstElement()).createVariable());
        }

        @Override
        public boolean conforms() {
            if (!Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.in2()))) {
                return false;
            }
            if (this.out() == null) {
                return true;
            }
            return Intervals.equalDimensions((Interval)((Interval)this.in1()), (Interval)((Interval)this.out())) && ((IterableInterval)this.in1()).iterationOrder().equals(((IterableInterval)this.out()).iterationOrder());
        }

        @Override
        public IterableInterval<T> createOutput(IterableInterval<T> input1, RandomAccessibleInterval<T> input2) {
            return this.outputCreator.calculate(input1);
        }

        @Override
        public void compute(IterableInterval<T> input1, RandomAccessibleInterval<T> input2, IterableInterval<T> output) {
            Cursor in1Cursor = input1.localizingCursor();
            RandomAccess in2Access = input2.randomAccess();
            Cursor outCursor = output.cursor();
            while (in1Cursor.hasNext()) {
                ((NumericType)outCursor.next()).set((Type)in1Cursor.next());
                in2Access.setPosition((Localizable)in1Cursor);
                ((NumericType)outCursor.get()).add(in2Access.get());
            }
        }

        @Override
        public void mutate1(IterableInterval<T> arg, RandomAccessibleInterval<T> in) {
            Cursor in1Cursor = arg.localizingCursor();
            RandomAccess in2Access = in.randomAccess();
            while (in1Cursor.hasNext()) {
                in1Cursor.fwd();
                in2Access.setPosition((Localizable)in1Cursor);
                ((NumericType)in1Cursor.get()).add(in2Access.get());
            }
        }

        @Override
        public Add<T> getIndependentInstance() {
            return this;
        }
    }
}

