/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.AbstractNamespace;
import net.imagej.ops.Namespace;
import net.imagej.ops.OpMethod;
import net.imagej.ops.Ops;
import net.imagej.ops.math.BinaryRealTypeMath;
import net.imagej.ops.math.ConstantToArrayImage;
import net.imagej.ops.math.ConstantToArrayImageP;
import net.imagej.ops.math.ConstantToIIOutputII;
import net.imagej.ops.math.ConstantToIIOutputRAI;
import net.imagej.ops.math.ConstantToPlanarImage;
import net.imagej.ops.math.IIToIIOutputII;
import net.imagej.ops.math.IIToRAIOutputII;
import net.imagej.ops.math.NullaryNumericTypeMath;
import net.imagej.ops.math.NumericTypeBinaryMath;
import net.imagej.ops.math.PrimitiveMath;
import net.imagej.ops.math.UnaryRealTypeMath;
import net.imagej.ops.math.multiply.ComplexConjugateMultiplyMap;
import net.imagej.ops.math.multiply.ComplexConjugateMultiplyOp;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.basictypeaccess.array.ByteArray;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.img.basictypeaccess.array.ShortArray;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ComplexType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import org.scijava.plugin.Plugin;

@Plugin(type=Namespace.class)
public class MathNamespace
extends AbstractNamespace {
    @OpMethod(op=PrimitiveMath.DoubleAbs.class)
    public double abs(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleAbs.class, a);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatAbs.class)
    public float abs(float a) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatAbs.class, Float.valueOf(a))).floatValue();
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerAbs.class)
    public int abs(int a) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerAbs.class, a);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongAbs.class)
    public long abs(long a) {
        long result = (Long)this.ops().run(PrimitiveMath.LongAbs.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Abs.class)
    public <I extends RealType<I>, O extends RealType<O>> O abs(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Abs.class, out, in);
        return (O)result;
    }

    @OpMethod(ops={ConstantToArrayImageP.MultiplyByte.class, ConstantToArrayImage.MultiplyByte.class, ConstantToArrayImageP.MultiplyUnsignedByte.class, ConstantToArrayImage.MultiplyUnsignedByte.class})
    public <B extends GenericByteType<B>> ArrayImg<B, ByteArray> multiply(ArrayImg<B, ByteArray> image, byte value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.multiply", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.MultiplyDouble.class, ConstantToArrayImage.MultiplyDouble.class})
    public ArrayImg<DoubleType, DoubleArray> multiply(ArrayImg<DoubleType, DoubleArray> image, double value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.multiply", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.MultiplyFloat.class, ConstantToArrayImage.MultiplyFloat.class})
    public ArrayImg<FloatType, FloatArray> multiply(ArrayImg<FloatType, FloatArray> image, float value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.multiply", image, Float.valueOf(value));
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.MultiplyInt.class, ConstantToArrayImage.MultiplyInt.class, ConstantToArrayImageP.MultiplyUnsignedInt.class, ConstantToArrayImage.MultiplyUnsignedInt.class})
    public <I extends GenericIntType<I>> ArrayImg<I, IntArray> multiply(ArrayImg<I, IntArray> image, int value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.multiply", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.MultiplyLong.class, ConstantToArrayImage.MultiplyLong.class, ConstantToArrayImageP.MultiplyUnsignedLong.class, ConstantToArrayImage.MultiplyUnsignedLong.class})
    public <N extends NativeType<N>> ArrayImg<N, LongArray> multiply(ArrayImg<N, LongArray> image, long value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.multiply", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.MultiplyShort.class, ConstantToArrayImage.MultiplyShort.class, ConstantToArrayImageP.MultiplyUnsignedShort.class, ConstantToArrayImage.MultiplyUnsignedShort.class})
    public <S extends GenericShortType<S>> ArrayImg<S, ShortArray> multiply(ArrayImg<S, ShortArray> image, short value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.multiply", image, value);
        return result;
    }

    @OpMethod(op=PrimitiveMath.DoubleAdd.class)
    public double add(double a, double b) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleAdd.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatAdd.class)
    public float add(float a, float b) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatAdd.class, Float.valueOf(a), Float.valueOf(b))).floatValue();
        return result;
    }

    @OpMethod(op=IIToIIOutputII.Add.class)
    public <T extends NumericType<T>> IterableInterval<T> add(IterableInterval<T> out, IterableInterval<T> in1, IterableInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Add.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=IIToIIOutputII.Add.class)
    public <T extends NumericType<T>> IterableInterval<T> add(IterableInterval<T> in1, IterableInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Add.class, in1, in2);
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerAdd.class)
    public int add(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerAdd.class, a, b);
        return result;
    }

    @OpMethod(op=IIToRAIOutputII.Add.class)
    public <T extends NumericType<T>> IterableInterval<T> add(IterableInterval<T> in1, RandomAccessibleInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Add.class, in1, in2);
        return result;
    }

    @OpMethod(op=IIToRAIOutputII.Add.class)
    public <T extends NumericType<T>> IterableInterval<T> add(IterableInterval<T> out, IterableInterval<T> in1, RandomAccessibleInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Add.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputII.Add.class)
    public <T extends NumericType<T>> IterableInterval<T> add(IterableInterval<T> in, T value) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Add.class, in, value);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputII.Add.class)
    public <T extends NumericType<T>> IterableInterval<T> add(IterableInterval<T> out, IterableInterval<T> in, T value) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Add.class, out, in, value);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongAdd.class)
    public long add(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongAdd.class, a, b);
        return result;
    }

    @OpMethod(op=BinaryRealTypeMath.Add.class)
    public <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> O add(O out, I1 in1, I2 in2) {
        RealType result = (RealType)this.ops().run(Ops.Math.Add.class, out, in1, in2);
        return (O)result;
    }

    @OpMethod(ops={ConstantToPlanarImage.AddByte.class, ConstantToPlanarImage.AddUnsignedByte.class})
    public <B extends GenericByteType<B>> PlanarImg<B, ByteArray> add(PlanarImg<B, ByteArray> image, byte value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.add", image, value);
        return result;
    }

    @OpMethod(op=ConstantToPlanarImage.AddDouble.class)
    public PlanarImg<DoubleType, DoubleArray> add(PlanarImg<DoubleType, DoubleArray> image, double value) {
        PlanarImg result = (PlanarImg)this.ops().run(Ops.Math.Add.class, image, value);
        return result;
    }

    @OpMethod(op=ConstantToPlanarImage.AddFloat.class)
    public PlanarImg<FloatType, FloatArray> add(PlanarImg<FloatType, FloatArray> image, float value) {
        PlanarImg result = (PlanarImg)this.ops().run(Ops.Math.Add.class, image, Float.valueOf(value));
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.AddInt.class, ConstantToPlanarImage.AddUnsignedInt.class})
    public <I extends GenericIntType<I>> PlanarImg<I, IntArray> add(PlanarImg<I, IntArray> image, int value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.add", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.AddLong.class, ConstantToPlanarImage.AddUnsignedLong.class})
    public <N extends NativeType<N>> PlanarImg<N, LongArray> add(PlanarImg<N, LongArray> image, long value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.add", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.AddShort.class, ConstantToPlanarImage.AddUnsignedShort.class})
    public <S extends GenericShortType<S>> PlanarImg<S, ShortArray> add(PlanarImg<S, ShortArray> arg, short value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.add", arg, value);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputRAI.Add.class)
    public <T extends NumericType<T>> RandomAccessibleInterval<T> add(RandomAccessibleInterval<T> out, IterableInterval<T> in, T value) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.ops().run(Ops.Math.Add.class, out, in, value);
        return result;
    }

    @OpMethod(op=NumericTypeBinaryMath.Add.class)
    public <T extends NumericType<T>> T add(T in, T b) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Add.class, in, b);
        return (T)result;
    }

    @OpMethod(op=NumericTypeBinaryMath.Add.class)
    public <T extends NumericType<T>> T add(T out, T in1, T in2) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Add.class, out, in1, in2);
        return (T)result;
    }

    @OpMethod(op=PrimitiveMath.IntegerAnd.class)
    public int and(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerAnd.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongAnd.class)
    public long and(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongAnd.class, a, b);
        return result;
    }

    @OpMethod(op=BinaryRealTypeMath.And.class)
    public <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> O and(O out, I1 in1, I2 in2) {
        RealType result = (RealType)this.ops().run(Ops.Math.And.class, out, in1, in2);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleArccos.class)
    public double arccos(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleArccos.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arccos.class)
    public <I extends RealType<I>, O extends RealType<O>> O arccos(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arccos.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arccosh.class)
    public <I extends RealType<I>, O extends RealType<O>> O arccosh(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arccosh.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arccot.class)
    public <I extends RealType<I>, O extends RealType<O>> O arccot(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arccot.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arccoth.class)
    public <I extends RealType<I>, O extends RealType<O>> O arccoth(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arccoth.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arccsc.class)
    public <I extends RealType<I>, O extends RealType<O>> O arccsc(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arccsc.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arccsch.class)
    public <I extends RealType<I>, O extends RealType<O>> O arccsch(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arccsch.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arcsec.class)
    public <I extends RealType<I>, O extends RealType<O>> O arcsec(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arcsec.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arcsech.class)
    public <I extends RealType<I>, O extends RealType<O>> O arcsech(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arcsech.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleArcsin.class)
    public double arcsin(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleArcsin.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arcsin.class)
    public <I extends RealType<I>, O extends RealType<O>> O arcsin(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arcsin.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arcsinh.class)
    public <I extends RealType<I>, O extends RealType<O>> O arcsinh(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arcsinh.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleArctan.class)
    public double arctan(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleArctan.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arctan.class)
    public <I extends RealType<I>, O extends RealType<O>> O arctan(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arctan.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Arctanh.class)
    public <I extends RealType<I>, O extends RealType<O>> O arctanh(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Arctanh.class, out, in);
        return (O)result;
    }

    @OpMethod(op=NullaryNumericTypeMath.Assign.class)
    public <T extends Type<T>> T assign(T out, T constant) {
        Type result = (Type)this.ops().run(NullaryNumericTypeMath.Assign.class, out, constant);
        return (T)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleCeil.class)
    public double ceil(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleCeil.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Ceil.class)
    public <I extends RealType<I>, O extends RealType<O>> O ceil(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Ceil.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.IntegerComplement.class)
    public int complement(int a) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerComplement.class, a);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongComplement.class)
    public long complement(long a) {
        long result = (Long)this.ops().run(PrimitiveMath.LongComplement.class, a);
        return result;
    }

    @OpMethod(op=PrimitiveMath.DoubleCos.class)
    public double cos(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleCos.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Cos.class)
    public <I extends RealType<I>, O extends RealType<O>> O cos(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Cos.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleCosh.class)
    public double cosh(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleCosh.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Cosh.class)
    public <I extends RealType<I>, O extends RealType<O>> O cosh(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Cosh.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Cot.class)
    public <I extends RealType<I>, O extends RealType<O>> O cot(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Cot.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Coth.class)
    public <I extends RealType<I>, O extends RealType<O>> O coth(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Coth.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Csc.class)
    public <I extends RealType<I>, O extends RealType<O>> O csc(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Csc.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Csch.class)
    public <I extends RealType<I>, O extends RealType<O>> O csch(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Csch.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleCubeRoot.class)
    public double cubeRoot(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleCubeRoot.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.CubeRoot.class)
    public <I extends RealType<I>, O extends RealType<O>> O cubeRoot(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.CubeRoot.class, out, in);
        return (O)result;
    }

    @OpMethod(ops={ConstantToArrayImageP.DivideByte.class, ConstantToArrayImage.DivideByte.class, ConstantToArrayImageP.DivideUnsignedByte.class, ConstantToArrayImage.DivideUnsignedByte.class})
    public <B extends GenericByteType<B>> ArrayImg<B, ByteArray> divide(ArrayImg<B, ByteArray> image, byte value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.DivideDouble.class, ConstantToArrayImage.DivideDouble.class})
    public ArrayImg<DoubleType, DoubleArray> divide(ArrayImg<DoubleType, DoubleArray> image, double value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.DivideFloat.class, ConstantToArrayImage.DivideFloat.class})
    public ArrayImg<FloatType, FloatArray> divide(ArrayImg<FloatType, FloatArray> image, float value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.divide", image, Float.valueOf(value));
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.DivideInt.class, ConstantToArrayImage.DivideInt.class, ConstantToArrayImageP.DivideUnsignedInt.class, ConstantToArrayImage.DivideUnsignedInt.class})
    public <I extends GenericIntType<I>> ArrayImg<I, IntArray> divide(ArrayImg<I, IntArray> image, int value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.DivideLong.class, ConstantToArrayImage.DivideLong.class, ConstantToArrayImageP.DivideUnsignedLong.class, ConstantToArrayImage.DivideUnsignedLong.class})
    public <N extends NativeType<N>> ArrayImg<N, LongArray> divide(ArrayImg<N, LongArray> image, long value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.DivideShort.class, ConstantToArrayImage.DivideShort.class, ConstantToArrayImageP.DivideUnsignedShort.class, ConstantToArrayImage.DivideUnsignedShort.class})
    public <S extends GenericShortType<S>> ArrayImg<S, ShortArray> divide(ArrayImg<S, ShortArray> image, short value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(op=PrimitiveMath.DoubleDivide.class)
    public double divide(double a, double b) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleDivide.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatDivide.class)
    public float divide(float a, float b) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatDivide.class, Float.valueOf(a), Float.valueOf(b))).floatValue();
        return result;
    }

    @OpMethod(op=IIToIIOutputII.Divide.class)
    public <T extends NumericType<T>> IterableInterval<T> divide(IterableInterval<T> out, IterableInterval<T> in1, IterableInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Divide.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=IIToIIOutputII.Divide.class)
    public <T extends NumericType<T>> IterableInterval<T> divide(IterableInterval<T> in1, IterableInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Divide.class, in1, in2);
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerDivide.class)
    public int divide(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerDivide.class, a, b);
        return result;
    }

    @OpMethod(op=IIToRAIOutputII.Divide.class)
    public <T extends NumericType<T>> IterableInterval<T> divide(IterableInterval<T> in1, RandomAccessibleInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Divide.class, in1, in2);
        return result;
    }

    @OpMethod(op=IIToRAIOutputII.Divide.class)
    public <T extends NumericType<T>> IterableInterval<T> divide(IterableInterval<T> out, IterableInterval<T> in1, RandomAccessibleInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Divide.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputII.Divide.class)
    public <T extends NumericType<T>> IterableInterval<T> divide(IterableInterval<T> in, T value) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Divide.class, in, value);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputII.Divide.class)
    public <T extends NumericType<T>> IterableInterval<T> divide(IterableInterval<T> out, IterableInterval<T> in, T value) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Divide.class, out, in, value);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongDivide.class)
    public long divide(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongDivide.class, a, b);
        return result;
    }

    @OpMethod(op=BinaryRealTypeMath.Divide.class)
    public <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> O divide(O out, I1 in1, I2 in2, double dbzVal) {
        RealType result = (RealType)this.ops().run(Ops.Math.Divide.class, out, in1, in2, dbzVal);
        return (O)result;
    }

    @OpMethod(ops={ConstantToPlanarImage.DivideByte.class, ConstantToPlanarImage.DivideUnsignedByte.class})
    public <B extends GenericByteType<B>> PlanarImg<B, ByteArray> divide(PlanarImg<B, ByteArray> image, byte value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(op=ConstantToPlanarImage.DivideDouble.class)
    public PlanarImg<DoubleType, DoubleArray> divide(PlanarImg<DoubleType, DoubleArray> image, double value) {
        PlanarImg result = (PlanarImg)this.ops().run(Ops.Math.Divide.class, image, value);
        return result;
    }

    @OpMethod(op=ConstantToPlanarImage.DivideFloat.class)
    public PlanarImg<FloatType, FloatArray> divide(PlanarImg<FloatType, FloatArray> image, float value) {
        PlanarImg result = (PlanarImg)this.ops().run(Ops.Math.Divide.class, image, Float.valueOf(value));
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.DivideInt.class, ConstantToPlanarImage.DivideUnsignedInt.class})
    public <I extends GenericIntType<I>> PlanarImg<I, IntArray> divide(PlanarImg<I, IntArray> image, int value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.DivideLong.class, ConstantToPlanarImage.DivideUnsignedLong.class})
    public <N extends NativeType<N>> PlanarImg<N, LongArray> divide(PlanarImg<N, LongArray> image, long value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.DivideShort.class, ConstantToPlanarImage.DivideUnsignedShort.class})
    public <S extends GenericShortType<S>> PlanarImg<S, ShortArray> divide(PlanarImg<S, ShortArray> arg, short value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.divide", arg, value);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputRAI.Divide.class)
    public <T extends NumericType<T>> RandomAccessibleInterval<T> divide(RandomAccessibleInterval<T> out, IterableInterval<T> in, T value) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.ops().run(Ops.Math.Divide.class, out, in, value);
        return result;
    }

    @OpMethod(ops={NumericTypeBinaryMath.Divide.class})
    public <T extends NumericType<T>> T divide(T in, T b) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Divide.class, in, b);
        return (T)result;
    }

    @OpMethod(op=NumericTypeBinaryMath.Divide.class)
    public <T extends NumericType<T>> T divide(T out, T in, T b) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Divide.class, out, in, b);
        return (T)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleExp.class)
    public double exp(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleExp.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Exp.class)
    public <I extends RealType<I>, O extends RealType<O>> O exp(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Exp.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.ExpMinusOne.class)
    public <I extends RealType<I>, O extends RealType<O>> O expMinusOne(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.ExpMinusOne.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleFloor.class)
    public double floor(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleFloor.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Floor.class)
    public <I extends RealType<I>, O extends RealType<O>> O floor(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Floor.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.GammaConstant.class)
    public <I extends RealType<I>, O extends RealType<O>> O gamma(O out, I in, double constant) {
        RealType result = (RealType)this.ops().run(Ops.Math.Gamma.class, out, in, constant);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Invert.class)
    public <I extends RealType<I>, O extends RealType<O>> O invert(O out, I in, double specifiedMin, double specifiedMax) {
        RealType result = (RealType)this.ops().run(Ops.Math.Invert.class, out, in, specifiedMin, specifiedMax);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.IntegerLeftShift.class)
    public int leftShift(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerLeftShift.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongLeftShift.class)
    public long leftShift(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongLeftShift.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.DoubleLog.class)
    public double log(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleLog.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Log.class)
    public <I extends RealType<I>, O extends RealType<O>> O log(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Log.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleLog10.class)
    public double log10(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleLog10.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Log10.class)
    public <I extends RealType<I>, O extends RealType<O>> O log10(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Log10.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Log2.class)
    public <I extends RealType<I>, O extends RealType<O>> O log2(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Log2.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleLogOnePlusX.class)
    public double logOnePlusX(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleLogOnePlusX.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.LogOnePlusX.class)
    public <I extends RealType<I>, O extends RealType<O>> O logOnePlusX(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.LogOnePlusX.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleMax.class)
    public double max(double a, double b) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleMax.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatMax.class)
    public float max(float a, float b) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatMax.class, Float.valueOf(a), Float.valueOf(b))).floatValue();
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerMax.class)
    public int max(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerMax.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongMax.class)
    public long max(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongMax.class, a, b);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.MaxConstant.class)
    public <I extends RealType<I>, O extends RealType<O>> O max(O out, I in, double constant) {
        RealType result = (RealType)this.ops().run(Ops.Math.Max.class, out, in, constant);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleMin.class)
    public double min(double a, double b) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleMin.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatMin.class)
    public float min(float a, float b) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatMin.class, Float.valueOf(a), Float.valueOf(b))).floatValue();
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerMin.class)
    public int min(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerMin.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongMin.class)
    public long min(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongMin.class, a, b);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.MinConstant.class)
    public <I extends RealType<I>, O extends RealType<O>> O min(O out, I in, double constant) {
        RealType result = (RealType)this.ops().run(Ops.Math.Min.class, out, in, constant);
        return (O)result;
    }

    @OpMethod(ops={ConstantToArrayImageP.AddByte.class, ConstantToArrayImage.AddByte.class, ConstantToArrayImageP.AddUnsignedByte.class, ConstantToArrayImage.AddUnsignedByte.class})
    public <B extends GenericByteType<B>> ArrayImg<B, ByteArray> add(ArrayImg<B, ByteArray> image, byte value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.add", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.AddDouble.class, ConstantToArrayImage.AddDouble.class})
    public ArrayImg<DoubleType, DoubleArray> add(ArrayImg<DoubleType, DoubleArray> image, double value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.add", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.AddFloat.class, ConstantToArrayImage.AddFloat.class})
    public ArrayImg<FloatType, FloatArray> add(ArrayImg<FloatType, FloatArray> image, float value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.add", image, Float.valueOf(value));
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.AddInt.class, ConstantToArrayImage.AddInt.class, ConstantToArrayImageP.AddUnsignedInt.class, ConstantToArrayImage.AddUnsignedInt.class})
    public <I extends GenericIntType<I>> ArrayImg<I, IntArray> add(ArrayImg<I, IntArray> image, int value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.add", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.AddLong.class, ConstantToArrayImage.AddLong.class, ConstantToArrayImageP.AddUnsignedLong.class, ConstantToArrayImage.AddUnsignedLong.class})
    public <N extends NativeType<N>> ArrayImg<N, LongArray> add(ArrayImg<LongType, LongArray> image, long value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.add", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.AddShort.class, ConstantToArrayImage.AddShort.class, ConstantToArrayImageP.AddUnsignedShort.class, ConstantToArrayImage.AddUnsignedShort.class})
    public <S extends GenericShortType<S>> ArrayImg<S, ShortArray> add(ArrayImg<S, ShortArray> image, short value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.add", image, value);
        return result;
    }

    @OpMethod(op=PrimitiveMath.DoubleMultiply.class)
    public double multiply(double a, double b) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleMultiply.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatMultiply.class)
    public float multiply(float a, float b) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatMultiply.class, Float.valueOf(a), Float.valueOf(b))).floatValue();
        return result;
    }

    @OpMethod(op=IIToIIOutputII.Multiply.class)
    public <T extends NumericType<T>> IterableInterval<T> multiply(IterableInterval<T> out, IterableInterval<T> in1, IterableInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Multiply.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=IIToIIOutputII.Multiply.class)
    public <T extends NumericType<T>> IterableInterval<T> multiply(IterableInterval<T> in1, IterableInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Multiply.class, in1, in2);
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerMultiply.class)
    public int multiply(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerMultiply.class, a, b);
        return result;
    }

    @OpMethod(op=IIToRAIOutputII.Multiply.class)
    public <T extends NumericType<T>> IterableInterval<T> multiply(IterableInterval<T> in1, RandomAccessibleInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Multiply.class, in1, in2);
        return result;
    }

    @OpMethod(op=IIToRAIOutputII.Multiply.class)
    public <T extends NumericType<T>> IterableInterval<T> multiply(IterableInterval<T> out, IterableInterval<T> in1, RandomAccessibleInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Multiply.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputII.Multiply.class)
    public <T extends NumericType<T>> IterableInterval<T> multiply(IterableInterval<T> in, T value) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Multiply.class, in, value);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputII.Multiply.class)
    public <T extends NumericType<T>> IterableInterval<T> multiply(IterableInterval<T> out, IterableInterval<T> in, T value) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Multiply.class, out, in, value);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongMultiply.class)
    public long multiply(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongMultiply.class, a, b);
        return result;
    }

    @OpMethod(op=BinaryRealTypeMath.Multiply.class)
    public <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> O multiply(O out, I1 in1, I2 in2) {
        RealType result = (RealType)this.ops().run(Ops.Math.Multiply.class, out, in1, in2);
        return (O)result;
    }

    @OpMethod(ops={ConstantToPlanarImage.MultiplyByte.class, ConstantToPlanarImage.MultiplyUnsignedByte.class})
    public <B extends GenericByteType<B>> PlanarImg<B, ByteArray> multiply(PlanarImg<B, ByteArray> image, byte value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.divide", image, value);
        return result;
    }

    @OpMethod(op=ConstantToPlanarImage.MultiplyDouble.class)
    public PlanarImg<DoubleType, DoubleArray> multiply(PlanarImg<DoubleType, DoubleArray> image, double value) {
        PlanarImg result = (PlanarImg)this.ops().run(Ops.Math.Multiply.class, image, value);
        return result;
    }

    @OpMethod(op=ConstantToPlanarImage.MultiplyFloat.class)
    public PlanarImg<FloatType, FloatArray> multiply(PlanarImg<FloatType, FloatArray> image, float value) {
        PlanarImg result = (PlanarImg)this.ops().run(Ops.Math.Multiply.class, image, Float.valueOf(value));
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.MultiplyInt.class, ConstantToPlanarImage.MultiplyUnsignedInt.class})
    public <I extends GenericIntType<I>> PlanarImg<I, IntArray> multiply(PlanarImg<I, IntArray> image, int value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.multiply", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.MultiplyLong.class, ConstantToPlanarImage.MultiplyUnsignedLong.class})
    public <N extends NativeType<N>> PlanarImg<N, LongArray> multiply(PlanarImg<N, LongArray> image, long value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.multiply", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.MultiplyShort.class, ConstantToPlanarImage.MultiplyUnsignedShort.class})
    public <S extends GenericShortType<S>> PlanarImg<S, ShortArray> multiply(PlanarImg<S, ShortArray> arg, short value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.multiply", arg, value);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputRAI.Multiply.class)
    public <T extends NumericType<T>> RandomAccessibleInterval<T> multiply(RandomAccessibleInterval<T> out, IterableInterval<T> in, T value) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.ops().run(Ops.Math.Multiply.class, out, in, value);
        return result;
    }

    @OpMethod(op=NumericTypeBinaryMath.Multiply.class)
    public <T extends NumericType<T>> T multiply(T in, T b) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Multiply.class, in, b);
        return (T)result;
    }

    @OpMethod(op=NumericTypeBinaryMath.Multiply.class)
    public <T extends NumericType<T>> T multiply(T out, T in1, T in2) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Multiply.class, out, in1, in2);
        return (T)result;
    }

    @OpMethod(op=UnaryRealTypeMath.NearestInt.class)
    public <I extends RealType<I>, O extends RealType<O>> O nearestInt(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.NearestInt.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleNegate.class)
    public double negate(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleNegate.class, a);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatNegate.class)
    public float negate(float a) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatNegate.class, Float.valueOf(a))).floatValue();
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerNegate.class)
    public int negate(int a) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerNegate.class, a);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongNegate.class)
    public long negate(long a) {
        long result = (Long)this.ops().run(PrimitiveMath.LongNegate.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Negate.class)
    public <I extends RealType<I>, O extends RealType<O>> O negate(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Negate.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.IntegerOr.class)
    public int or(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerOr.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongOr.class)
    public long or(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongOr.class, a, b);
        return result;
    }

    @OpMethod(op=BinaryRealTypeMath.Or.class)
    public <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> O or(O out, I1 in1, I2 in2) {
        RealType result = (RealType)this.ops().run(Ops.Math.Or.class, out, in1, in2);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoublePower.class)
    public double power(double a, double b) {
        double result = (Double)this.ops().run(PrimitiveMath.DoublePower.class, a, b);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.PowerConstant.class)
    public <I extends RealType<I>, O extends RealType<O>> O power(O out, I in, double constant) {
        RealType result = (RealType)this.ops().run(Ops.Math.Power.class, out, in, constant);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.RandomGaussian.class)
    public <I extends RealType<I>, O extends RealType<O>> O randomGaussian(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.RandomGaussian.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.RandomGaussian.class)
    public <I extends RealType<I>, O extends RealType<O>> O randomGaussian(O out, I in, long seed) {
        RealType result = (RealType)this.ops().run(Ops.Math.RandomGaussian.class, out, in, seed);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.RandomUniform.class)
    public <I extends RealType<I>, O extends RealType<O>> O randomUniform(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.RandomUniform.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.RandomUniform.class)
    public <I extends RealType<I>, O extends RealType<O>> O randomUniform(O out, I in, long seed) {
        RealType result = (RealType)this.ops().run(Ops.Math.RandomUniform.class, out, in, seed);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Reciprocal.class)
    public <I extends RealType<I>, O extends RealType<O>> O reciprocal(O out, I in, double dbzVal) {
        RealType result = (RealType)this.ops().run(Ops.Math.Reciprocal.class, out, in, dbzVal);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleRemainder.class)
    public double remainder(double a, double b) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleRemainder.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatRemainder.class)
    public float remainder(float a, float b) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatRemainder.class, Float.valueOf(a), Float.valueOf(b))).floatValue();
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerRemainder.class)
    public int remainder(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerRemainder.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongRemainder.class)
    public long remainder(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongRemainder.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerRightShift.class)
    public int rightShift(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerRightShift.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongRightShift.class)
    public long rightShift(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongRightShift.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.DoubleRound.class)
    public double round(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleRound.class, a);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatRound.class)
    public float round(float a) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatRound.class, Float.valueOf(a))).floatValue();
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Round.class)
    public <I extends RealType<I>, O extends RealType<O>> O round(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Round.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Sec.class)
    public <I extends RealType<I>, O extends RealType<O>> O sec(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Sec.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Sech.class)
    public <I extends RealType<I>, O extends RealType<O>> O sech(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Sech.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleSignum.class)
    public double signum(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleSignum.class, a);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatSignum.class)
    public float signum(float a) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatSignum.class, Float.valueOf(a))).floatValue();
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Signum.class)
    public <I extends RealType<I>, O extends RealType<O>> O signum(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Signum.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleSin.class)
    public double sin(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleSin.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Sin.class)
    public <I extends RealType<I>, O extends RealType<O>> O sin(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Sin.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Sinc.class)
    public <I extends RealType<I>, O extends RealType<O>> O sinc(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Sinc.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.SincPi.class)
    public <I extends RealType<I>, O extends RealType<O>> O sincPi(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.SincPi.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleSinh.class)
    public double sinh(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleSinh.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Sinh.class)
    public <I extends RealType<I>, O extends RealType<O>> O sinh(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Sinh.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Sqr.class)
    public <I extends RealType<I>, O extends RealType<O>> O sqr(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Sqr.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleSqrt.class)
    public double sqrt(double a) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleSqrt.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Sqrt.class)
    public <I extends RealType<I>, O extends RealType<O>> O sqrt(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Sqrt.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Step.class)
    public <I extends RealType<I>, O extends RealType<O>> O step(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Step.class, out, in);
        return (O)result;
    }

    @OpMethod(ops={ConstantToArrayImageP.SubtractByte.class, ConstantToArrayImage.SubtractByte.class, ConstantToArrayImageP.SubtractUnsignedByte.class, ConstantToArrayImage.SubtractUnsignedByte.class})
    public <B extends GenericByteType<B>> ArrayImg<B, ByteArray> subtract(ArrayImg<B, ByteArray> image, byte value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.SubtractDouble.class, ConstantToArrayImage.SubtractDouble.class})
    public ArrayImg<DoubleType, DoubleArray> subtract(ArrayImg<DoubleType, DoubleArray> image, double value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.SubtractFloat.class, ConstantToArrayImage.SubtractFloat.class})
    public ArrayImg<FloatType, FloatArray> subtract(ArrayImg<FloatType, FloatArray> image, float value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.subtract", image, Float.valueOf(value));
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.SubtractInt.class, ConstantToArrayImage.SubtractInt.class, ConstantToArrayImageP.SubtractUnsignedInt.class, ConstantToArrayImage.SubtractUnsignedInt.class})
    public <I extends GenericIntType<I>> ArrayImg<I, IntArray> subtract(ArrayImg<I, IntArray> image, int value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.SubtractLong.class, ConstantToArrayImage.SubtractLong.class, ConstantToArrayImageP.SubtractUnsignedLong.class, ConstantToArrayImage.SubtractUnsignedLong.class})
    public <N extends NativeType<N>> ArrayImg<N, LongArray> subtract(ArrayImg<N, LongArray> image, long value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToArrayImageP.SubtractShort.class, ConstantToArrayImage.SubtractShort.class, ConstantToArrayImageP.SubtractUnsignedShort.class, ConstantToArrayImage.SubtractUnsignedShort.class})
    public <S extends GenericShortType<S>> ArrayImg<S, ShortArray> subtract(ArrayImg<S, ShortArray> image, short value) {
        ArrayImg result = (ArrayImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(op=PrimitiveMath.DoubleSubtract.class)
    public double subtract(double a, double b) {
        double result = (Double)this.ops().run(PrimitiveMath.DoubleSubtract.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.FloatSubtract.class)
    public float subtract(float a, float b) {
        float result = ((Float)this.ops().run(PrimitiveMath.FloatSubtract.class, Float.valueOf(a), Float.valueOf(b))).floatValue();
        return result;
    }

    @OpMethod(op=IIToIIOutputII.Subtract.class)
    public <T extends NumericType<T>> IterableInterval<T> subtract(IterableInterval<T> out, IterableInterval<T> in1, IterableInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Subtract.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=IIToIIOutputII.Subtract.class)
    public <T extends NumericType<T>> IterableInterval<T> subtract(IterableInterval<T> in1, IterableInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Subtract.class, in1, in2);
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerSubtract.class)
    public int subtract(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerSubtract.class, a, b);
        return result;
    }

    @OpMethod(op=IIToRAIOutputII.Subtract.class)
    public <T extends NumericType<T>> IterableInterval<T> subtract(IterableInterval<T> in1, RandomAccessibleInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Subtract.class, in1, in2);
        return result;
    }

    @OpMethod(op=IIToRAIOutputII.Subtract.class)
    public <T extends NumericType<T>> IterableInterval<T> subtract(IterableInterval<T> out, IterableInterval<T> in1, RandomAccessibleInterval<T> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Subtract.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputII.Subtract.class)
    public <T extends NumericType<T>> IterableInterval<T> subtract(IterableInterval<T> in, T value) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Subtract.class, in, value);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputII.Subtract.class)
    public <T extends NumericType<T>> IterableInterval<T> subtract(IterableInterval<T> out, IterableInterval<T> in, T value) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.Subtract.class, out, in, value);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongSubtract.class)
    public long subtract(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongSubtract.class, a, b);
        return result;
    }

    @OpMethod(op=BinaryRealTypeMath.Subtract.class)
    public <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> O subtract(O out, I1 in1, I2 in2) {
        RealType result = (RealType)this.ops().run(Ops.Math.Subtract.class, out, in1, in2);
        return (O)result;
    }

    @OpMethod(ops={ConstantToPlanarImage.SubtractByte.class, ConstantToPlanarImage.SubtractUnsignedByte.class})
    public <B extends GenericByteType<B>> PlanarImg<B, ByteArray> subtract(PlanarImg<B, ByteArray> image, byte value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(op=ConstantToPlanarImage.SubtractDouble.class)
    public PlanarImg<DoubleType, DoubleArray> subtract(PlanarImg<DoubleType, DoubleArray> image, double value) {
        PlanarImg result = (PlanarImg)this.ops().run(Ops.Math.Subtract.class, image, value);
        return result;
    }

    @OpMethod(op=ConstantToPlanarImage.SubtractFloat.class)
    public PlanarImg<FloatType, FloatArray> subtract(PlanarImg<FloatType, FloatArray> image, float value) {
        PlanarImg result = (PlanarImg)this.ops().run(Ops.Math.Subtract.class, image, Float.valueOf(value));
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.SubtractInt.class, ConstantToPlanarImage.SubtractUnsignedInt.class})
    public <I extends GenericIntType<I>> PlanarImg<I, IntArray> subtract(PlanarImg<I, IntArray> image, int value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.SubtractLong.class, ConstantToPlanarImage.SubtractUnsignedLong.class})
    public <N extends NativeType<N>, A extends ArrayDataAccess<A>> PlanarImg<N, A> subtract(PlanarImg<N, A> image, long value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(ops={ConstantToPlanarImage.SubtractShort.class, ConstantToPlanarImage.SubtractUnsignedShort.class})
    public <S extends GenericShortType<S>> PlanarImg<S, ShortArray> subtract(PlanarImg<S, ShortArray> image, short value) {
        PlanarImg result = (PlanarImg)this.ops().run("math.subtract", image, value);
        return result;
    }

    @OpMethod(op=ConstantToIIOutputRAI.Subtract.class)
    public <T extends NumericType<T>> RandomAccessibleInterval<T> subtract(RandomAccessibleInterval<T> out, IterableInterval<T> in, T value) {
        RandomAccessibleInterval result = (RandomAccessibleInterval)this.ops().run(Ops.Math.Subtract.class, out, in, value);
        return result;
    }

    @OpMethod(op=NumericTypeBinaryMath.Subtract.class)
    public <T extends NumericType<T>> T subtract(T in, T b) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Subtract.class, in, b);
        return (T)result;
    }

    @OpMethod(op=NumericTypeBinaryMath.Subtract.class)
    public <T extends NumericType<T>> T subtract(T out, T in1, T in2) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Subtract.class, out, in1, in2);
        return (T)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleTan.class)
    public double tan(double a) {
        double result = (Double)this.ops().run(Ops.Math.Tan.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Tan.class)
    public <I extends RealType<I>, O extends RealType<O>> O tan(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Tan.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.DoubleTanh.class)
    public double tanh(double a) {
        double result = (Double)this.ops().run(Ops.Math.Tanh.class, a);
        return result;
    }

    @OpMethod(op=UnaryRealTypeMath.Tanh.class)
    public <I extends RealType<I>, O extends RealType<O>> O tanh(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Tanh.class, out, in);
        return (O)result;
    }

    @OpMethod(op=UnaryRealTypeMath.Ulp.class)
    public <I extends RealType<I>, O extends RealType<O>> O ulp(O out, I in) {
        RealType result = (RealType)this.ops().run(Ops.Math.Ulp.class, out, in);
        return (O)result;
    }

    @OpMethod(op=PrimitiveMath.IntegerUnsignedRightShift.class)
    public int unsignedRightShift(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerUnsignedRightShift.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongUnsignedRightShift.class)
    public long unsignedRightShift(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongUnsignedRightShift.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.IntegerXor.class)
    public int xor(int a, int b) {
        int result = (Integer)this.ops().run(PrimitiveMath.IntegerXor.class, a, b);
        return result;
    }

    @OpMethod(op=PrimitiveMath.LongXor.class)
    public long xor(long a, long b) {
        long result = (Long)this.ops().run(PrimitiveMath.LongXor.class, a, b);
        return result;
    }

    @OpMethod(op=BinaryRealTypeMath.Xor.class)
    public <I1 extends RealType<I1>, I2 extends RealType<I2>, O extends RealType<O>> O xor(O out, I1 in1, I2 in2) {
        RealType result = (RealType)this.ops().run(Ops.Math.Xor.class, out, in1, in2);
        return (O)result;
    }

    @OpMethod(op=NullaryNumericTypeMath.Zero.class)
    public <T extends NumericType<T>> T zero(T out) {
        NumericType result = (NumericType)this.ops().run(Ops.Math.Zero.class, out);
        return (T)result;
    }

    @OpMethod(ops={ComplexConjugateMultiplyMap.class})
    public <I extends RealType<I>, O extends RealType<O>> IterableInterval<O> complexConjugateMultiply(IterableInterval<O> out, IterableInterval<I> in1, IterableInterval<I> in2) {
        IterableInterval result = (IterableInterval)this.ops().run(Ops.Math.ComplexConjugateMultiply.class, out, in1, in2);
        return result;
    }

    @OpMethod(op=ComplexConjugateMultiplyOp.class)
    public <C extends ComplexType<C>> C complexConjugateMultiply(C in1, C in2, C out) {
        ComplexType result = (ComplexType)this.ops().run(ComplexConjugateMultiplyOp.class, out, in1, in2);
        return (C)result;
    }

    public String getName() {
        return "math";
    }
}

