/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.math;

import net.imagej.ops.AbstractOp;
import net.imagej.ops.Ops;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public final class PrimitiveMath {
    private PrimitiveMath() {
    }

    @Plugin(type=Ops.Math.Tanh.class, priority=0.1)
    public static class DoubleTanh
    extends AbstractOp
    implements Ops.Math.Tanh {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.tanh(this.a);
        }
    }

    @Plugin(type=Ops.Math.Tan.class, priority=0.1)
    public static class DoubleTan
    extends AbstractOp
    implements Ops.Math.Tan {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.tan(this.a);
        }
    }

    @Plugin(type=Ops.Math.Sqrt.class, priority=0.1)
    public static class DoubleSqrt
    extends AbstractOp
    implements Ops.Math.Sqrt {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.sqrt(this.a);
        }
    }

    @Plugin(type=Ops.Math.Sinh.class, priority=0.1)
    public static class DoubleSinh
    extends AbstractOp
    implements Ops.Math.Sinh {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.sinh(this.a);
        }
    }

    @Plugin(type=Ops.Math.Sin.class, priority=0.1)
    public static class DoubleSin
    extends AbstractOp
    implements Ops.Math.Sin {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.sin(this.a);
        }
    }

    @Plugin(type=Ops.Math.Signum.class, priority=0.1)
    public static class DoubleSignum
    extends AbstractOp
    implements Ops.Math.Signum {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.signum(this.a);
        }
    }

    @Plugin(type=Ops.Math.Round.class, priority=0.1)
    public static class DoubleRound
    extends AbstractOp
    implements Ops.Math.Round {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.round(this.a);
        }
    }

    @Plugin(type=Ops.Math.LogOnePlusX.class, priority=0.1)
    public static class DoubleLogOnePlusX
    extends AbstractOp
    implements Ops.Math.LogOnePlusX {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.log1p(this.a);
        }
    }

    @Plugin(type=Ops.Math.Log10.class, priority=0.1)
    public static class DoubleLog10
    extends AbstractOp
    implements Ops.Math.Log10 {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.log10(this.a);
        }
    }

    @Plugin(type=Ops.Math.Log.class, priority=0.1)
    public static class DoubleLog
    extends AbstractOp
    implements Ops.Math.Log {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.log(this.a);
        }
    }

    @Plugin(type=Ops.Math.Floor.class, priority=0.1)
    public static class DoubleFloor
    extends AbstractOp
    implements Ops.Math.Floor {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.floor(this.a);
        }
    }

    @Plugin(type=Ops.Math.Exp.class, priority=0.1)
    public static class DoubleExp
    extends AbstractOp
    implements Ops.Math.Exp {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.exp(this.a);
        }
    }

    @Plugin(type=Ops.Math.CubeRoot.class, priority=0.1)
    public static class DoubleCubeRoot
    extends AbstractOp
    implements Ops.Math.CubeRoot {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.cbrt(this.a);
        }
    }

    @Plugin(type=Ops.Math.Cosh.class, priority=0.1)
    public static class DoubleCosh
    extends AbstractOp
    implements Ops.Math.Cosh {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.cosh(this.a);
        }
    }

    @Plugin(type=Ops.Math.Cos.class, priority=0.1)
    public static class DoubleCos
    extends AbstractOp
    implements Ops.Math.Cos {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.cos(this.a);
        }
    }

    @Plugin(type=Ops.Math.Ceil.class, priority=0.1)
    public static class DoubleCeil
    extends AbstractOp
    implements Ops.Math.Ceil {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.ceil(this.a);
        }
    }

    @Plugin(type=Ops.Math.Arctan.class, priority=0.1)
    public static class DoubleArctan
    extends AbstractOp
    implements Ops.Math.Arctan {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.atan(this.a);
        }
    }

    @Plugin(type=Ops.Math.Arcsin.class, priority=0.1)
    public static class DoubleArcsin
    extends AbstractOp
    implements Ops.Math.Arcsin {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.asin(this.a);
        }
    }

    @Plugin(type=Ops.Math.Arccos.class, priority=0.1)
    public static class DoubleArccos
    extends AbstractOp
    implements Ops.Math.Arccos {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.acos(this.a);
        }
    }

    @Plugin(type=Ops.Math.Abs.class, priority=0.1)
    public static class DoubleAbs
    extends AbstractOp
    implements Ops.Math.Abs {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = Math.abs(this.a);
        }
    }

    @Plugin(type=Ops.Math.Negate.class, priority=0.1)
    public static class DoubleNegate
    extends AbstractOp
    implements Ops.Math.Negate {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;

        public void run() {
            this.result = -this.a;
        }
    }

    @Plugin(type=Ops.Math.Power.class, priority=0.1)
    public static class DoublePower
    extends AbstractOp
    implements Ops.Math.Power {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;
        @Parameter
        private double b;

        public void run() {
            this.result = Math.pow(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.Min.class, priority=0.1)
    public static class DoubleMin
    extends AbstractOp
    implements Ops.Math.Min {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;
        @Parameter
        private double b;

        public void run() {
            this.result = Math.min(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.Max.class, priority=0.1)
    public static class DoubleMax
    extends AbstractOp
    implements Ops.Math.Max {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;
        @Parameter
        private double b;

        public void run() {
            this.result = Math.max(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.Remainder.class, priority=0.1)
    public static class DoubleRemainder
    extends AbstractOp
    implements Ops.Math.Remainder {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;
        @Parameter
        private double b;

        public void run() {
            this.result = this.a % this.b;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=0.1)
    public static class DoubleDivide
    extends AbstractOp
    implements Ops.Math.Divide {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;
        @Parameter
        private double b;

        public void run() {
            this.result = this.a / this.b;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=0.1)
    public static class DoubleMultiply
    extends AbstractOp
    implements Ops.Math.Multiply {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;
        @Parameter
        private double b;

        public void run() {
            this.result = this.a * this.b;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=0.1)
    public static class DoubleSubtract
    extends AbstractOp
    implements Ops.Math.Subtract {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;
        @Parameter
        private double b;

        public void run() {
            this.result = this.a - this.b;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=0.1)
    public static class DoubleAdd
    extends AbstractOp
    implements Ops.Math.Add {
        @Parameter(type=ItemIO.OUTPUT)
        private double result;
        @Parameter
        private double a;
        @Parameter
        private double b;

        public void run() {
            this.result = this.a + this.b;
        }
    }

    @Plugin(type=Ops.Math.Signum.class, priority=0.2)
    public static class FloatSignum
    extends AbstractOp
    implements Ops.Math.Signum {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;

        public void run() {
            this.result = Math.signum(this.a);
        }
    }

    @Plugin(type=Ops.Math.Round.class, priority=0.2)
    public static class FloatRound
    extends AbstractOp
    implements Ops.Math.Round {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;

        public void run() {
            this.result = Math.round(this.a);
        }
    }

    @Plugin(type=Ops.Math.Abs.class, priority=0.2)
    public static class FloatAbs
    extends AbstractOp
    implements Ops.Math.Abs {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;

        public void run() {
            this.result = Math.abs(this.a);
        }
    }

    @Plugin(type=Ops.Math.Negate.class, priority=0.2)
    public static class FloatNegate
    extends AbstractOp
    implements Ops.Math.Negate {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;

        public void run() {
            this.result = -this.a;
        }
    }

    @Plugin(type=Ops.Math.Min.class, priority=0.2)
    public static class FloatMin
    extends AbstractOp
    implements Ops.Math.Min {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;
        @Parameter
        private float b;

        public void run() {
            this.result = Math.min(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.Max.class, priority=0.2)
    public static class FloatMax
    extends AbstractOp
    implements Ops.Math.Max {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;
        @Parameter
        private float b;

        public void run() {
            this.result = Math.max(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.Remainder.class, priority=0.2)
    public static class FloatRemainder
    extends AbstractOp
    implements Ops.Math.Remainder {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;
        @Parameter
        private float b;

        public void run() {
            this.result = this.a % this.b;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=0.2)
    public static class FloatDivide
    extends AbstractOp
    implements Ops.Math.Divide {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;
        @Parameter
        private float b;

        public void run() {
            this.result = this.a / this.b;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=0.2)
    public static class FloatMultiply
    extends AbstractOp
    implements Ops.Math.Multiply {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;
        @Parameter
        private float b;

        public void run() {
            this.result = this.a * this.b;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=0.2)
    public static class FloatSubtract
    extends AbstractOp
    implements Ops.Math.Subtract {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;
        @Parameter
        private float b;

        public void run() {
            this.result = this.a - this.b;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=0.2)
    public static class FloatAdd
    extends AbstractOp
    implements Ops.Math.Add {
        @Parameter(type=ItemIO.OUTPUT)
        private float result;
        @Parameter
        private float a;
        @Parameter
        private float b;

        public void run() {
            this.result = this.a + this.b;
        }
    }

    @Plugin(type=Ops.Math.Abs.class, priority=0.3)
    public static class LongAbs
    extends AbstractOp
    implements Ops.Math.Abs {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;

        public void run() {
            this.result = Math.abs(this.a);
        }
    }

    @Plugin(type=Ops.Math.Negate.class, priority=0.3)
    public static class LongNegate
    extends AbstractOp
    implements Ops.Math.Negate {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;

        public void run() {
            this.result = -this.a;
        }
    }

    @Plugin(type=Ops.Math.Complement.class, priority=0.3)
    public static class LongComplement
    extends AbstractOp
    implements Ops.Math.Complement {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;

        public void run() {
            this.result = this.a ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @Plugin(type=Ops.Math.Min.class, priority=0.3)
    public static class LongMin
    extends AbstractOp
    implements Ops.Math.Min {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = Math.min(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.Max.class, priority=0.3)
    public static class LongMax
    extends AbstractOp
    implements Ops.Math.Max {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = Math.max(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.UnsignedRightShift.class, priority=0.3)
    public static class LongUnsignedRightShift
    extends AbstractOp
    implements Ops.Math.UnsignedRightShift {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a >>> (int)this.b;
        }
    }

    @Plugin(type=Ops.Math.RightShift.class, priority=0.3)
    public static class LongRightShift
    extends AbstractOp
    implements Ops.Math.RightShift {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a >> (int)this.b;
        }
    }

    @Plugin(type=Ops.Math.LeftShift.class, priority=0.3)
    public static class LongLeftShift
    extends AbstractOp
    implements Ops.Math.LeftShift {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a << (int)this.b;
        }
    }

    @Plugin(type=Ops.Math.Xor.class, priority=0.3)
    public static class LongXor
    extends AbstractOp
    implements Ops.Math.Xor {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a ^ this.b;
        }
    }

    @Plugin(type=Ops.Math.Or.class, priority=0.3)
    public static class LongOr
    extends AbstractOp
    implements Ops.Math.Or {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a | this.b;
        }
    }

    @Plugin(type=Ops.Math.And.class, priority=0.3)
    public static class LongAnd
    extends AbstractOp
    implements Ops.Math.And {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a & this.b;
        }
    }

    @Plugin(type=Ops.Math.Remainder.class, priority=0.3)
    public static class LongRemainder
    extends AbstractOp
    implements Ops.Math.Remainder {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a % this.b;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=0.3)
    public static class LongDivide
    extends AbstractOp
    implements Ops.Math.Divide {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a / this.b;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=0.3)
    public static class LongMultiply
    extends AbstractOp
    implements Ops.Math.Multiply {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a * this.b;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=0.3)
    public static class LongSubtract
    extends AbstractOp
    implements Ops.Math.Subtract {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a - this.b;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=0.3)
    public static class LongAdd
    extends AbstractOp
    implements Ops.Math.Add {
        @Parameter(type=ItemIO.OUTPUT)
        private long result;
        @Parameter
        private long a;
        @Parameter
        private long b;

        public void run() {
            this.result = this.a + this.b;
        }
    }

    @Plugin(type=Ops.Math.Abs.class, priority=0.4)
    public static class IntegerAbs
    extends AbstractOp
    implements Ops.Math.Abs {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;

        public void run() {
            this.result = Math.abs(this.a);
        }
    }

    @Plugin(type=Ops.Math.Negate.class, priority=0.4)
    public static class IntegerNegate
    extends AbstractOp
    implements Ops.Math.Negate {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;

        public void run() {
            this.result = -this.a;
        }
    }

    @Plugin(type=Ops.Math.Complement.class, priority=0.4)
    public static class IntegerComplement
    extends AbstractOp
    implements Ops.Math.Complement {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;

        public void run() {
            this.result = ~this.a;
        }
    }

    @Plugin(type=Ops.Math.Min.class, priority=0.4)
    public static class IntegerMin
    extends AbstractOp
    implements Ops.Math.Min {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = Math.min(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.Max.class, priority=0.4)
    public static class IntegerMax
    extends AbstractOp
    implements Ops.Math.Max {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = Math.max(this.a, this.b);
        }
    }

    @Plugin(type=Ops.Math.UnsignedRightShift.class, priority=0.4)
    public static class IntegerUnsignedRightShift
    extends AbstractOp
    implements Ops.Math.UnsignedRightShift {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a >>> this.b;
        }
    }

    @Plugin(type=Ops.Math.RightShift.class, priority=0.4)
    public static class IntegerRightShift
    extends AbstractOp
    implements Ops.Math.RightShift {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a >> this.b;
        }
    }

    @Plugin(type=Ops.Math.LeftShift.class, priority=0.4)
    public static class IntegerLeftShift
    extends AbstractOp
    implements Ops.Math.LeftShift {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a << this.b;
        }
    }

    @Plugin(type=Ops.Math.Xor.class, priority=0.4)
    public static class IntegerXor
    extends AbstractOp
    implements Ops.Math.Xor {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a ^ this.b;
        }
    }

    @Plugin(type=Ops.Math.Or.class, priority=0.4)
    public static class IntegerOr
    extends AbstractOp
    implements Ops.Math.Or {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a | this.b;
        }
    }

    @Plugin(type=Ops.Math.And.class, priority=0.4)
    public static class IntegerAnd
    extends AbstractOp
    implements Ops.Math.And {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a & this.b;
        }
    }

    @Plugin(type=Ops.Math.Remainder.class, priority=0.4)
    public static class IntegerRemainder
    extends AbstractOp
    implements Ops.Math.Remainder {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a % this.b;
        }
    }

    @Plugin(type=Ops.Math.Divide.class, priority=0.4)
    public static class IntegerDivide
    extends AbstractOp
    implements Ops.Math.Divide {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a / this.b;
        }
    }

    @Plugin(type=Ops.Math.Multiply.class, priority=0.4)
    public static class IntegerMultiply
    extends AbstractOp
    implements Ops.Math.Multiply {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a * this.b;
        }
    }

    @Plugin(type=Ops.Math.Subtract.class, priority=0.4)
    public static class IntegerSubtract
    extends AbstractOp
    implements Ops.Math.Subtract {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a - this.b;
        }
    }

    @Plugin(type=Ops.Math.Add.class, priority=0.4)
    public static class IntegerAdd
    extends AbstractOp
    implements Ops.Math.Add {
        @Parameter(type=ItemIO.OUTPUT)
        private int result;
        @Parameter
        private int a;
        @Parameter
        private int b;

        public void run() {
            this.result = this.a + this.b;
        }
    }
}

