/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.special.chain.RTs;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.GeometricMean.class, label="Statistics: GeometricMean")
public class DefaultGeometricMean<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.GeometricMean {
    private UnaryFunctionOp<Iterable<I>, O> sizeFunc;
    private UnaryFunctionOp<Iterable<I>, O> sumOfLogsFunc;

    @Override
    public void initialize() {
        this.sumOfLogsFunc = RTs.function(this.ops(), Ops.Stats.SumOfLogs.class, this.in(), new Object[0]);
        this.sizeFunc = RTs.function(this.ops(), Ops.Stats.Size.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Iterable<I> input, O output) {
        double size = ((RealType)this.sizeFunc.calculate(input)).getRealDouble();
        double sumOfLogs = ((RealType)this.sumOfLogsFunc.calculate(input)).getRealDouble();
        if (size != 0.0) {
            output.setReal(Math.exp(sumOfLogs / size));
        } else {
            output.setReal(0.0f);
        }
    }
}

