/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.HarmonicMean.class, label="Statistics: Harmonic Mean", priority=10000.0)
public class IterableHarmonicMean<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.HarmonicMean {
    @Override
    public void compute(Iterable<I> input, O output) {
        double size = 0.0;
        double sumOfInverses = 0.0;
        for (RealType in : input) {
            size += 1.0;
            sumOfInverses += 1.0 / in.getRealDouble();
        }
        if (sumOfInverses != 0.0) {
            output.setReal(size / sumOfInverses);
        } else {
            output.setReal(0.0f);
        }
    }
}

